/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.datagen;

import java.util.LinkedHashMap;
import java.util.Locale;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.stirdrem.overgeared.item.ModItems;

public class ModItemModelProvider
extends ItemModelProvider {
    private static LinkedHashMap<ResourceKey<TrimMaterial>, Float> trimMaterials = new LinkedHashMap();

    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "overgeared", existingFileHelper);
    }

    protected void registerModels() {
        this.simpleItem(ModItems.CRUDE_STEEL);
        this.simpleItem(ModItems.HEATED_CRUDE_STEEL);
        this.simpleItem(ModItems.ROCK);
        this.simpleItem(ModItems.STEEL_INGOT);
        this.simpleItem(ModItems.STEEL_NUGGET);
        this.simpleItem(ModItems.COPPER_NUGGET);
        this.simpleItem(ModItems.DIAMOND_SHARD);
        this.simpleItem(ModItems.IRON_ARROW_HEAD);
        this.simpleItem(ModItems.STEEL_ARROW_HEAD);
        this.upgradeArrowModel(ModItems.IRON_UPGRADE_ARROW);
        this.upgradeArrowModel(ModItems.STEEL_UPGRADE_ARROW);
        this.upgradeArrowModel(ModItems.DIAMOND_UPGRADE_ARROW);
        this.simpleItem(ModItems.HEATED_COPPER_INGOT);
        this.simpleItem(ModItems.HEATED_IRON_INGOT);
        this.simpleItem(ModItems.HEATED_STEEL_INGOT);
        this.simpleItem(ModItems.COPPER_PLATE);
        this.simpleItem(ModItems.IRON_PLATE);
        this.simpleItem(ModItems.STEEL_PLATE);
        this.simpleItem(ModItems.STEEL_TONG);
        this.simpleItem(ModItems.IRON_TONG);
        this.simpleItem(ModItems.DIAMOND_UPGRADE_SMITHING_TEMPLATE);
        this.simpleItem(ModItems.EMPTY_BLUEPRINT);
        this.simpleItem(ModItems.BLUEPRINT);
        this.trimmedArmorItem(ModItems.STEEL_HELMET);
        this.trimmedArmorItem(ModItems.STEEL_BOOTS);
        this.trimmedArmorItem(ModItems.STEEL_CHESTPLATE);
        this.trimmedArmorItem(ModItems.STEEL_LEGGINGS);
        this.trimmedArmorItem(ModItems.COPPER_HELMET);
        this.trimmedArmorItem(ModItems.COPPER_CHESTPLATE);
        this.trimmedArmorItemWithOverlay(ModItems.COPPER_LEGGINGS);
        this.trimmedArmorItem(ModItems.COPPER_BOOTS);
        this.simpleHandheld(ModItems.IRON_TONGS);
        this.simpleHandheld(ModItems.STEEL_TONGS);
        this.simpleHandheld(ModItems.WOODEN_TONGS);
        this.simpleHandheld(ModItems.SMITHING_HAMMER);
        this.simpleHandheld(ModItems.COPPER_SMITHING_HAMMER);
        this.simpleHandheld(ModItems.STEEL_SWORD);
        this.simpleHandheld(ModItems.STEEL_PICKAXE);
        this.simpleHandheld(ModItems.STEEL_AXE);
        this.simpleHandheld(ModItems.STEEL_SHOVEL);
        this.simpleHandheld(ModItems.STEEL_HOE);
        this.simpleHandheld(ModItems.COPPER_SWORD);
        this.simpleHandheld(ModItems.COPPER_PICKAXE);
        this.simpleHandheld(ModItems.COPPER_AXE);
        this.simpleHandheld(ModItems.COPPER_SHOVEL);
        this.simpleHandheld(ModItems.COPPER_HOE);
        this.simpleItem(ModItems.STONE_SWORD_BLADE);
        this.simpleItem(ModItems.IRON_SWORD_BLADE);
        this.simpleItem(ModItems.GOLDEN_SWORD_BLADE);
        this.simpleItem(ModItems.STEEL_SWORD_BLADE);
        this.simpleItem(ModItems.COPPER_SWORD_BLADE);
        this.simpleItem(ModItems.STONE_PICKAXE_HEAD);
        this.simpleItem(ModItems.IRON_PICKAXE_HEAD);
        this.simpleItem(ModItems.GOLDEN_PICKAXE_HEAD);
        this.simpleItem(ModItems.STEEL_PICKAXE_HEAD);
        this.simpleItem(ModItems.COPPER_PICKAXE_HEAD);
        this.simpleItem(ModItems.STONE_AXE_HEAD);
        this.simpleItem(ModItems.IRON_AXE_HEAD);
        this.simpleItem(ModItems.GOLDEN_AXE_HEAD);
        this.simpleItem(ModItems.STEEL_AXE_HEAD);
        this.simpleItem(ModItems.COPPER_AXE_HEAD);
        this.simpleItem(ModItems.STONE_SHOVEL_HEAD);
        this.simpleItem(ModItems.IRON_SHOVEL_HEAD);
        this.simpleItem(ModItems.GOLDEN_SHOVEL_HEAD);
        this.simpleItem(ModItems.STEEL_SHOVEL_HEAD);
        this.simpleItem(ModItems.COPPER_SHOVEL_HEAD);
        this.simpleItem(ModItems.STONE_HOE_HEAD);
        this.simpleItem(ModItems.IRON_HOE_HEAD);
        this.simpleItem(ModItems.GOLDEN_HOE_HEAD);
        this.simpleItem(ModItems.STEEL_HOE_HEAD);
        this.simpleItem(ModItems.COPPER_HOE_HEAD);
    }

    private void trimmedArmorItem(RegistryObject<Item> itemRegistryObject) {
        String MOD_ID = "overgeared";
        Object object = itemRegistryObject.get();
        if (object instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)object;
            trimMaterials.entrySet().forEach(entry -> {
                ResourceKey trimMaterial = (ResourceKey)entry.getKey();
                float trimValue = ((Float)entry.getValue()).floatValue();
                String armorType = switch (armorItem.m_40402_()) {
                    case EquipmentSlot.HEAD -> "helmet";
                    case EquipmentSlot.CHEST -> "chestplate";
                    case EquipmentSlot.LEGS -> "leggings";
                    case EquipmentSlot.FEET -> "boots";
                    default -> "";
                };
                String armorItemPath = "item/" + armorItem;
                String trimPath = "trims/items/" + armorType + "_trim_" + trimMaterial.m_135782_().m_135815_();
                String currentTrimName = armorItemPath + "_" + trimMaterial.m_135782_().m_135815_() + "_trim";
                ResourceLocation armorItemResLoc = ResourceLocation.m_214293_((String)"overgeared", (String)armorItemPath);
                ResourceLocation trimResLoc = ResourceLocation.m_135820_((String)trimPath);
                ResourceLocation trimNameResLoc = ResourceLocation.m_214293_((String)"overgeared", (String)currentTrimName);
                this.existingFileHelper.trackGenerated(trimResLoc, PackType.CLIENT_RESOURCES, ".png", "textures");
                ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(currentTrimName)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", armorItemResLoc)).texture("layer1", trimResLoc);
                ((ItemModelBuilder)this.withExistingParent(itemRegistryObject.getId().m_135815_(), this.mcLoc("item/generated"))).override().model((ModelFile)new ModelFile.UncheckedModelFile(trimNameResLoc)).predicate(this.mcLoc("trim_type"), trimValue).end().texture("layer0", ResourceLocation.m_214293_((String)"overgeared", (String)("item/" + itemRegistryObject.getId().m_135815_())));
            });
        }
    }

    private void trimmedArmorItemWithOverlay(RegistryObject<Item> itemRegistryObject) {
        String MOD_ID = "overgeared";
        Object object = itemRegistryObject.get();
        if (object instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)object;
            trimMaterials.entrySet().forEach(entry -> {
                ResourceKey trimMaterial = (ResourceKey)entry.getKey();
                float trimValue = ((Float)entry.getValue()).floatValue();
                String armorType = switch (armorItem.m_40402_()) {
                    case EquipmentSlot.HEAD -> "helmet";
                    case EquipmentSlot.CHEST -> "chestplate";
                    case EquipmentSlot.LEGS -> "leggings";
                    case EquipmentSlot.FEET -> "boots";
                    default -> "";
                };
                String armorItemPath = "item/" + itemRegistryObject.getId().m_135815_();
                String trimPath = "trims/items/" + armorType + "_trim_" + trimMaterial.m_135782_().m_135815_();
                String currentTrimName = armorItemPath + "_" + trimMaterial.m_135782_().m_135815_() + "_trim";
                ResourceLocation armorItemResLoc = ResourceLocation.m_214293_((String)"overgeared", (String)armorItemPath);
                ResourceLocation overlayResLoc = ResourceLocation.m_214293_((String)"overgeared", (String)(armorItemPath + "_overlay"));
                ResourceLocation trimResLoc = ResourceLocation.m_135820_((String)trimPath);
                ResourceLocation trimNameResLoc = ResourceLocation.m_214293_((String)"overgeared", (String)currentTrimName);
                this.existingFileHelper.trackGenerated(trimResLoc, PackType.CLIENT_RESOURCES, ".png", "textures");
                ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(currentTrimName)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", armorItemResLoc)).texture("layer1", trimResLoc)).texture("layer2", overlayResLoc);
                ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(itemRegistryObject.getId().m_135815_(), this.mcLoc("item/generated"))).texture("layer0", armorItemResLoc)).texture("layer1", overlayResLoc)).override().model((ModelFile)new ModelFile.UncheckedModelFile(trimNameResLoc)).predicate(this.mcLoc("trim_type"), trimValue).end();
            });
        }
    }

    private String getToolTypeFromName(String itemName) {
        if ((itemName = itemName.toLowerCase(Locale.ROOT)).contains("sword")) {
            return "sword";
        }
        if (itemName.contains("axe")) {
            return "axe";
        }
        if (itemName.contains("pickaxe")) {
            return "pickaxe";
        }
        if (itemName.contains("shovel")) {
            return "shovel";
        }
        if (itemName.contains("hoe")) {
            return "hoe";
        }
        return "generic";
    }

    private void polishItem(RegistryObject<Item> itemRegistryObject) {
        String MOD_ID = "overgeared";
        Item item = (Item)itemRegistryObject.get();
        String itemPath = itemRegistryObject.getId().m_135815_();
        String toolType = this.getToolTypeFromName(itemPath);
        ResourceLocation baseTexture = ResourceLocation.m_214293_((String)"overgeared", (String)("item/" + itemPath));
        ResourceLocation overlayTexture = ResourceLocation.m_214293_((String)"overgeared", (String)("item/unpolished_overlay/" + toolType));
        ResourceLocation unpolishedModelLoc = ResourceLocation.m_214293_((String)"overgeared", (String)("item/" + itemPath + "_unpolished"));
        this.existingFileHelper.trackGenerated(overlayTexture, PackType.CLIENT_RESOURCES, ".png", "textures");
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(unpolishedModelLoc.m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", baseTexture)).texture("layer1", overlayTexture);
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(itemPath)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", baseTexture)).override().model((ModelFile)new ModelFile.UncheckedModelFile(unpolishedModelLoc)).predicate(ResourceLocation.m_214293_((String)"overgeared", (String)"polished"), 0.0f).end();
    }

    private ItemModelBuilder simpleItem(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), ResourceLocation.m_135820_((String)"item/generated"))).texture("layer0", ResourceLocation.m_214293_((String)"overgeared", (String)("item/" + item.getId().m_135815_())));
    }

    private ItemModelBuilder simpleHandheld(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), ResourceLocation.m_135820_((String)"item/handheld"))).texture("layer0", ResourceLocation.m_214293_((String)"overgeared", (String)("item/" + item.getId().m_135815_())));
    }

    public void evenSimplerBlockItem(RegistryObject<Block> block) {
        this.withExistingParent("overgeared:" + ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.modLoc("block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_()));
    }

    public void trapdoorItem(RegistryObject<Block> block) {
        this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.modLoc("block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_() + "_bottom"));
    }

    public void fenceItem(RegistryObject<Block> block, RegistryObject<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.mcLoc("block/fence_inventory"))).texture("texture", ResourceLocation.m_214293_((String)"overgeared", (String)("block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)baseBlock.get())).m_135815_())));
    }

    public void buttonItem(RegistryObject<Block> block, RegistryObject<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.mcLoc("block/button_inventory"))).texture("texture", ResourceLocation.m_214293_((String)"overgeared", (String)("block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)baseBlock.get())).m_135815_())));
    }

    public void wallItem(RegistryObject<Block> block, RegistryObject<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.mcLoc("block/wall_inventory"))).texture("wall", ResourceLocation.m_214293_((String)"overgeared", (String)("block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)baseBlock.get())).m_135815_())));
    }

    private ItemModelBuilder handheldItem(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), ResourceLocation.m_135820_((String)"item/handheld"))).texture("layer0", ResourceLocation.m_214293_((String)"overgeared", (String)("item/" + item.getId().m_135815_())));
    }

    private ItemModelBuilder simpleBlockItem(RegistryObject<Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), ResourceLocation.m_135820_((String)"item/generated"))).texture("layer0", ResourceLocation.m_214293_((String)"overgeared", (String)("item/" + item.getId().m_135815_())));
    }

    private ItemModelBuilder simpleBlockItemBlockTexture(RegistryObject<Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), ResourceLocation.m_135820_((String)"item/generated"))).texture("layer0", ResourceLocation.m_214293_((String)"overgeared", (String)("block/" + item.getId().m_135815_())));
    }

    private void upgradeArrowModel(RegistryObject<Item> item) {
        String baseName = item.getId().m_135815_();
        String head = "item/" + baseName;
        String tippedHead = "item/tipped_" + baseName + "_head";
        String tippedBase = "item/tipped_" + baseName + "_base";
        String lingeringHead = "item/lingering_" + baseName + "_head";
        String lingeringBase = "item/lingering_" + baseName + "_base";
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(baseName)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.modLoc(head))).override().predicate(new ResourceLocation("overgeared", "potion_type"), 1.0f).model((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("item/" + baseName + "_tipped"))).end().override().predicate(new ResourceLocation("overgeared", "potion_type"), 2.0f).model((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("item/" + baseName + "_lingering"))).end();
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(baseName + "_tipped")).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.modLoc(tippedHead))).texture("layer1", this.modLoc(tippedBase));
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(baseName + "_lingering")).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.modLoc(lingeringHead))).texture("layer1", this.modLoc(lingeringBase));
    }

    static {
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265905_, Float.valueOf(0.1f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266000_, Float.valueOf(0.2f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265896_, Float.valueOf(0.3f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265870_, Float.valueOf(0.4f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265969_, Float.valueOf(0.5f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265937_, Float.valueOf(0.6f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266071_, Float.valueOf(0.7f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_266027_, Float.valueOf(0.8f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265981_, Float.valueOf(0.9f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.f_265872_, Float.valueOf(1.0f));
    }
}

