/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.stirdrem.overgeared.config.ServerConfig;
import net.stirdrem.overgeared.item.ToolType;

public class ToolTypeRegistry {
    private static final List<ToolType> DEFAULT_TYPES = List.of(ToolType.SWORD, ToolType.AXE, ToolType.PICKAXE, ToolType.SHOVEL, ToolType.HOE, ToolType.MULTITOOL);
    private static final List<ToolType> CUSTOM_TYPES = new ArrayList<ToolType>();
    private static final List<ToolType> HIDDEN_CUSTOM_TYPES = new ArrayList<ToolType>();
    private static final Map<String, ToolType> BY_ID = new HashMap<String, ToolType>();

    public static void init() {
        CUSTOM_TYPES.clear();
        BY_ID.clear();
        DEFAULT_TYPES.forEach(type -> {
            BY_ID.put(type.getId().toUpperCase(Locale.ROOT), (ToolType)type);
            System.out.println("Registered default tool type: " + type.getId());
        });
        List customPairs = (List)ServerConfig.CUSTOM_TOOL_TYPES.get();
        for (int i = 0; i < customPairs.size() && i + 1 < customPairs.size(); i += 2) {
            String typeId = (String)customPairs.get(i);
            String displayName = (String)customPairs.get(i + 1);
            try {
                ToolType newType = new ToolType(typeId, displayName, false);
                ToolTypeRegistry.register(newType);
                System.out.println("Registered custom tool type: " + newType.getId());
                continue;
            }
            catch (IllegalArgumentException e) {
                System.err.println("Invalid tool type definition: " + typeId + " - " + e.getMessage());
            }
        }
        List hiddenPairs = (List)ServerConfig.HIDDEN_TOOL_TYPES.get();
        for (int i = 0; i < hiddenPairs.size() && i + 1 < hiddenPairs.size(); i += 2) {
            String typeId = (String)hiddenPairs.get(i);
            String displayName = (String)hiddenPairs.get(i + 1);
            try {
                ToolType hiddenType = new ToolType(typeId, displayName, false);
                ToolTypeRegistry.registerHidden(hiddenType);
                System.out.println("Registered hidden tool type: " + hiddenType.getId());
                continue;
            }
            catch (IllegalArgumentException e) {
                System.err.println("Invalid hidden tool type definition: " + typeId + " - " + e.getMessage());
            }
        }
        System.out.println("Currently registered tool types: " + BY_ID.keySet().stream().collect(Collectors.joining(", ")));
    }

    public static void register(ToolType type) {
        String upperId = type.getId().toUpperCase(Locale.ROOT);
        if (!BY_ID.containsKey(upperId)) {
            BY_ID.put(upperId, type);
            CUSTOM_TYPES.add(type);
        }
    }

    public static void registerHidden(ToolType type) {
        String upperId = type.getId().toUpperCase(Locale.ROOT);
        if (!BY_ID.containsKey(upperId)) {
            BY_ID.put(upperId, type);
            HIDDEN_CUSTOM_TYPES.add(type);
        }
    }

    public static List<ToolType> getRegisteredTypes() {
        ArrayList<ToolType> allTypes = new ArrayList<ToolType>();
        List availableTypes = (List)ServerConfig.AVAILABLE_TOOL_TYPES.get();
        DEFAULT_TYPES.stream().filter(type -> availableTypes.contains(type.getId())).forEach(allTypes::add);
        allTypes.addAll(CUSTOM_TYPES);
        return allTypes;
    }

    public static List<ToolType> getRegisteredTypesAll() {
        ArrayList<ToolType> allTypes = new ArrayList<ToolType>();
        List availableTypes = (List)ServerConfig.AVAILABLE_TOOL_TYPES.get();
        DEFAULT_TYPES.stream().filter(type -> availableTypes.contains(type.getId())).forEach(allTypes::add);
        allTypes.addAll(CUSTOM_TYPES);
        allTypes.addAll(HIDDEN_CUSTOM_TYPES);
        return allTypes;
    }

    public static Optional<ToolType> byId(String id) {
        if (id == null) {
            return Optional.empty();
        }
        ToolType type = BY_ID.get(id.toUpperCase(Locale.ROOT));
        return Optional.ofNullable(type);
    }
}

