/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.item.custom;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.stirdrem.overgeared.entity.ArrowTier;
import net.stirdrem.overgeared.entity.custom.UpgradeArrowEntity;

public class LingeringArrowItem
extends ArrowItem {
    private final ArrowTier tier;

    public LingeringArrowItem(Item.Properties properties, ArrowTier tier) {
        super(properties);
        this.tier = tier;
    }

    public ItemStack m_7968_() {
        return PotionUtils.m_43549_((ItemStack)super.m_7968_(), (Potion)Potions.f_43584_);
    }

    public AbstractArrow m_6394_(Level level, ItemStack stack, LivingEntity shooter) {
        return new UpgradeArrowEntity(this.tier, level, shooter, stack);
    }

    public ArrowTier getTier() {
        return this.tier;
    }

    public boolean isInfinite(ItemStack stack, ItemStack bow, Player player) {
        return false;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        CompoundTag tag = pStack.m_41783_();
        if (tag != null && (tag.m_128441_("Potion") || tag.m_128441_("CustomPotionEffects"))) {
            PotionUtils.m_43555_((ItemStack)pStack, pTooltip, (float)0.125f);
        }
    }

    public static List<MobEffectInstance> getMobEffects(ItemStack pStack) {
        return LingeringArrowItem.getAllEffects(pStack.m_41783_());
    }

    public static Potion getPotion(@Nullable CompoundTag tag) {
        if (tag == null) {
            return Potions.f_43598_;
        }
        if (tag.m_128425_("Potion", 8)) {
            return Potion.m_43489_((String)tag.m_128461_("Potion"));
        }
        return Potions.f_43598_;
    }

    public static List<MobEffectInstance> getAllEffects(@Nullable CompoundTag pCompoundTag) {
        ArrayList list = Lists.newArrayList();
        list.addAll(LingeringArrowItem.getPotion(pCompoundTag).m_43488_());
        LingeringArrowItem.getCustomEffects(pCompoundTag, list);
        return list;
    }

    public static void getCustomEffects(@Nullable CompoundTag pCompoundTag, List<MobEffectInstance> pEffectList) {
        if (pCompoundTag != null && pCompoundTag.m_128425_("CustomPotionEffects", 9)) {
            ListTag listtag = pCompoundTag.m_128437_("CustomPotionEffects", 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundtag = listtag.m_128728_(i);
                MobEffectInstance mobeffectinstance = MobEffectInstance.m_19560_((CompoundTag)compoundtag);
                if (mobeffectinstance == null) continue;
                pEffectList.add(mobeffectinstance);
            }
        }
    }

    public Component m_7626_(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            Potion potion;
            boolean hasEffects;
            List<MobEffectInstance> effects = LingeringArrowItem.getAllEffects(tag);
            boolean bl = hasEffects = !effects.isEmpty();
            if (hasEffects && (potion = LingeringArrowItem.getPotion(tag)) != Potions.f_43598_) {
                boolean isNoEffectPotion;
                String potionId = potion.m_43492_("").replace("effect.minecraft.", "");
                boolean bl2 = isNoEffectPotion = potionId.equals("mundane") || potionId.equals("awkward") || potionId.equals("thick");
                if (!isNoEffectPotion) {
                    String effectKey = "item.overgeared.arrow.effect." + potionId;
                    MutableComponent effectComponent = Component.m_237115_((String)effectKey);
                    return Component.m_237110_((String)this.m_5671_(stack), (Object[])new Object[]{effectComponent});
                }
            }
            return Component.m_237115_((String)(this.m_5671_(stack) + ".no_effect"));
        }
        return Component.m_237115_((String)this.m_5671_(stack));
    }
}

