/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.screen;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.stirdrem.overgeared.item.custom.KnappableRockItem;
import net.stirdrem.overgeared.recipe.ModRecipeTypes;
import net.stirdrem.overgeared.recipe.RockKnappingRecipe;
import net.stirdrem.overgeared.screen.ModMenuTypes;

public class RockKnappingMenu
extends AbstractContainerMenu {
    private final Container craftingGrid = new SimpleContainer(9);
    private final Container resultContainer = new SimpleContainer(1);
    private final Level level;
    private final RecipeManager recipeManager;
    private final Player player;
    private ItemStack inputRock;
    private boolean knappingFinished = false;
    private boolean resultCollected = false;
    private boolean rockConsumed = false;

    public boolean isResultCollected() {
        return this.resultCollected;
    }

    public void markResultCollected() {
        this.resultCollected = true;
    }

    public RockKnappingMenu(int id, Inventory playerInv, FriendlyByteBuf extraData) {
        this(id, playerInv, playerInv.f_35978_.m_9236_().m_7465_(), playerInv.f_35978_.m_21205_(), playerInv.f_35978_.m_21206_());
    }

    public RockKnappingMenu(int id, Inventory playerInv, RecipeManager recipeManager, ItemStack mainHandItem, ItemStack offHandItem) {
        super((MenuType)ModMenuTypes.ROCK_KNAPPING_MENU.get(), id);
        if (!(mainHandItem.m_41720_() instanceof KnappableRockItem) || !(offHandItem.m_41720_() instanceof KnappableRockItem)) {
            playerInv.f_35978_.m_6915_();
        }
        this.level = playerInv.f_35978_.m_9236_();
        this.recipeManager = recipeManager;
        this.player = playerInv.f_35978_;
        ItemStack itemStack = mainHandItem.m_41720_() instanceof KnappableRockItem ? mainHandItem.m_41777_() : (this.inputRock = offHandItem.m_41720_() instanceof KnappableRockItem ? offHandItem.m_41777_() : ItemStack.f_41583_);
        if (this.inputRock.m_41619_()) {
            playerInv.f_35978_.m_6915_();
            return;
        }
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot(this.craftingGrid, i, 10000, 10000){

                public boolean m_5857_(ItemStack stack) {
                    return false;
                }
            });
        }
        this.m_38897_(new Slot(this.resultContainer, 0, 124, 35){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public void m_142406_(Player player, ItemStack stack) {
                RockKnappingMenu.this.knappingFinished = true;
                RockKnappingMenu.this.markResultCollected();
                super.m_142406_(player, stack);
            }

            public boolean m_8010_(Player player) {
                return !this.m_7993_().m_41619_();
            }
        });
        this.addPlayerHotbar(playerInv);
        this.addPlayerInventory(playerInv);
    }

    private void addPlayerInventory(Inventory playerInv) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInv, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInv) {
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInv, col, 8 + col * 18, 142));
        }
    }

    public void handleResultCollection(Player player, ItemStack result) {
        if (player instanceof ServerPlayer) {
            this.knappingFinished = true;
        }
    }

    public boolean m_6875_(Player player) {
        if (!this.rockConsumed) {
            return this.hasInputRock(player);
        }
        return true;
    }

    private boolean hasInputRock(Player player) {
        if (ItemStack.m_150942_((ItemStack)player.m_21205_(), (ItemStack)this.inputRock) && ItemStack.m_150942_((ItemStack)player.m_21206_(), (ItemStack)this.inputRock)) {
            return true;
        }
        if (!player.m_9236_().f_46443_) {
            player.m_6915_();
        }
        return false;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index == 9) {
                this.knappingFinished = true;
                if (!this.m_38903_(itemstack1, 10, 46, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
                if (itemstack1.m_41619_()) {
                    slot.m_5852_(ItemStack.f_41583_);
                } else {
                    slot.m_6654_();
                }
                this.markResultCollected();
                return itemstack;
            }
            if (index >= 10 && index < 46 && (index < 37 ? !this.m_38903_(itemstack1, 37, 46, false) : !this.m_38903_(itemstack1, 10, 37, false))) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
        }
        return itemstack;
    }

    public void setChip(int index) {
        if (this.knappingFinished || this.resultCollected) {
            return;
        }
        if (!this.rockConsumed) {
            this.consumeInputRock();
            this.rockConsumed = true;
        }
        if (this.isChipped(index)) {
            this.craftingGrid.m_6836_(index, ItemStack.f_41583_);
        } else {
            this.craftingGrid.m_6836_(index, new ItemStack((ItemLike)Items.f_42484_));
        }
        this.updateResult();
    }

    private void consumeInputRock() {
        if (this.level.f_46443_) {
            return;
        }
        ItemStack mainHand = this.player.m_21205_();
        if (ItemStack.m_150942_((ItemStack)mainHand, (ItemStack)this.inputRock)) {
            mainHand.m_41774_(1);
        }
    }

    private void updateResult() {
        if (this.level == null || this.knappingFinished || this.resultCollected) {
            return;
        }
        RockKnappingRecipe matchingRecipe = this.recipeManager.m_44015_((RecipeType)ModRecipeTypes.KNAPPING.get(), this.craftingGrid, this.level).orElse(null);
        if (matchingRecipe != null && !this.knappingFinished) {
            this.resultContainer.m_6836_(0, matchingRecipe.m_8043_(this.level.m_9598_()).m_41777_());
        } else {
            this.resultContainer.m_6836_(0, ItemStack.f_41583_);
        }
        this.m_38946_();
    }

    public boolean isChipped(int index) {
        if (this.level == null || this.knappingFinished || this.resultCollected) {
            return true;
        }
        return !this.craftingGrid.m_8020_(index).m_41619_();
    }

    public void clearGrid() {
        this.craftingGrid.m_6211_();
        this.resultContainer.m_6211_();
        this.m_38946_();
    }

    public boolean isKnappingFinished() {
        return this.knappingFinished;
    }

    public boolean hasAnyChippedSpots() {
        for (int i = 0; i < 9; ++i) {
            if (!this.isChipped(i)) continue;
            return true;
        }
        return false;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        ItemStack result = this.resultContainer.m_8020_(0);
        if (!(result.m_41619_() || this.resultCollected || player.m_150109_().m_36054_(result.m_41777_()))) {
            player.m_36176_(result.m_41777_(), false);
        }
        this.markResultCollected();
    }
}

