/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.ForgeConfigSpec;
import net.stirdrem.overgeared.config.BlacklistEditorScreen;
import net.stirdrem.overgeared.config.ServerConfig;

public class OvergearedConfigScreen
extends Screen {
    private final Screen parent;
    private CommentedFileConfig configFile;
    private ForgeConfigSpec configSpec;
    private double scrollPosition;
    private ConfigList configList;

    public OvergearedConfigScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Overgeared Configuration"));
        this.parent = parent;
        this.loadConfig();
    }

    private void loadConfig() {
        Path configPath = Minecraft.m_91087_().f_91069_.toPath().resolve("config").resolve("overgeared-common.toml");
        this.configFile = (CommentedFileConfig)CommentedFileConfig.builder((Path)configPath).sync().writingMode(WritingMode.REPLACE).preserveInsertionOrder().build();
        this.configFile.load();
        this.configSpec = ServerConfig.SERVER_CONFIG;
    }

    protected void m_7856_() {
        super.m_7856_();
        int listWidth = this.f_96543_;
        int listHeight = this.f_96544_ - 80;
        int listTop = 40;
        int listLeft = 0;
        this.configList = new ConfigList(Minecraft.m_91087_(), listWidth, listHeight, listTop, listTop + listHeight, 24);
        this.configList.m_93507_(listLeft);
        this.m_7787_((GuiEventListener)this.configList);
        this.buildEntries();
        int btnW = 200;
        int btnH = 20;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Done"), b -> {
            this.save();
            this.scrollPosition = this.configList.m_93517_();
            this.f_96541_.m_91152_(this.parent);
        }).m_252987_(this.f_96543_ / 2 - btnW / 2, this.f_96544_ - 30, btnW, btnH).m_253136_());
    }

    public void m_7379_() {
        super.m_7379_();
        if (this.configFile != null) {
            try {
                this.configFile.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void restoreScrollPosition() {
        if (this.configList != null && this.scrollPosition > 0.0) {
            this.configList.m_93410_(this.scrollPosition);
            this.scrollPosition = this.configList.m_93517_();
        }
    }

    private void buildEntries() {
        this.configList.m_93410_(this.scrollPosition);
        this.buildGeneralConfigs();
        this.buildLootQuality();
        this.buildAnvilForging();
        this.buildQualitySettings();
        this.buildForgingZones();
        this.buildWeaponBonuses();
        this.buildArmorBonuses();
        this.buildDurabilityBonuses();
        this.buildHeatedItems();
        this.buildGrindingDurability();
        this.buildQualityFailure();
        this.buildBlueprintSettings();
        this.buildKnapping();
        this.buildCasting();
    }

    private void buildGeneralConfigs() {
        this.configList.addConfigEntry(new HeaderEntry("General Configs"));
        this.configList.addConfigEntry(new BooleanEntry("Enable the mod's custom tooltips", () -> this.getBoolean("General Configs.enableModTooltips"), v -> this.setBoolean("General Configs.enableModTooltips", (boolean)v)));
    }

    private void buildLootQuality() {
        this.configList.addConfigEntry(new HeaderEntry("Loot Quality"));
        this.configList.addConfigEntry(new BooleanEntry("Enable Loot to have quality", () -> this.getBoolean("Loot Quality.enableLootQuality"), v -> this.setBoolean("Loot Quality.enableLootQuality", (boolean)v)));
        this.configList.addConfigEntry(new IntEntry("Poor Quality Weight", () -> this.getInt("Loot Quality.weightPoorQuality"), v -> this.setInt("Loot Quality.weightPoorQuality", (int)v), 0, 100));
        this.configList.addConfigEntry(new IntEntry("Well Quality Weight", () -> this.getInt("Loot Quality.weightWellQuality"), v -> this.setInt("Loot Quality.weightWellQuality", (int)v), 0, 100));
        this.configList.addConfigEntry(new IntEntry("Expert Quality Weight", () -> this.getInt("Loot Quality.weightExpertQuality"), v -> this.setInt("Loot Quality.weightExpertQuality", (int)v), 0, 100));
        this.configList.addConfigEntry(new IntEntry("Perfect Quality Weight", () -> this.getInt("Loot Quality.weightPerfectQuality"), v -> this.setInt("Loot Quality.weightPerfectQuality", (int)v), 0, 100));
        this.configList.addConfigEntry(new IntEntry("Master Quality Weight", () -> this.getInt("Loot Quality.weightMasterQuality"), v -> this.setInt("Loot Quality.weightMasterQuality", (int)v), 0, 100));
    }

    private void buildAnvilForging() {
        this.configList.addConfigEntry(new HeaderEntry("Anvil & Forging"));
        this.configList.addConfigEntry(new BooleanEntry("Enable Forging Minigame", () -> this.getBoolean("Minigame Common Settings.enableMinigame"), v -> this.setBoolean("Minigame Common Settings.enableMinigame", (boolean)v)));
        this.configList.addConfigEntry(new BooleanEntry("Convert Stone to Stone Smithing Anvil", () -> this.getBoolean("Anvil Conversion.enableStoneToAnvil"), v -> this.setBoolean("Anvil Conversion.enableStoneToAnvil", (boolean)v)));
        this.configList.addConfigEntry(new BooleanEntry("Convert Vanilla Anvil to Smithing Anvil", () -> this.getBoolean("Anvil Conversion.enableAnvilToSmithing"), v -> this.setBoolean("Anvil Conversion.enableAnvilToSmithing", (boolean)v)));
        this.configList.addConfigEntry(new BooleanEntry("Enable Fletching", () -> this.getBoolean("Arrow Fletching Settings.enableFletchingRecipes"), v -> this.setBoolean("Arrow Fletching Settings.enableFletchingRecipes", (boolean)v)));
        this.configList.addConfigEntry(new BooleanEntry("Enable Arrow Tipping", () -> this.getBoolean("Arrow Fletching Settings.enableUpgradeArrowTipping"), v -> this.setBoolean("Arrow Fletching Settings.enableUpgradeArrowTipping", (boolean)v)));
        this.configList.addConfigEntry(new BooleanEntry("Enable Dragon Breath Recipe", () -> this.getBoolean("Arrow Fletching Settings.enableDragonBreathRecipe"), v -> this.setBoolean("Arrow Fletching Settings.enableDragonBreathRecipe", (boolean)v)));
        this.configList.addConfigEntry(new ManualInputEntry("How many time a potion bottle can be used for tipping", () -> this.getInt("Arrow Fletching Settings.maxPotionTipping"), v -> this.setInt("Arrow Fletching Settings.maxPotionTipping", v.intValue()), true));
        this.configList.addConfigEntry(new ManualInputEntry("How many uses the Stone Anvil has before breaking", () -> this.getInt("Stone Smithing Anvil.max_uses"), v -> this.setInt("Stone Smithing Anvil.max_uses", v.intValue()), true));
        this.configList.addConfigEntry(new IntEntry("Max distance from the anvil until minigame resets", () -> this.getInt("Minigame Common Settings.maxAnvilDistance"), v -> this.setInt("Minigame Common Settings.maxAnvilDistance", (int)v), 0, 1000));
        this.configList.addConfigEntry(new BooleanEntry("Enable adding the maker's name to result", () -> this.getBoolean("Minigame Common Settings.enableAuthorTooltips"), v -> this.setBoolean("Minigame Common Settings.enableAuthorTooltips", (boolean)v)));
    }

    private void buildQualitySettings() {
        this.configList.addConfigEntry(new HeaderEntry("Quality Settings"));
        this.configList.addConfigEntry(new BooleanEntry("Ingredients' quality cap result's quality", () -> this.getBoolean("Minigame Common Settings.ingredientsDefineQuality"), v -> this.setBoolean("Minigame Common Settings.ingredientsDefineQuality", (boolean)v)));
        this.configList.addConfigEntry(new DoubleEntry("Chance for Master ingredient results in Master result", () -> this.getDouble("Minigame Common Settings.masterFromIngredientChance"), v -> this.setDouble("Minigame Common Settings.masterFromIngredientChance", (double)v), 0.0, 1.0));
        this.configList.addConfigEntry(new DoubleEntry("Well Quality Score", () -> this.getDouble("Minigame Common Settings.wellQualityScore"), v -> this.setDouble("Minigame Common Settings.wellQualityScore", (double)v), 0.0, 1.0));
        this.configList.addConfigEntry(new DoubleEntry("Expert Quality Score", () -> this.getDouble("Minigame Common Settings.expertQualityScore"), v -> this.setDouble("Minigame Common Settings.expertQualityScore", (double)v), 0.0, 1.0));
        this.configList.addConfigEntry(new DoubleEntry("Perfect Quality Score", () -> this.getDouble("Minigame Common Settings.perfectQualityScore"), v -> this.setDouble("Minigame Common Settings.perfectQualityScore", (double)v), 0.0, 1.0));
        this.configList.addConfigEntry(new DoubleEntry("How likely it is to get Masterwork", () -> this.getDouble("Minigame Common Settings.masterQualityChance"), v -> this.setDouble("Minigame Common Settings.masterQualityChance", (double)v), 0.0, 1.0));
    }

    private void buildForgingZones() {
        this.buildForgingZone("Default", "Default (No Blueprint)");
        this.buildForgingZone("Poor", "Poorly Forged");
        this.buildForgingZone("Well", "Well Forged");
        this.buildForgingZone("Expert", "Expertly Forged");
        this.buildForgingZone("Perfect", "Perfectly Forged");
        this.buildForgingZone("Master", "Masterwork");
    }

    private void buildForgingZone(String quality, String configPath) {
        this.configList.addConfigEntry(new HeaderEntry("Minigame Config - " + quality));
        this.configList.addConfigEntry(new IntEntry(quality + " Zone Starting Size", () -> this.getInt(configPath + ".zoneStartingSize"), v -> this.setInt(configPath + ".zoneStartingSize", (int)v), 0, 100));
        this.configList.addConfigEntry(new DoubleEntry(quality + " Zone Shrink Factor", () -> this.getDouble(configPath + ".zoneShrinkFactor"), v -> this.setDouble(configPath + ".zoneShrinkFactor", (double)v), 0.0, 1.0));
        this.configList.addConfigEntry(new IntEntry(quality + " Min Perfect Zone", () -> this.getInt(configPath + ".minPerfectZone"), v -> this.setInt(configPath + ".minPerfectZone", (int)v), 0, 100));
        this.configList.addConfigEntry(new DoubleEntry(quality + " Arrow Speed", () -> this.getDouble(configPath + ".arrowSpeed"), v -> this.setDouble(configPath + ".arrowSpeed", (double)v), -5.0, 5.0));
        this.configList.addConfigEntry(new DoubleEntry(quality + " Arrow Speed Increase", () -> this.getDouble(configPath + ".arrowSpeedIncrease"), v -> this.setDouble(configPath + ".arrowSpeedIncrease", (double)v), -5.0, 5.0));
        this.configList.addConfigEntry(new DoubleEntry(quality + " Max Arrow Speed", () -> this.getDouble(configPath + ".maxArrowSpeed"), v -> this.setDouble(configPath + ".maxArrowSpeed", (double)v), 0.0, 10.0));
    }

    private void buildWeaponBonuses() {
        this.configList.addConfigEntry(new HeaderEntry("Weapon Bonuses"));
        this.buildWeaponBonus("Poor", "Weapon Bonuses.poorWeaponDamage", -10.0, 10.0);
        this.buildWeaponBonus("Well", "Weapon Bonuses.wellWeaponDamage", -10.0, 10.0);
        this.buildWeaponBonus("Expert", "Weapon Bonuses.expertWeaponDamage", -10.0, 10.0);
        this.buildWeaponBonus("Perfect", "Weapon Bonuses.perfectWeaponDamage", -10.0, 10.0);
        this.buildWeaponBonus("Master", "Weapon Bonuses.masterWeaponDamage", -10.0, 10.0);
        this.configList.addConfigEntry(new HeaderEntry(""));
        this.buildWeaponSpeedBonus("Poor", "Weapon Bonuses.poorWeaponSpeed", -2.0, 2.0);
        this.buildWeaponSpeedBonus("Well", "Weapon Bonuses.wellWeaponSpeed", -2.0, 2.0);
        this.buildWeaponSpeedBonus("Expert", "Weapon Bonuses.expertWeaponSpeed", -2.0, 2.0);
        this.buildWeaponSpeedBonus("Perfect", "Weapon Bonuses.perfectWeaponSpeed", -2.0, 2.0);
        this.buildWeaponSpeedBonus("Master", "Weapon Bonuses.masterWeaponSpeed", -2.0, 2.0);
    }

    private void buildWeaponBonus(String quality, String path, double min, double max) {
        this.configList.addConfigEntry(new DoubleEntry(quality + " Weapon Damage Addition", () -> this.getDouble(path), v -> this.setDouble(path, (double)v), min, max));
    }

    private void buildWeaponSpeedBonus(String quality, String path, double min, double max) {
        this.configList.addConfigEntry(new DoubleEntry(quality + " Weapon Speed Addition", () -> this.getDouble(path), v -> this.setDouble(path, (double)v), min, max));
    }

    private void buildArmorBonuses() {
        this.configList.addConfigEntry(new HeaderEntry("Armor Bonuses"));
        this.buildArmorBonus("Poor", "Armor Bonuses.poorArmorBonus", -5.0, 5.0);
        this.buildArmorBonus("Well", "Armor Bonuses.wellArmorBonus", -5.0, 5.0);
        this.buildArmorBonus("Expert", "Armor Bonuses.expertArmorBonus", -5.0, 5.0);
        this.buildArmorBonus("Perfect", "Armor Bonuses.perfectArmorBonus", -5.0, 5.0);
        this.buildArmorBonus("Master", "Armor Bonuses.masterArmorBonus", -5.0, 5.0);
    }

    private void buildArmorBonus(String quality, String path, double min, double max) {
        this.configList.addConfigEntry(new DoubleEntry(quality + " Armor Bonus Addition", () -> this.getDouble(path), v -> this.setDouble(path, (double)v), min, max));
    }

    private void buildDurabilityBonuses() {
        this.configList.addConfigEntry(new HeaderEntry("Durability Bonuses"));
        this.buildDurabilityBonus("Poor", "Durability Bonuses.poorDurabilityBonus", -5.0, 5.0);
        this.buildDurabilityBonus("Well", "Durability Bonuses.wellDurabilityBonus", -5.0, 5.0);
        this.buildDurabilityBonus("Expert", "Durability Bonuses.expertDurabilityBonus", -5.0, 5.0);
        this.buildDurabilityBonus("Perfect", "Durability Bonuses.perfectDurabilityBonus", -5.0, 5.0);
        this.buildDurabilityBonus("Master", "Durability Bonuses.masterDurabilityBonus", -5.0, 5.0);
    }

    private void buildDurabilityBonus(String quality, String path, double min, double max) {
        this.configList.addConfigEntry(new DoubleEntry(quality + " Durability Bonus Multiplier", () -> this.getDouble(path), v -> this.setDouble(path, (double)v), min, max));
    }

    private void buildHeatedItems() {
        this.configList.addConfigEntry(new HeaderEntry("Heated Items"));
        this.configList.addConfigEntry(new IntEntry("How many ticks until heated items cool down", () -> this.getInt("Heated Items.heatedItemCooldownTicks"), v -> this.setInt("Heated Items.heatedItemCooldownTicks", (int)v), 1, Integer.MAX_VALUE));
    }

    private void buildGrindingDurability() {
        this.configList.addConfigEntry(new HeaderEntry("Grinding & Durability"));
        this.configList.addConfigEntry(new ManualInputEntry("Base Durability Multiplier", () -> this.getDouble("Durability & Grinding.durability"), v -> this.setDouble("Durability & Grinding.durability", (double)v)));
        this.configList.addConfigEntry(new BooleanEntry("Enable Grinding", () -> this.getBoolean("Durability & Grinding.grindingToggle"), v -> this.setBoolean("Durability & Grinding.grindingToggle", (boolean)v)));
        this.configList.addConfigEntry(new ManualInputEntry("Tool's Durability Reduce per Grind", () -> this.getDouble("Durability & Grinding.durabilityReduce"), v -> this.setDouble("Durability & Grinding.durabilityReduce", (double)v)));
        this.configList.addConfigEntry(new ManualInputEntry("Tool's Damage Restore per Grind", () -> this.getDouble("Durability & Grinding.damageRestore"), v -> this.setDouble("Durability & Grinding.damageRestore", (double)v)));
        this.configList.addConfigEntry(new BlacklistEntry("Durability Blacklist", () -> this.getStringList("Durability & Grinding.base_durability_blacklist"), v -> this.setStringList("Durability & Grinding.base_durability_blacklist", (List<? extends String>)v)));
        this.configList.addConfigEntry(new BlacklistEntry("Grinding Blacklist", () -> this.getStringList("Durability & Grinding.grindingBlacklist"), v -> this.setStringList("Durability & Grinding.grindingBlacklist", (List<? extends String>)v)));
    }

    private void buildQualityFailure() {
        this.configList.addConfigEntry(new HeaderEntry("Failure chance for recipes that use the failure mechanic"));
        this.configList.addConfigEntry(new DoubleEntry("Fail on Well Chance", () -> this.getDouble("Quality Failure Chances.failOnWellQualityChance"), v -> this.setDouble("Quality Failure Chances.failOnWellQualityChance", (double)v), 0.0, 1.0));
        this.configList.addConfigEntry(new DoubleEntry("Fail on Expert Chance", () -> this.getDouble("Quality Failure Chances.failOnExpertQualityChance"), v -> this.setDouble("Quality Failure Chances.failOnExpertQualityChance", (double)v), 0.0, 1.0));
    }

    private void buildBlueprintSettings() {
        this.configList.addConfigEntry(new HeaderEntry("Blueprint Settings"));
        this.configList.addConfigEntry(new BooleanEntry("Only Expert and above increase Blueprint's uses", () -> this.getBoolean("Blueprint & Tool Types.expertAboveIncreaseBlueprintToggle"), v -> this.setBoolean("Blueprint & Tool Types.expertAboveIncreaseBlueprintToggle", (boolean)v)));
        this.configList.addConfigEntry(new ManualInputEntry("Poor Max Uses", () -> this.getInt("Blueprint & Tool Types.poorMaxUse"), v -> this.setInt("Blueprint & Tool Types.poorMaxUse", v.intValue()), true));
        this.configList.addConfigEntry(new ManualInputEntry("Well Max Uses", () -> this.getInt("Blueprint & Tool Types.wellMaxUse"), v -> this.setInt("Blueprint & Tool Types.wellMaxUse", v.intValue()), true));
        this.configList.addConfigEntry(new ManualInputEntry("Expert Max Uses", () -> this.getInt("Blueprint & Tool Types.expertMaxUse"), v -> this.setInt("Blueprint & Tool Types.expertMaxUse", v.intValue()), true));
        this.configList.addConfigEntry(new ManualInputEntry("Perfect Max Uses", () -> this.getInt("Blueprint & Tool Types.perfectMaxUse"), v -> this.setInt("Blueprint & Tool Types.perfectMaxUse", v.intValue()), true));
        this.configList.addConfigEntry(new ManualInputEntry("Master Max Uses", () -> this.getInt("Blueprint & Tool Types.masterMaxUse"), v -> this.setInt("Blueprint & Tool Types.masterMaxUse", v.intValue()), true));
    }

    private void buildKnapping() {
        this.configList.addConfigEntry(new HeaderEntry("Knapping"));
        this.configList.addConfigEntry(new BooleanEntry("Enable using Flint to get Rock", () -> this.getBoolean("Knapping Settings.useFlintGetRock"), v -> this.setBoolean("Knapping Settings.useFlintGetRock", (boolean)v)));
        this.configList.addConfigEntry(new DoubleEntry("Rock Dropping Chance", () -> this.getDouble("Knapping Settings.rockDroppingChance"), v -> this.setDouble("Knapping Settings.rockDroppingChance", (double)v), 0.0, 1.0));
        this.configList.addConfigEntry(new DoubleEntry("Flint Breaking Chance", () -> this.getDouble("Knapping Settings.flintBreakingChance"), v -> this.setDouble("Knapping Settings.flintBreakingChance", (double)v), 0.0, 1.0));
    }

    private void buildCasting() {
        this.configList.addConfigEntry(new HeaderEntry("Casting"));
        this.configList.addConfigEntry(new BooleanEntry("Enable Casting", () -> this.getBoolean("Casting.castingToggle"), v -> this.setBoolean("Casting.castingToggle", (boolean)v)));
        this.configList.addConfigEntry(new IntEntry("Clay Tool Cast's Durability", () -> this.getInt("Casting.firedCastDurability"), v -> this.setInt("Casting.firedCastDurability", (int)v), 0, Integer.MAX_VALUE));
    }

    private void save() {
        try {
            this.configFile.save();
            this.configSpec.correct((CommentedConfig)this.configFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Failed to save config: " + e.getMessage());
        }
    }

    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(gui);
        if (this.scrollPosition > 0.0) {
            this.configList.m_93410_(this.scrollPosition);
            this.scrollPosition = 0.0;
        }
        this.configList.m_88315_(gui, mouseX, mouseY, partialTicks);
        super.m_88315_(gui, mouseX, mouseY, partialTicks);
        gui.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 15, 0xFFFFFF);
    }

    private boolean getBoolean(String path) {
        Boolean v = (Boolean)this.configFile.get(path);
        return v != null && v != false;
    }

    private void setBoolean(String path, boolean val) {
        this.configFile.set(path, (Object)val);
    }

    private int getInt(String path) {
        Integer v = (Integer)this.configFile.get(path);
        return v == null ? 0 : v;
    }

    private void setInt(String path, int val) {
        this.configFile.set(path, (Object)val);
    }

    private double getDouble(String path) {
        Double v = (Double)this.configFile.get(path);
        return v == null ? 0.0 : v;
    }

    private void setDouble(String path, double val) {
        this.configFile.set(path, (Object)val);
    }

    private List<String> getStringList(String path) {
        List list = (List)this.configFile.get(path);
        if (list == null) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(list);
    }

    private void setStringList(String path, List<? extends String> values) {
        this.configFile.set(path, values);
    }

    public void setScrollPosition(double scrollPosition) {
        this.scrollPosition = scrollPosition;
        if (this.configList != null) {
            this.configList.m_93410_(scrollPosition);
        }
    }

    private void resetAllToDefaults() {
        this.setBoolean("General Configs.enableModTooltips", true);
        this.setBoolean("Loot Quality.enableLootQuality", true);
        this.setBoolean("Minigame Common Settings.enableMinigame", true);
        this.setBoolean("Anvil Conversion.enableStoneToAnvil", true);
        this.setBoolean("Anvil Conversion.enableAnvilToSmithing", true);
        this.setBoolean("Arrow Fletching Settings.enableFletchingRecipes", true);
        this.setBoolean("Arrow Fletching Settings.enableUpgradeArrowTipping", true);
        this.setBoolean("Arrow Fletching Settings.enableDragonBreathRecipe", true);
        this.setBoolean("Minigame Common Settings.ingredientsDefineQuality", true);
        this.setBoolean("Durability & Grinding.grindingToggle", true);
        this.setBoolean("Blueprint & Tool Types.expertAboveIncreaseBlueprintToggle", true);
        this.setBoolean("Knapping Settings.useFlintGetRock", true);
        this.setBoolean("Casting.castingToggle", true);
        this.setInt("Loot Quality.weightPoorQuality", 50);
        this.setInt("Loot Quality.weightWellQuality", 30);
        this.setInt("Loot Quality.weightExpertQuality", 10);
        this.setInt("Loot Quality.weightPerfectQuality", 5);
        this.setInt("Loot Quality.weightMasterQuality", 1);
        this.setInt("Arrow Fletching Settings.maxPotionTipping", 8);
        this.setInt("Minigame Common Settings.maxAnvilDistance", 100);
        this.setInt("Stone Smithing Anvil.max_uses", 64);
        this.setInt("Heated Items.heatedItemCooldownTicks", 1200);
        this.setInt("Blueprint & Tool Types.poorMaxUse", 5);
        this.setInt("Blueprint & Tool Types.wellMaxUse", 10);
        this.setInt("Blueprint & Tool Types.expertMaxUse", 20);
        this.setInt("Blueprint & Tool Types.perfectMaxUse", 50);
        this.setInt("Blueprint & Tool Types.masterMaxUse", 0);
        this.setInt("Casting.firedCastDurability", 5);
        this.resetForgingZoneDefaults();
        this.setDouble("Minigame Common Settings.masterQualityChance", 0.05);
        this.setDouble("Minigame Common Settings.masterFromIngredientChance", 0.5);
        this.setDouble("Minigame Common Settings.perfectQualityScore", 0.9);
        this.setDouble("Minigame Common Settings.expertQualityScore", 0.6);
        this.setDouble("Minigame Common Settings.wellQualityScore", 0.3);
        this.setDouble("Durability & Grinding.durability", 1.0);
        this.setDouble("Durability & Grinding.durabilityReduce", 0.05);
        this.setDouble("Durability & Grinding.damageRestore", 0.1);
        this.setDouble("Quality Failure Chances.failOnWellQualityChance", 0.1);
        this.setDouble("Quality Failure Chances.failOnExpertQualityChance", 0.05);
        this.setDouble("Knapping Settings.rockDroppingChance", 0.1);
        this.setDouble("Knapping Settings.flintBreakingChance", 0.1);
        this.resetWeaponBonuses();
        this.resetArmorBonuses();
        this.resetDurabilityBonuses();
        this.configList.m_6702_().clear();
        this.buildEntries();
    }

    private void resetForgingZoneDefaults() {
        this.setInt("Default (No Blueprint).zoneStartingSize", 20);
        this.setDouble("Default (No Blueprint).zoneShrinkFactor", 0.9);
        this.setInt("Default (No Blueprint).minPerfectZone", 8);
        this.setDouble("Default (No Blueprint).arrowSpeed", 2.0);
        this.setDouble("Default (No Blueprint).arrowSpeedIncrease", 0.6);
        this.setDouble("Default (No Blueprint).maxArrowSpeed", 8.0);
        this.setInt("Poorly Forged.zoneStartingSize", 30);
        this.setDouble("Poorly Forged.zoneShrinkFactor", 0.9);
        this.setInt("Poorly Forged.minPerfectZone", 15);
        this.setDouble("Poorly Forged.arrowSpeed", 1.5);
        this.setDouble("Poorly Forged.arrowSpeedIncrease", 0.5);
        this.setDouble("Poorly Forged.maxArrowSpeed", 4.0);
        this.setInt("Well Forged.zoneStartingSize", 20);
        this.setDouble("Well Forged.zoneShrinkFactor", 0.8);
        this.setInt("Well Forged.minPerfectZone", 12);
        this.setDouble("Well Forged.arrowSpeed", 2.0);
        this.setDouble("Well Forged.arrowSpeedIncrease", 0.7);
        this.setDouble("Well Forged.maxArrowSpeed", 5.0);
        this.setInt("Expertly Forged.zoneStartingSize", 18);
        this.setDouble("Expertly Forged.zoneShrinkFactor", 0.8);
        this.setInt("Expertly Forged.minPerfectZone", 10);
        this.setDouble("Expertly Forged.arrowSpeed", 2.5);
        this.setDouble("Expertly Forged.arrowSpeedIncrease", 0.85);
        this.setDouble("Expertly Forged.maxArrowSpeed", 6.0);
        this.setInt("Perfectly Forged.zoneStartingSize", 15);
        this.setDouble("Perfectly Forged.zoneShrinkFactor", 0.8);
        this.setInt("Perfectly Forged.minPerfectZone", 10);
        this.setDouble("Perfectly Forged.arrowSpeed", 3.0);
        this.setDouble("Perfectly Forged.arrowSpeedIncrease", 1.0);
        this.setDouble("Perfectly Forged.maxArrowSpeed", 7.0);
        this.setInt("Masterwork.zoneStartingSize", 12);
        this.setDouble("Masterwork.zoneShrinkFactor", 0.7);
        this.setInt("Masterwork.minPerfectZone", 8);
        this.setDouble("Masterwork.arrowSpeed", 3.5);
        this.setDouble("Masterwork.arrowSpeedIncrease", 1.2);
        this.setDouble("Masterwork.maxArrowSpeed", 8.0);
    }

    private void resetWeaponBonuses() {
        this.setDouble("Weapon Bonuses.masterWeaponDamage", 3.0);
        this.setDouble("Weapon Bonuses.perfectWeaponDamage", 2.0);
        this.setDouble("Weapon Bonuses.expertWeaponDamage", 1.5);
        this.setDouble("Weapon Bonuses.wellWeaponDamage", 0.0);
        this.setDouble("Weapon Bonuses.poorWeaponDamage", -1.0);
        this.setDouble("Weapon Bonuses.masterWeaponSpeed", 1.0);
        this.setDouble("Weapon Bonuses.perfectWeaponSpeed", 0.5);
        this.setDouble("Weapon Bonuses.expertWeaponSpeed", 0.25);
        this.setDouble("Weapon Bonuses.wellWeaponSpeed", 0.0);
        this.setDouble("Weapon Bonuses.poorWeaponSpeed", -0.5);
    }

    private void resetArmorBonuses() {
        this.setDouble("Armor Bonuses.masterArmorBonus", 2.0);
        this.setDouble("Armor Bonuses.perfectArmorBonus", 1.5);
        this.setDouble("Armor Bonuses.expertArmorBonus", 1.0);
        this.setDouble("Armor Bonuses.wellArmorBonus", 0.0);
        this.setDouble("Armor Bonuses.poorArmorBonus", -1.0);
    }

    private void resetDurabilityBonuses() {
        this.setDouble("Durability Bonuses.masterDurabilityBonus", 1.6);
        this.setDouble("Durability Bonuses.perfectDurabilityBonus", 1.5);
        this.setDouble("Durability Bonuses.expertDurabilityBonus", 1.3);
        this.setDouble("Durability Bonuses.wellDurabilityBonus", 1.0);
        this.setDouble("Durability Bonuses.poorDurabilityBonus", 0.7);
    }

    private static class ConfigList
    extends ObjectSelectionList<ConfigEntry> {
        private final int entryPadding = 30;
        private final int scrollbarPadding = 25;

        public ConfigList(Minecraft mc, int width, int height, int top, int bottom, int itemHeight) {
            super(mc, width, height, top, bottom, itemHeight);
        }

        public void m_93507_(int left) {
            this.f_93393_ = left;
            this.f_93392_ = left + this.f_93388_;
        }

        public int m_5759_() {
            return this.f_93388_ - 60;
        }

        public int m_5747_() {
            return this.f_93393_ + 30;
        }

        public void addConfigEntry(ConfigEntry entry) {
            super.m_7085_((AbstractSelectionList.Entry)entry);
        }

        public int m_5756_() {
            return this.f_93392_ - 25;
        }

        protected void m_240140_(GuiGraphics gui, int top, int width, int height, int outlineColor, int fillColor) {
        }

        public void m_93471_(boolean pRenderSelection) {
            super.m_93471_(false);
        }

        public static abstract class ConfigEntry
        extends ObjectSelectionList.Entry<ConfigEntry> {
        }
    }

    private class HeaderEntry
    extends ConfigList.ConfigEntry {
        private final String label;

        public HeaderEntry(String label) {
            this.label = label;
        }

        public void m_6311_(GuiGraphics gui, int idx, int y, int x, int listWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            int textWidth = OvergearedConfigScreen.this.f_96547_.m_92895_(this.label);
            int centeredX = x + (listWidth - textWidth) / 2;
            gui.m_280488_(OvergearedConfigScreen.this.f_96547_, this.label, centeredX, y + entryHeight / 2 - 4, 0xFFFFFF);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            return false;
        }

        public Component m_142172_() {
            return Component.m_237113_((String)this.label);
        }
    }

    private class BooleanEntry
    extends ConfigList.ConfigEntry {
        private final Supplier<Boolean> getter;
        private final Consumer<Boolean> setter;
        private final Boolean defaultValue;
        private final Button toggle;
        private final String label;

        public BooleanEntry(String label, Supplier<Boolean> getter, Consumer<Boolean> setter) {
            this.label = label;
            this.getter = getter;
            this.setter = setter;
            this.defaultValue = getter.get();
            this.toggle = Button.m_253074_((Component)Component.m_237113_((String)getter.get().toString()), btn -> {
                boolean newVal = (Boolean)getter.get() == false;
                setter.accept(newVal);
                btn.m_93666_((Component)Component.m_237113_((String)Boolean.toString(newVal)));
            }).m_252987_(0, 0, 80, 20).m_253136_();
        }

        public void m_6311_(GuiGraphics gui, int idx, int y, int x, int listWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float pt) {
            gui.m_280488_(OvergearedConfigScreen.this.f_96547_, this.label, x + 2, y + 5, 0xFFFFFF);
            int controlWidth = 80;
            this.toggle.m_252865_(x + listWidth - controlWidth);
            this.toggle.m_253211_(y);
            this.toggle.m_88315_(gui, mouseX, mouseY, pt);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            return this.toggle.m_6375_(mouseX, mouseY, button);
        }

        public Component m_142172_() {
            return Component.m_237113_((String)this.label);
        }
    }

    private class IntEntry
    extends ConfigList.ConfigEntry {
        private final Supplier<Integer> getter;
        private final Consumer<Integer> setter;
        private final Integer defaultValue;
        private final AbstractSliderButton slider;
        private final String label;
        private final int min;
        private final int max;

        public IntEntry(String label, Supplier<Integer> getter, final Consumer<Integer> setter, final int min, final int max) {
            this.label = label;
            this.getter = getter;
            this.setter = setter;
            this.defaultValue = getter.get();
            this.min = min;
            this.max = max;
            double normalized = (double)(getter.get() - min) / (double)(max - min);
            this.slider = new AbstractSliderButton(0, 0, 80, 20, (Component)Component.m_237113_((String)getter.get().toString()), normalized){

                protected void m_5695_() {
                    int value = min + (int)(this.f_93577_ * (double)(max - min));
                    setter.accept(value);
                    this.m_93666_((Component)Component.m_237113_((String)Integer.toString(value)));
                }

                protected void m_5697_() {
                }
            };
        }

        public void m_6311_(GuiGraphics gui, int idx, int y, int x, int listWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float pt) {
            gui.m_280488_(OvergearedConfigScreen.this.f_96547_, this.label, x + 2, y + 5, 0xFFFFFF);
            int controlWidth = 80;
            this.slider.m_252865_(x + listWidth - controlWidth);
            this.slider.m_253211_(y);
            this.slider.m_88315_(gui, mouseX, mouseY, pt);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            return this.slider.m_6375_(mouseX, mouseY, button);
        }

        public boolean m_7979_(double mouseX, double mouseY, int button, double dx, double dy) {
            return this.slider.m_7979_(mouseX, mouseY, button, dx, dy);
        }

        public Component m_142172_() {
            return Component.m_237113_((String)this.label);
        }
    }

    private class ManualInputEntry
    extends ConfigList.ConfigEntry {
        private final String label;
        private final Supplier<Double> getter;
        private final Consumer<Double> setter;
        private final EditBox editBox;
        private final boolean acceptIntegers;

        public ManualInputEntry(String label, Supplier<Double> getter, Consumer<Double> setter) {
            this(label, getter, setter, false);
        }

        public ManualInputEntry(String label, Supplier<Double> getter, Consumer<Double> setter, boolean acceptIntegers) {
            this.label = label;
            this.getter = getter;
            this.setter = setter;
            this.acceptIntegers = acceptIntegers;
            this.editBox = new EditBox(OvergearedConfigScreen.this.f_96547_, 0, 0, 80, 20, (Component)Component.m_237113_((String)""));
            double cur = getter.get();
            if (acceptIntegers) {
                this.editBox.m_94144_(Integer.toString((int)cur));
            } else {
                this.editBox.m_94144_(Double.toString(cur));
            }
            this.editBox.m_94182_(true);
            this.editBox.m_94194_(true);
            this.editBox.m_94190_(true);
            this.editBox.m_94151_(value -> {
                try {
                    double newValue = acceptIntegers ? (double)Integer.parseInt(value) : Double.parseDouble(value);
                    setter.accept(newValue);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
        }

        public void m_6311_(GuiGraphics gui, int idx, int y, int x, int listWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float pt) {
            gui.m_280488_(OvergearedConfigScreen.this.f_96547_, this.label, x + 2, y + 5, 0xFFFFFF);
            this.editBox.m_252865_(x + listWidth - 80);
            this.editBox.m_253211_(y);
            this.editBox.m_88315_(gui, mouseX, mouseY, pt);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.editBox.m_5953_(mouseX, mouseY)) {
                this.editBox.m_93692_(true);
                return this.editBox.m_6375_(mouseX, mouseY, button);
            }
            this.editBox.m_93692_(false);
            return false;
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            return this.editBox.m_6348_(mouseX, mouseY, button);
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            if (this.editBox.m_93696_()) {
                if (keyCode == 256) {
                    this.editBox.m_94144_(String.valueOf(this.getter.get()));
                    this.editBox.m_93692_(false);
                    return true;
                }
                if (keyCode == 257) {
                    this.editBox.m_93692_(false);
                    return true;
                }
                return this.editBox.m_7933_(keyCode, scanCode, modifiers);
            }
            return false;
        }

        public boolean m_5534_(char codePoint, int modifiers) {
            return this.editBox.m_5534_(codePoint, modifiers);
        }

        public void m_93692_(boolean focused) {
            if (!focused && this.editBox.m_93696_()) {
                this.editBox.m_93692_(false);
            }
        }

        public boolean m_5953_(double mouseX, double mouseY) {
            return this.editBox.m_5953_(mouseX, mouseY);
        }

        public Component m_142172_() {
            return Component.m_237113_((String)this.label);
        }
    }

    private class DoubleEntry
    extends ConfigList.ConfigEntry {
        private final Supplier<Double> getter;
        private final Consumer<Double> setter;
        private final Double defaultValue;
        private final AbstractSliderButton slider;
        private final String label;
        private final double min;
        private final double max;

        public DoubleEntry(String label, Supplier<Double> getter, final Consumer<Double> setter, final double min, final double max) {
            this.label = label;
            this.getter = getter;
            this.setter = setter;
            this.defaultValue = getter.get();
            this.min = min;
            this.max = max;
            double cur = getter.get();
            double normalized = (cur - min) / (max - min);
            this.slider = new AbstractSliderButton(0, 0, 80, 20, (Component)Component.m_237113_((String)String.format("%.2f", cur)), normalized){

                protected void m_5695_() {
                    double value = min + this.f_93577_ * (max - min);
                    setter.accept(value);
                    this.m_93666_((Component)Component.m_237113_((String)String.format("%.2f", value)));
                }

                protected void m_5697_() {
                }
            };
        }

        public void m_6311_(GuiGraphics gui, int idx, int y, int x, int listWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float pt) {
            gui.m_280488_(OvergearedConfigScreen.this.f_96547_, this.label, x + 2, y + 5, 0xFFFFFF);
            int controlWidth = 80;
            this.slider.m_252865_(x + listWidth - controlWidth);
            this.slider.m_253211_(y);
            this.slider.m_88315_(gui, mouseX, mouseY, pt);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            return this.slider.m_6375_(mouseX, mouseY, button);
        }

        public boolean m_7979_(double mouseX, double mouseY, int button, double dx, double dy) {
            return this.slider.m_7979_(mouseX, mouseY, button, dx, dy);
        }

        public Component m_142172_() {
            return Component.m_237113_((String)this.label);
        }
    }

    private class BlacklistEntry
    extends ConfigList.ConfigEntry {
        private final String label;
        private final Supplier<List<? extends String>> getter;
        private final Consumer<List<? extends String>> setter;
        private final Button editButton;

        public BlacklistEntry(String label, Supplier<List<? extends String>> getter, Consumer<List<? extends String>> setter) {
            this.label = label;
            this.getter = getter;
            this.setter = setter;
            this.editButton = Button.m_253074_((Component)Component.m_237113_((String)"Edit Items"), btn -> this.openBlacklistEditor(label, (List)getter.get())).m_252987_(0, 0, 80, 20).m_253136_();
        }

        private void openBlacklistEditor(String blacklistName, List<? extends String> currentItems) {
            double savedScrollPosition = OvergearedConfigScreen.this.configList.m_93517_();
            Minecraft mc = OvergearedConfigScreen.this.f_96541_;
            BlacklistEditorScreen editorScreen = new BlacklistEditorScreen(blacklistName, currentItems, this.setter, savedScrollPosition, OvergearedConfigScreen.this);
            mc.m_91152_((Screen)editorScreen);
        }

        public void m_6311_(GuiGraphics gui, int idx, int y, int x, int listWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float pt) {
            gui.m_280488_(OvergearedConfigScreen.this.f_96547_, this.label, x + 2, y + 5, 0xFFFFFF);
            List<? extends String> items = this.getter.get();
            String itemCountText = " (" + items.size() + " items)";
            gui.m_280488_(OvergearedConfigScreen.this.f_96547_, itemCountText, x + OvergearedConfigScreen.this.f_96547_.m_92895_(this.label) + 5, y + 5, 0xAAAAAA);
            this.editButton.m_252865_(x + listWidth - 80);
            this.editButton.m_253211_(y);
            this.editButton.m_88315_(gui, mouseX, mouseY, pt);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            return this.editButton.m_6375_(mouseX, mouseY, button);
        }

        public Component m_142172_() {
            return Component.m_237113_((String)this.label);
        }
    }
}

