/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.config;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;

public class ScrollPanel
implements Renderable,
GuiEventListener,
NarratableEntry {
    private final Minecraft client;
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private int scrollY;
    private boolean scrolling;
    private final int scrollbarWidth = 6;
    private final List<AbstractWidget> children = new ArrayList<AbstractWidget>();
    private final int contentHeight;
    private boolean focused = false;

    public ScrollPanel(Minecraft client, int x, int y, int width, int height, int contentHeight) {
        this.client = client;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.contentHeight = contentHeight;
    }

    public void addWidget(AbstractWidget widget) {
        this.children.add(widget);
    }

    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float delta) {
        int screenHeight = this.client.m_91268_().m_85446_();
        gui.m_280588_(this.x, screenHeight - (this.y + this.height), this.x + this.width, screenHeight - this.y);
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_252880_(0.0f, (float)(-this.scrollY), 0.0f);
        for (AbstractWidget child : this.children) {
            child.m_88315_(gui, mouseX, mouseY - this.scrollY, delta);
        }
        gui.m_280168_().m_85849_();
        gui.m_280618_();
        if (this.contentHeight > this.height) {
            int scrollbarHeight = (int)((float)this.height / (float)this.contentHeight * (float)this.height);
            int scrollbarY = this.y + (int)((float)this.scrollY / (float)(this.contentHeight - this.height) * (float)(this.height - scrollbarHeight));
            gui.m_280509_(this.x + this.width - 6, scrollbarY, this.x + this.width, scrollbarY + scrollbarHeight, -3355444);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean inBounds;
        boolean bl = inBounds = mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.height);
        if (!inBounds) {
            return false;
        }
        if (mouseX >= (double)(this.x + this.width - 6)) {
            this.scrolling = true;
            this.m_93692_(true);
            return true;
        }
        double adjustedY = mouseY - (double)this.scrollY;
        for (AbstractWidget child : this.children) {
            if (!child.m_6375_(mouseX, adjustedY, button)) continue;
            this.m_93692_(true);
            return true;
        }
        this.m_93692_(true);
        return true;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.scrolling) {
            double rel = mouseY - (double)this.y;
            double pct = rel / (double)this.height;
            this.scrollY = (int)(pct * (double)(this.contentHeight - this.height));
            this.scrollY = Math.max(0, Math.min(this.scrollY, this.contentHeight - this.height));
            return true;
        }
        double adjustedY = mouseY - (double)this.scrollY;
        for (AbstractWidget child : this.children) {
            if (!child.m_7979_(mouseX, adjustedY, button, dragX, dragY)) continue;
            return true;
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        this.scrollY = (int)((double)this.scrollY - amount * 20.0);
        this.scrollY = Math.max(0, Math.min(this.scrollY, this.contentHeight - this.height));
        return true;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        double adjustedY = mouseY - (double)this.scrollY;
        for (AbstractWidget child : this.children) {
            if (!child.m_6348_(mouseX, adjustedY, button)) continue;
            return true;
        }
        return false;
    }

    public void m_93692_(boolean isFocused) {
        this.focused = isFocused;
    }

    public boolean m_93696_() {
        return this.focused;
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(NarrationElementOutput output) {
    }
}

