/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.item;

import java.util.Locale;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ToolType {
    public static final ToolType SWORD = new ToolType("SWORD");
    public static final ToolType AXE = new ToolType("AXE");
    public static final ToolType PICKAXE = new ToolType("PICKAXE");
    public static final ToolType SHOVEL = new ToolType("SHOVEL");
    public static final ToolType HOE = new ToolType("HOE");
    public static final ToolType MULTITOOL = new ToolType("MULTITOOL");
    private final String id;
    private final String translationKey;

    public ToolType(String id) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("Tool type ID cannot be null or empty");
        }
        if (!id.matches("^[A-Z0-9_]+$")) {
            throw new IllegalArgumentException("Tool type ID must be uppercase alphanumeric with underscores");
        }
        this.id = id.toUpperCase(Locale.ROOT);
        this.translationKey = "tooltype.overgeared." + this.id.toLowerCase(Locale.ROOT);
    }

    public String getId() {
        return this.id.toLowerCase();
    }

    public MutableComponent getDisplayName() {
        MutableComponent trans = Component.m_237115_((String)this.translationKey);
        return trans.m_6881_();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ToolType)) {
            return false;
        }
        return this.id.equals(((ToolType)o).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

