/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.compat;

import java.util.List;
import java.util.stream.Stream;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.stirdrem.overgeared.item.ModItems;

public class OvergearedAnvilRecipes {
    public static Stream<IJeiAnvilRecipe> getOvergearedAnvilRecipes(IVanillaRecipeFactory vanillaRecipeFactory, IIngredientManager ingredientManager) {
        return Stream.concat(OvergearedAnvilRecipes.getCustomRepairRecipes(vanillaRecipeFactory, ingredientManager), Stream.empty());
    }

    private static Stream<IJeiAnvilRecipe> getCustomRepairRecipes(IVanillaRecipeFactory vanillaRecipeFactory, IIngredientManager ingredientManager) {
        return OvergearedAnvilRecipes.getCustomRepairData().flatMap(repairData -> OvergearedAnvilRecipes.createRepairRecipes(repairData, vanillaRecipeFactory, ingredientManager));
    }

    private static Stream<RepairData> getCustomRepairData() {
        return Stream.of(new RepairData(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42416_}), new ItemStack((ItemLike)ModItems.IRON_TONGS.get())), new RepairData(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_151052_}), new ItemStack((ItemLike)ModItems.COPPER_SWORD.get()), new ItemStack((ItemLike)ModItems.COPPER_PICKAXE.get()), new ItemStack((ItemLike)ModItems.COPPER_AXE.get()), new ItemStack((ItemLike)ModItems.COPPER_SHOVEL.get()), new ItemStack((ItemLike)ModItems.COPPER_HOE.get())), new RepairData(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.STEEL_INGOT.get()}), new ItemStack((ItemLike)ModItems.STEEL_TONGS.get()), new ItemStack((ItemLike)ModItems.STEEL_SWORD.get()), new ItemStack((ItemLike)ModItems.STEEL_PICKAXE.get()), new ItemStack((ItemLike)ModItems.STEEL_AXE.get()), new ItemStack((ItemLike)ModItems.STEEL_SHOVEL.get()), new ItemStack((ItemLike)ModItems.STEEL_HOE.get()), new ItemStack((ItemLike)ModItems.STEEL_HELMET.get()), new ItemStack((ItemLike)ModItems.STEEL_CHESTPLATE.get()), new ItemStack((ItemLike)ModItems.STEEL_LEGGINGS.get()), new ItemStack((ItemLike)ModItems.STEEL_BOOTS.get())));
    }

    private static Stream<IJeiAnvilRecipe> createRepairRecipes(RepairData repairData, IVanillaRecipeFactory vanillaRecipeFactory, IIngredientManager ingredientManager) {
        Ingredient repairIngredient = repairData.getRepairIngredient();
        List<ItemStack> repairables = repairData.getRepairables();
        List<ItemStack> repairMaterials = List.of(repairIngredient.m_43908_());
        return repairables.stream().mapMulti((itemStack, consumer) -> {
            ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_());
            String ingredientId = itemId.m_135815_();
            ItemStack damagedThreeQuarters = itemStack.m_41777_();
            damagedThreeQuarters.m_41721_(damagedThreeQuarters.m_41776_() * 3 / 4);
            ItemStack damagedHalf = itemStack.m_41777_();
            damagedHalf.m_41721_(damagedHalf.m_41776_() / 2);
            IJeiAnvilRecipe repairWithSame = vanillaRecipeFactory.createAnvilRecipe(List.of(damagedThreeQuarters), List.of(damagedThreeQuarters), List.of(damagedHalf), ResourceLocation.m_214293_((String)"overgeared", (String)("self_repair." + ingredientId)));
            consumer.accept(repairWithSame);
            if (!repairMaterials.isEmpty()) {
                ItemStack damagedFully = itemStack.m_41777_();
                damagedFully.m_41721_(damagedFully.m_41776_());
                IJeiAnvilRecipe repairWithMaterial = vanillaRecipeFactory.createAnvilRecipe(List.of(damagedFully), repairMaterials, List.of(damagedThreeQuarters), ResourceLocation.m_214293_((String)"overgeared", (String)("material_repair." + ingredientId)));
                consumer.accept(repairWithMaterial);
            }
        });
    }

    private static class RepairData {
        private final Ingredient repairIngredient;
        private final List<ItemStack> repairables;

        public RepairData(Ingredient repairIngredient, ItemStack ... repairables) {
            this.repairIngredient = repairIngredient;
            this.repairables = List.of(repairables);
        }

        public Ingredient getRepairIngredient() {
            return this.repairIngredient;
        }

        public List<ItemStack> getRepairables() {
            return this.repairables;
        }
    }
}

