/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.stirdrem.overgeared.recipe.INetherAlloyRecipe;
import net.stirdrem.overgeared.recipe.ModRecipeTypes;
import net.stirdrem.overgeared.recipe.ModRecipes;

public class ShapedNetherAlloySmeltingRecipe
implements Recipe<SimpleContainer>,
INetherAlloyRecipe {
    private final ResourceLocation id;
    private final String group;
    private final CraftingBookCategory category;
    private final NonNullList<Ingredient> pattern;
    private final ItemStack output;
    private final float experience;
    private final int cookingTime;

    public ShapedNetherAlloySmeltingRecipe(ResourceLocation id, String group, CraftingBookCategory category, NonNullList<Ingredient> pattern, ItemStack output, float experience, int cookingTime) {
        if (pattern.size() != 9) {
            throw new IllegalArgumentException("Pattern for 3x3 alloy smelting must have exactly 9 ingredients");
        }
        this.id = id;
        this.group = group;
        this.category = category;
        this.pattern = pattern;
        this.output = output;
        this.experience = experience;
        this.cookingTime = cookingTime;
    }

    public boolean matches(SimpleContainer inv, Level level) {
        if (level.f_46443_) {
            return false;
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack stack;
            Ingredient ingredient = (Ingredient)this.pattern.get(i);
            if (ingredient.test(stack = inv.m_8020_(i))) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(SimpleContainer inv, RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int w, int h) {
        return w >= 3 && h >= 3;
    }

    @Override
    public List<Ingredient> getIngredientsList() {
        return this.pattern;
    }

    @Override
    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.SHAPED_NETHER_ALLOY_SMELTING.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.SHAPED_NETHER_ALLOY_SMELTING.get();
    }

    public String m_6076_() {
        return this.group;
    }

    public CraftingBookCategory category() {
        return this.category;
    }

    @Override
    public float getExperience() {
        return this.experience;
    }

    public int getCookingTime() {
        return this.cookingTime;
    }

    public NonNullList<Ingredient> getPattern() {
        return this.pattern;
    }

    public static class Serializer
    implements RecipeSerializer<ShapedNetherAlloySmeltingRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public ShapedNetherAlloySmeltingRecipe fromJson(ResourceLocation id, JsonObject json) {
            String group = json.has("group") ? json.get("group").getAsString() : "";
            CraftingBookCategory category = json.has("category") ? (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(json.get("category").getAsString(), (Enum)CraftingBookCategory.MISC) : CraftingBookCategory.MISC;
            JsonArray patternArray = json.getAsJsonArray("pattern");
            if (patternArray.size() != 3) {
                throw new JsonSyntaxException("3x3 alloy smelting requires exactly 3 rows in the pattern");
            }
            JsonObject keyJson = json.getAsJsonObject("key");
            HashMap<Character, Ingredient> keyMap = new HashMap<Character, Ingredient>();
            for (Map.Entry entry : keyJson.entrySet()) {
                if (((String)entry.getKey()).length() != 1) {
                    throw new JsonSyntaxException("Invalid key: " + (String)entry.getKey());
                }
                keyMap.put(Character.valueOf(((String)entry.getKey()).charAt(0)), Ingredient.m_43917_((JsonElement)((JsonElement)entry.getValue())));
            }
            NonNullList ingredients = NonNullList.m_122780_((int)9, (Object)Ingredient.f_43901_);
            for (int y = 0; y < 3; ++y) {
                String row = patternArray.get(y).getAsString();
                if (row.length() != 3) {
                    throw new JsonSyntaxException("Each row in 3x3 pattern must have 3 characters");
                }
                for (int x = 0; x < 3; ++x) {
                    char c = row.charAt(x);
                    ingredients.set(y * 3 + x, (Object)keyMap.getOrDefault(Character.valueOf(c), Ingredient.f_43901_));
                }
            }
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)json.getAsJsonObject("result"));
            float experience = json.has("experience") ? json.get("experience").getAsFloat() : 0.0f;
            int cookingTime = json.has("cookingtime") ? json.get("cookingtime").getAsInt() : 200;
            return new ShapedNetherAlloySmeltingRecipe(id, group, category, (NonNullList<Ingredient>)ingredients, output, experience, cookingTime);
        }

        public ShapedNetherAlloySmeltingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            String group = buf.m_130277_();
            CraftingBookCategory category = (CraftingBookCategory)buf.m_130066_(CraftingBookCategory.class);
            NonNullList pattern = NonNullList.m_122780_((int)9, (Object)Ingredient.f_43901_);
            for (int i = 0; i < 9; ++i) {
                pattern.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            ItemStack output = buf.m_130267_();
            float experience = buf.readFloat();
            int cookingTime = buf.m_130242_();
            return new ShapedNetherAlloySmeltingRecipe(id, group, category, (NonNullList<Ingredient>)pattern, output, experience, cookingTime);
        }

        public void toNetwork(FriendlyByteBuf buf, ShapedNetherAlloySmeltingRecipe recipe) {
            buf.m_130070_(recipe.group);
            buf.m_130068_((Enum)recipe.category);
            recipe.pattern.forEach(i -> i.m_43923_(buf));
            buf.m_130055_(recipe.output);
            buf.writeFloat(recipe.experience);
            buf.m_130130_(recipe.cookingTime);
        }
    }

    public static class Type
    implements RecipeType<ShapedNetherAlloySmeltingRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "shaped_nether_alloy_smelting";
    }
}

