/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.block.entity;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.stirdrem.overgeared.AnvilTier;
import net.stirdrem.overgeared.ForgingQuality;
import net.stirdrem.overgeared.OvergearedMod;
import net.stirdrem.overgeared.config.ServerConfig;
import net.stirdrem.overgeared.event.ModEvents;
import net.stirdrem.overgeared.recipe.ForgingRecipe;
import net.stirdrem.overgeared.util.ModTags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSmithingAnvilBlockEntity
extends BlockEntity
implements MenuProvider {
    protected final ItemStackHandler itemHandler = new ItemStackHandler(12){

        protected void onContentsChanged(int slot) {
            AbstractSmithingAnvilBlockEntity.this.m_6596_();
            if (!AbstractSmithingAnvilBlockEntity.this.f_58857_.m_5776_()) {
                AbstractSmithingAnvilBlockEntity.this.f_58857_.m_7260_(AbstractSmithingAnvilBlockEntity.this.m_58899_(), AbstractSmithingAnvilBlockEntity.this.m_58900_(), AbstractSmithingAnvilBlockEntity.this.m_58900_(), 3);
            }
        }
    };
    protected static final int INPUT_SLOT = 0;
    protected static final int OUTPUT_SLOT = 10;
    protected LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected final ContainerData data;
    protected int progress = 0;
    protected int maxProgress = 0;
    protected int hitRemains;
    protected long busyUntilGameTime = 0L;
    protected UUID ownerUUID = null;
    protected Map<BlockPos, UUID> occupiedAnvils = Collections.synchronizedMap(new HashMap());
    protected AnvilTier anvilTier;
    protected long sessionStartTime = 0L;
    protected ItemStack failedResult;
    protected Player player;
    private boolean minigameOn = false;
    protected ForgingRecipe lastRecipe = null;
    protected ItemStack lastBlueprint = ItemStack.f_41583_;

    public AbstractSmithingAnvilBlockEntity(AnvilTier tier, BlockEntityType<?> type, BlockPos pPos, BlockState pBlockState) {
        super(type, pPos, pBlockState);
        this.anvilTier = tier;
        this.data = new ContainerData(){

            public int m_6413_(int pIndex) {
                return switch (pIndex) {
                    case 0 -> AbstractSmithingAnvilBlockEntity.this.progress;
                    case 1 -> AbstractSmithingAnvilBlockEntity.this.maxProgress;
                    case 2 -> AbstractSmithingAnvilBlockEntity.this.hitRemains;
                    default -> 0;
                };
            }

            public void m_8050_(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        AbstractSmithingAnvilBlockEntity.this.progress = pValue;
                        break;
                    }
                    case 1: {
                        AbstractSmithingAnvilBlockEntity.this.maxProgress = pValue;
                    }
                }
            }

            public int m_6499_() {
                return 3;
            }
        };
    }

    public ItemStack getRenderStack(int index) {
        return this.itemHandler.getStackInSlot(index);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.of(() -> this.itemHandler).cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"gui.overgeared.smithing_anvil");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("hitRemains", this.hitRemains);
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        if (this.ownerUUID != null) {
            tag.m_128362_("ownerUUID", this.ownerUUID);
            tag.m_128356_("sessionStartTime", this.sessionStartTime);
        }
        ListTag occupiedList = new ListTag();
        for (Map.Entry<BlockPos, UUID> entry : this.occupiedAnvils.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            BlockPos pos = entry.getKey();
            entryTag.m_128405_("x", pos.m_123341_());
            entryTag.m_128405_("y", pos.m_123342_());
            entryTag.m_128405_("z", pos.m_123343_());
            entryTag.m_128362_("uuid", entry.getValue());
            occupiedList.add((Object)entryTag);
        }
        tag.m_128365_("occupiedAnvils", (Tag)occupiedList);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("inventory")) {
            this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        }
        if (tag.m_128441_("hitRemains")) {
            this.hitRemains = tag.m_128451_("hitRemains");
        }
        if (tag.m_128403_("ownerUUID")) {
            this.ownerUUID = tag.m_128342_("ownerUUID");
            this.sessionStartTime = tag.m_128454_("sessionStartTime");
        } else {
            this.ownerUUID = null;
        }
        this.occupiedAnvils.clear();
        if (tag.m_128425_("occupiedAnvils", 9)) {
            ListTag occupiedList = tag.m_128437_("occupiedAnvils", 10);
            for (int i = 0; i < occupiedList.size(); ++i) {
                CompoundTag entryTag = occupiedList.m_128728_(i);
                int x = entryTag.m_128451_("x");
                int y = entryTag.m_128451_("y");
                int z = entryTag.m_128451_("z");
                UUID uuid = entryTag.m_128342_("uuid");
                this.occupiedAnvils.put(new BlockPos(x, y, z), uuid);
            }
        }
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void increaseForgingProgress(Level pLevel, BlockPos pPos, BlockState pState) {
        Optional<ForgingRecipe> recipe = this.getCurrentRecipe();
        if (this.hasRecipe()) {
            ForgingRecipe currentRecipe = recipe.get();
            this.maxProgress = currentRecipe.getHammeringRequired();
            this.increaseCraftingProgress();
            AbstractSmithingAnvilBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            if (this.hasProgressFinished()) {
                this.craftItem();
                this.resetProgress(pPos);
            }
        } else {
            this.resetProgress(pPos);
        }
    }

    public void resetProgress(BlockPos pos) {
        this.progress = 0;
        this.maxProgress = 0;
        this.lastRecipe = null;
        if (!this.f_58857_.m_5776_()) {
            ModEvents.resetMinigameForPlayer((ServerPlayer)this.player);
        }
        this.player = null;
    }

    protected void craftItem() {
        String quality;
        Optional<ForgingRecipe> recipeOptional = this.getCurrentRecipe();
        if (recipeOptional.isEmpty()) {
            return;
        }
        ForgingRecipe recipe = recipeOptional.get();
        ItemStack result = recipe.m_8043_(this.m_58904_().m_9598_());
        this.failedResult = recipe.getFailedResultItem(this.m_58904_().m_9598_());
        ForgingQuality minimumQuality = recipe.getMinimumQuality();
        if (recipe.hasQuality()) {
            ForgingQuality quality2;
            String qualityStr;
            if (((Boolean)ServerConfig.ENABLE_MINIGAME.get()).booleanValue() && !Objects.equals(qualityStr = this.determineForgingQuality(), "no_quality") && (quality2 = ForgingQuality.fromString(qualityStr)) != null) {
                if (minimumQuality != null && quality2.ordinal() < minimumQuality.ordinal()) {
                    quality2 = minimumQuality;
                }
                CompoundTag tag = result.m_41784_();
                if (quality2 != ForgingQuality.PERFECT) {
                    tag.m_128359_("ForgingQuality", quality2.getDisplayName());
                } else {
                    if ((Double)ServerConfig.MASTER_QUALITY_CHANCE.get() != 0.0) {
                        Random random = new Random();
                        if ((double)random.nextFloat() < (Double)ServerConfig.MASTER_QUALITY_CHANCE.get()) {
                            quality2 = ForgingQuality.MASTER;
                        }
                    }
                    tag.m_128359_("ForgingQuality", quality2.getDisplayName());
                }
                if (!(result.m_41720_() instanceof ArmorItem) && !(result.m_41720_() instanceof ShieldItem) && recipe.hasPolishing()) {
                    tag.m_128379_("Polished", false);
                }
                if (!(!recipe.needQuenching() || result.m_204117_(ModTags.Items.HEATED_METALS) && result.m_204117_(ModTags.Items.HOT_ITEMS))) {
                    tag.m_128379_("Heated", true);
                    result.m_41751_(tag);
                }
            }
        } else if (recipe.needsMinigame() && ((Boolean)ServerConfig.ENABLE_MINIGAME.get()).booleanValue() && !Objects.equals(quality = this.determineForgingQuality(), "no_quality")) {
            boolean fail = false;
            if (quality.equals(ForgingQuality.POOR.getDisplayName())) {
                fail = true;
            } else if (quality.equals(ForgingQuality.WELL.getDisplayName())) {
                failChance = ((Double)ServerConfig.FAIL_ON_WELL_QUALITY_CHANCE.get()).floatValue();
                fail = new Random().nextFloat() < failChance;
            } else if (quality.equals(ForgingQuality.EXPERT.getDisplayName())) {
                failChance = ((Double)ServerConfig.FAIL_ON_EXPERT_QUALITY_CHANCE.get()).floatValue();
                boolean bl = fail = new Random().nextFloat() < failChance;
            }
            if (fail) {
                result = this.failedResult.m_41777_();
            }
        }
        for (int i = 0; i < 9; ++i) {
            this.itemHandler.extractItem(i, 1, false);
        }
        ItemStack existing = this.itemHandler.getStackInSlot(10);
        if (existing.m_41619_()) {
            this.itemHandler.setStackInSlot(10, result);
        } else if (ItemStack.m_150942_((ItemStack)existing, (ItemStack)result)) {
            int maxSize;
            int total = existing.m_41613_() + result.m_41613_();
            if (total <= (maxSize = Math.min(existing.m_41741_(), this.itemHandler.getSlotLimit(10)))) {
                existing.m_41769_(result.m_41613_());
                this.itemHandler.setStackInSlot(10, existing);
            } else {
                int remainder = total - maxSize;
                existing.m_41764_(maxSize);
                this.itemHandler.setStackInSlot(10, existing);
                ItemStack overflow = result.m_41777_();
                overflow.m_41764_(remainder);
                Containers.m_18992_((Level)this.m_58904_(), (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (ItemStack)overflow);
            }
        }
    }

    public boolean isFailedResult() {
        ItemStack result = this.itemHandler.getStackInSlot(10);
        return ItemStack.m_41656_((ItemStack)result, (ItemStack)this.failedResult);
    }

    public boolean hasRecipe() {
        Optional<ForgingRecipe> recipeOptional = this.getCurrentRecipe();
        if (recipeOptional.isEmpty()) {
            return false;
        }
        ForgingRecipe recipe = recipeOptional.get();
        AnvilTier requiredTier = AnvilTier.fromDisplayName(recipe.getAnvilTier());
        if (requiredTier == null || !requiredTier.isEqualOrLowerThan(this.anvilTier)) {
            return false;
        }
        ItemStack resultStack = recipe.m_8043_(this.f_58857_.m_9598_());
        return this.canInsertItemIntoOutputSlot(resultStack) && this.canInsertAmountIntoOutputSlot(resultStack.m_41613_());
    }

    protected boolean hasEnoughIngredients(ForgingRecipe recipe) {
        NonNullList<Ingredient> ingredients = recipe.m_7527_();
        SimpleContainer inventory = new SimpleContainer(9);
        for (int i = 0; i < 9; ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        SimpleContainer inventoryCopy = new SimpleContainer(9);
        for (int i = 0; i < 9; ++i) {
            inventoryCopy.m_6836_(i, inventory.m_8020_(i).m_41777_());
        }
        for (Ingredient ingredient : ingredients) {
            boolean found = false;
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = inventoryCopy.m_8020_(i);
                if (!ingredient.test(stack) || stack.m_41613_() <= 0) continue;
                stack.m_41774_(1);
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public Optional<ForgingRecipe> getCurrentRecipe() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < 9; ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        inventory.m_6836_(11, this.itemHandler.getStackInSlot(11));
        return ForgingRecipe.findBestMatch(this.f_58857_, (Container)inventory).filter(this::matchesRecipeExactly);
    }

    protected boolean canInsertItemIntoOutputSlot(ItemStack stackToInsert) {
        ItemStack existing = this.itemHandler.getStackInSlot(10);
        return existing.m_41619_() || ItemStack.m_150942_((ItemStack)existing, (ItemStack)stackToInsert);
    }

    protected boolean canInsertAmountIntoOutputSlot(int count) {
        return this.itemHandler.getStackInSlot(10).m_41613_() + count <= this.itemHandler.getStackInSlot(10).m_41741_();
    }

    public boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    protected void increaseCraftingProgress() {
        ++this.progress;
    }

    public boolean isBusy(long currentGameTime) {
        return currentGameTime < this.busyUntilGameTime;
    }

    public void setBusyUntil(long time) {
        this.busyUntilGameTime = time;
        AbstractSmithingAnvilBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.f_58858_, (BlockState)this.m_58900_());
    }

    public void tick(Level lvl, BlockPos pos, BlockState st) {
        if (!pos.equals((Object)this.f_58858_)) {
            return;
        }
        try {
            ItemStack currentBlueprint = this.itemHandler.getStackInSlot(11);
            if (!ItemStack.m_150942_((ItemStack)currentBlueprint, (ItemStack)this.lastBlueprint) && (this.progress > 0 || this.lastRecipe != null || this.isMinigameOn())) {
                this.resetProgress(pos);
                this.setMinigameOn(false);
                OvergearedMod.LOGGER.debug("Blueprint changed at {}, minigame reset", (Object)pos);
            }
            this.lastBlueprint = currentBlueprint.m_41777_();
            Optional<ForgingRecipe> currentRecipeOpt = this.getCurrentRecipe();
            if (currentRecipeOpt.isEmpty()) {
                if (this.progress > 0 || this.lastRecipe != null) {
                    this.resetProgress(pos);
                }
                return;
            }
            ForgingRecipe currentRecipe = currentRecipeOpt.get();
            boolean recipeChanged = false;
            if (this.lastRecipe != null) {
                recipeChanged = !currentRecipe.m_6423_().equals((Object)this.lastRecipe.m_6423_());
            } else if (this.maxProgress > 0) {
                recipeChanged = true;
            }
            if (recipeChanged) {
                this.resetProgress(pos);
                this.lastRecipe = currentRecipe;
                return;
            }
            this.lastRecipe = currentRecipe;
            if (this.hasRecipe()) {
                this.maxProgress = currentRecipe.getHammeringRequired();
                this.hitRemains = this.maxProgress - this.progress;
                AbstractSmithingAnvilBlockEntity.m_155232_((Level)lvl, (BlockPos)pos, (BlockState)st);
                if (this.hasProgressFinished()) {
                    this.craftItem();
                    this.resetProgress(pos);
                }
            } else if (this.progress > 0 || this.maxProgress > 0) {
                this.resetProgress(pos);
            }
        }
        catch (Exception e) {
            OvergearedMod.LOGGER.error("Error ticking smithing anvil at {}", (Object)pos, (Object)e);
            this.resetProgress(pos);
        }
    }

    public int getHitsRemaining() {
        return this.hitRemains;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        return tag;
    }

    public static void applyForgingQuality(ItemStack stack, ForgingQuality quality) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_("ForgingQuality", quality.getDisplayName());
    }

    protected boolean matchesRecipeExactly(ForgingRecipe recipe) {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < 9; ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        inventory.m_6836_(11, this.itemHandler.getStackInSlot(11));
        return recipe.m_5818_((Container)inventory, this.f_58857_);
    }

    protected abstract String determineForgingQuality();

    public abstract String blueprintQuality();

    public void setProgress(int progress) {
        this.progress = progress;
        this.m_6596_();
        if (this.data != null) {
            this.data.m_8050_(0, progress);
        }
    }

    public int getRequiredProgress() {
        Optional<ForgingRecipe> recipe = this.getCurrentRecipe();
        ForgingRecipe currentRecipe = recipe.get();
        return currentRecipe.getHammeringRequired();
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
    }

    public void setOwner(UUID uuid) {
        this.ownerUUID = uuid;
        this.sessionStartTime = this.f_58857_.m_46467_();
        this.m_6596_();
    }

    public void clearOwner() {
        this.ownerUUID = null;
        this.sessionStartTime = 0L;
        this.m_6596_();
    }

    public boolean isOwnedBy(Player player) {
        return this.ownerUUID != null && this.ownerUUID.equals(player.m_20148_());
    }

    public boolean isOwned() {
        return this.ownerUUID != null;
    }

    public UUID getOccupiedAnvil(BlockPos pos) {
        return this.occupiedAnvils.get(pos);
    }

    public void putOccupiedAnvil(BlockPos pos, UUID me) {
        this.occupiedAnvils.put(pos, me);
    }

    public boolean hasQuality() {
        Optional<ForgingRecipe> recipeOptional = this.getCurrentRecipe();
        if (recipeOptional.isEmpty()) {
            return false;
        }
        ForgingRecipe recipe = recipeOptional.get();
        return recipe.hasQuality();
    }

    public boolean needsMinigame() {
        Optional<ForgingRecipe> recipeOptional = this.getCurrentRecipe();
        if (recipeOptional.isEmpty()) {
            return false;
        }
        ForgingRecipe recipe = recipeOptional.get();
        return !recipe.hasQuality() && recipe.needsMinigame();
    }

    public IItemHandlerModifiable getItemHandler() {
        return this.itemHandler;
    }

    public BlockPos getPos(ServerPlayer serverPlayer) {
        UUID playerUUID = serverPlayer.m_20148_();
        for (Map.Entry<BlockPos, UUID> entry : this.occupiedAnvils.entrySet()) {
            if (!entry.getValue().equals(playerUUID)) continue;
            return entry.getKey();
        }
        return null;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void setMinigameOn(boolean value) {
        this.minigameOn = value;
        this.m_6596_();
    }

    public boolean isMinigameOn() {
        return this.minigameOn;
    }
}

