/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.util.MutableHashedLinkedMap;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import net.stirdrem.overgeared.block.ModBlocks;
import net.stirdrem.overgeared.block.UpgradeArrowDispenseBehavior;
import net.stirdrem.overgeared.block.entity.ModBlockEntities;
import net.stirdrem.overgeared.block.entity.renderer.SmithingAnvilBlockEntityRenderer;
import net.stirdrem.overgeared.client.AnvilMinigameOverlay;
import net.stirdrem.overgeared.config.ClientConfig;
import net.stirdrem.overgeared.config.ServerConfig;
import net.stirdrem.overgeared.entity.ModEntities;
import net.stirdrem.overgeared.entity.renderer.LingeringArrowEntityRenderer;
import net.stirdrem.overgeared.entity.renderer.UpgradeArrowEntityRenderer;
import net.stirdrem.overgeared.event.ModAttributes;
import net.stirdrem.overgeared.item.ModCreativeModeTabs;
import net.stirdrem.overgeared.item.ModItems;
import net.stirdrem.overgeared.item.ToolTypeRegistry;
import net.stirdrem.overgeared.item.armor.model.CustomCopperHelmet;
import net.stirdrem.overgeared.item.armor.model.CustomCopperLeggings;
import net.stirdrem.overgeared.loot.ModLootModifiers;
import net.stirdrem.overgeared.networking.ModMessages;
import net.stirdrem.overgeared.recipe.BetterBrewingRecipe;
import net.stirdrem.overgeared.recipe.ModRecipeTypes;
import net.stirdrem.overgeared.recipe.ModRecipes;
import net.stirdrem.overgeared.screen.BlueprintWorkbenchScreen;
import net.stirdrem.overgeared.screen.FletchingStationScreen;
import net.stirdrem.overgeared.screen.ModMenuTypes;
import net.stirdrem.overgeared.screen.RockKnappingScreen;
import net.stirdrem.overgeared.screen.SteelSmithingAnvilScreen;
import net.stirdrem.overgeared.screen.StoneSmithingAnvilScreen;
import net.stirdrem.overgeared.screen.TierASmithingAnvilScreen;
import net.stirdrem.overgeared.screen.TierBSmithingAnvilScreen;
import net.stirdrem.overgeared.sound.ModSounds;
import net.stirdrem.overgeared.util.ModTags;
import net.stirdrem.overgeared.util.TickScheduler;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Unique;

@Mod(value="overgeared")
public class OvergearedMod {
    public static final String MOD_ID = "overgeared";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static boolean polymorph;

    public OvergearedMod() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModCreativeModeTabs.register(modEventBus);
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModMenuTypes.register(modEventBus);
        ModRecipes.register(modEventBus);
        ModRecipeTypes.register(modEventBus);
        ModLootModifiers.register(modEventBus);
        ModSounds.register(modEventBus);
        ModEntities.register(modEventBus);
        ModAttributes.register(modEventBus);
        MinecraftForge.EVENT_BUS.register(TickScheduler.class);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::sendImc);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        polymorph = ModList.get().isLoaded("polymorph");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ServerConfig.SERVER_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.CLIENT_CONFIG);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        ModMessages.register();
        ToolTypeRegistry.init();
        LOGGER.info("Tool types initialized: {}", (Object)ToolTypeRegistry.getRegisteredTypes().size());
        if (((Boolean)ServerConfig.ENABLE_DRAGON_BREATH_RECIPE.get()).booleanValue()) {
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new BetterBrewingRecipe(Potions.f_43601_, Items.f_42730_, new ItemStack((ItemLike)Items.f_42735_)));
        }
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        MutableHashedLinkedMap entries;
        if (event.getTabKey() == CreativeModeTabs.f_256791_) {
            entries = event.getEntries();
            entries.putAfter((Object)new ItemStack((ItemLike)Blocks.f_50091_), (Object)new ItemStack((ItemLike)ModBlocks.DRAFTING_TABLE.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
        if (event.getTabKey() == CreativeModeTabs.f_256788_) {
            entries = event.getEntries();
            entries.putAfter((Object)new ItemStack((ItemLike)Blocks.f_50074_), (Object)new ItemStack((ItemLike)ModBlocks.STEEL_BLOCK.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
        if (event.getTabKey() == CreativeModeTabs.f_256968_) {
            entries = event.getEntries();
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_42417_), (Object)new ItemStack((ItemLike)ModItems.STEEL_INGOT.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_151053_), (Object)new ItemStack((ItemLike)ModItems.CRUDE_STEEL.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
        if (event.getTabKey() == CreativeModeTabs.f_256869_) {
            entries = event.getEntries();
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_42397_), (Object)new ItemStack((ItemLike)ModItems.IRON_TONGS.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)ModItems.IRON_TONGS.get()), (Object)new ItemStack((ItemLike)ModItems.STEEL_TONGS.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)ModItems.STEEL_TONGS.get()), (Object)new ItemStack((ItemLike)ModItems.COPPER_SMITHING_HAMMER.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)ModItems.COPPER_SMITHING_HAMMER.get()), (Object)new ItemStack((ItemLike)ModItems.SMITHING_HAMMER.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)Items.f_42434_), (Object)new ItemStack((ItemLike)ModItems.COPPER_SHOVEL.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)ModItems.COPPER_SHOVEL.get()), (Object)new ItemStack((ItemLike)ModItems.COPPER_PICKAXE.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)ModItems.COPPER_PICKAXE.get()), (Object)new ItemStack((ItemLike)ModItems.COPPER_AXE.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putAfter((Object)new ItemStack((ItemLike)ModItems.COPPER_AXE.get()), (Object)new ItemStack((ItemLike)ModItems.COPPER_HOE.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putBefore((Object)new ItemStack((ItemLike)Items.f_42384_), (Object)new ItemStack((ItemLike)ModItems.COPPER_HOE.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putBefore((Object)new ItemStack((ItemLike)ModItems.COPPER_HOE.get()), (Object)new ItemStack((ItemLike)ModItems.COPPER_AXE.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putBefore((Object)new ItemStack((ItemLike)ModItems.COPPER_AXE.get()), (Object)new ItemStack((ItemLike)ModItems.COPPER_PICKAXE.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putBefore((Object)new ItemStack((ItemLike)ModItems.COPPER_PICKAXE.get()), (Object)new ItemStack((ItemLike)ModItems.COPPER_SHOVEL.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putBefore((Object)new ItemStack((ItemLike)Items.f_42389_), (Object)new ItemStack((ItemLike)ModItems.STEEL_HOE.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putBefore((Object)new ItemStack((ItemLike)ModItems.STEEL_HOE.get()), (Object)new ItemStack((ItemLike)ModItems.STEEL_AXE.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putBefore((Object)new ItemStack((ItemLike)ModItems.STEEL_AXE.get()), (Object)new ItemStack((ItemLike)ModItems.STEEL_PICKAXE.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            entries.putBefore((Object)new ItemStack((ItemLike)ModItems.STEEL_PICKAXE.get()), (Object)new ItemStack((ItemLike)ModItems.STEEL_SHOVEL.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
        if (event.getTabKey() == CreativeModeTabs.f_256797_) {
            if (((Boolean)ServerConfig.ENABLE_FLETCHING_RECIPES.get()).booleanValue()) {
                ItemStack arrow;
                for (Potion potion : ForgeRegistries.POTIONS) {
                    if (potion == Potions.f_43598_) continue;
                    arrow = new ItemStack((ItemLike)ModItems.LINGERING_ARROW.get());
                    arrow.m_41784_().m_128359_("Potion", ForgeRegistries.POTIONS.getKey((Object)potion).toString());
                    event.m_246342_(arrow);
                }
                for (Potion potion : ForgeRegistries.POTIONS) {
                    if (potion == Potions.f_43598_) continue;
                    arrow = new ItemStack((ItemLike)ModItems.IRON_UPGRADE_ARROW.get());
                    arrow.m_41784_().m_128359_("Potion", ForgeRegistries.POTIONS.getKey((Object)potion).toString());
                    event.m_246342_(arrow);
                }
                for (Potion potion : ForgeRegistries.POTIONS) {
                    if (potion == Potions.f_43598_) continue;
                    arrow = new ItemStack((ItemLike)ModItems.IRON_UPGRADE_ARROW.get());
                    arrow.m_41784_().m_128359_("Potion", ForgeRegistries.POTIONS.getKey((Object)potion).toString());
                    arrow.m_41784_().m_128379_("LingeringPotion", true);
                    event.m_246342_(arrow);
                }
                for (Potion potion : ForgeRegistries.POTIONS) {
                    if (potion == Potions.f_43598_) continue;
                    arrow = new ItemStack((ItemLike)ModItems.STEEL_UPGRADE_ARROW.get());
                    arrow.m_41784_().m_128359_("Potion", ForgeRegistries.POTIONS.getKey((Object)potion).toString());
                    event.m_246342_(arrow);
                }
                for (Potion potion : ForgeRegistries.POTIONS) {
                    if (potion == Potions.f_43598_) continue;
                    arrow = new ItemStack((ItemLike)ModItems.STEEL_UPGRADE_ARROW.get());
                    arrow.m_41784_().m_128359_("Potion", ForgeRegistries.POTIONS.getKey((Object)potion).toString());
                    arrow.m_41784_().m_128379_("LingeringPotion", true);
                    event.m_246342_(arrow);
                }
                for (Potion potion : ForgeRegistries.POTIONS) {
                    if (potion == Potions.f_43598_) continue;
                    arrow = new ItemStack((ItemLike)ModItems.DIAMOND_UPGRADE_ARROW.get());
                    arrow.m_41784_().m_128359_("Potion", ForgeRegistries.POTIONS.getKey((Object)potion).toString());
                    event.m_246342_(arrow);
                }
                for (Potion potion : ForgeRegistries.POTIONS) {
                    if (potion == Potions.f_43598_) continue;
                    arrow = new ItemStack((ItemLike)ModItems.DIAMOND_UPGRADE_ARROW.get());
                    arrow.m_41784_().m_128359_("Potion", ForgeRegistries.POTIONS.getKey((Object)potion).toString());
                    arrow.m_41784_().m_128379_("LingeringPotion", true);
                    event.m_246342_(arrow);
                }
            }
            event.getEntries().putBefore((Object)new ItemStack((ItemLike)Items.f_42383_), (Object)new ItemStack((ItemLike)ModItems.COPPER_SWORD.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)new ItemStack((ItemLike)Items.f_42430_), (Object)new ItemStack((ItemLike)ModItems.STEEL_SWORD.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putBefore((Object)new ItemStack((ItemLike)Items.f_42386_), (Object)new ItemStack((ItemLike)ModItems.COPPER_AXE.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)new ItemStack((ItemLike)Items.f_42433_), (Object)new ItemStack((ItemLike)ModItems.STEEL_AXE.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)new ItemStack((ItemLike)Items.f_42479_), (Object)new ItemStack((ItemLike)ModItems.STEEL_HELMET.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)new ItemStack((ItemLike)ModItems.STEEL_HELMET.get()), (Object)new ItemStack((ItemLike)ModItems.STEEL_CHESTPLATE.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)new ItemStack((ItemLike)ModItems.STEEL_CHESTPLATE.get()), (Object)new ItemStack((ItemLike)ModItems.STEEL_LEGGINGS.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)new ItemStack((ItemLike)ModItems.STEEL_LEGGINGS.get()), (Object)new ItemStack((ItemLike)ModItems.STEEL_BOOTS.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)new ItemStack((ItemLike)Items.f_42463_), (Object)new ItemStack((ItemLike)ModItems.COPPER_HELMET.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)new ItemStack((ItemLike)ModItems.COPPER_HELMET.get()), (Object)new ItemStack((ItemLike)ModItems.COPPER_CHESTPLATE.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)new ItemStack((ItemLike)ModItems.COPPER_CHESTPLATE.get()), (Object)new ItemStack((ItemLike)ModItems.COPPER_LEGGINGS.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)new ItemStack((ItemLike)ModItems.COPPER_LEGGINGS.get()), (Object)new ItemStack((ItemLike)ModItems.COPPER_BOOTS.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)new ItemStack((ItemLike)Items.f_42412_), (Object)new ItemStack((ItemLike)ModItems.IRON_UPGRADE_ARROW.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)new ItemStack((ItemLike)ModItems.IRON_UPGRADE_ARROW.get()), (Object)new ItemStack((ItemLike)ModItems.STEEL_UPGRADE_ARROW.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)new ItemStack((ItemLike)ModItems.STEEL_UPGRADE_ARROW.get()), (Object)new ItemStack((ItemLike)ModItems.DIAMOND_UPGRADE_ARROW.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    private void sendImc(InterModEnqueueEvent evt) {
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @Unique
    public static Item getCooledIngot(Item heatedItem) {
        ITag heatedTag = ForgeRegistries.ITEMS.tags().getTag(ModTags.Items.HEATED_METALS);
        ITag cooledTag = ForgeRegistries.ITEMS.tags().getTag(ModTags.Items.HEATABLE_METALS);
        int index = 0;
        for (Item item : heatedTag) {
            if (item == heatedItem) {
                int i = 0;
                for (Item cooledItem : cooledTag) {
                    if (i == index) {
                        return cooledItem;
                    }
                    ++i;
                }
            }
            ++index;
        }
        return heatedItem;
    }

    @Unique
    public static boolean isDurabilityMultiplierBlacklisted(ItemStack stack) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        return ((List)ServerConfig.BASE_DURABILITY_BLACKLIST.get()).contains(id.toString());
    }

    @Mod.EventBusSubscriber(modid="overgeared", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.STEEL_SMITHING_ANVIL_MENU.get()), SteelSmithingAnvilScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.TIER_A_SMITHING_ANVIL_MENU.get()), TierASmithingAnvilScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.TIER_B_SMITHING_ANVIL_MENU.get()), TierBSmithingAnvilScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.STONE_SMITHING_ANVIL_MENU.get()), StoneSmithingAnvilScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.ROCK_KNAPPING_MENU.get()), RockKnappingScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.BLUEPRINT_WORKBENCH_MENU.get()), BlueprintWorkbenchScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ModMenuTypes.FLETCHING_STATION_MENU.get()), FletchingStationScreen::new);
            ClientModEvents.registerArrowProperties((Item)ModItems.IRON_UPGRADE_ARROW.get());
            ClientModEvents.registerArrowProperties((Item)ModItems.STEEL_UPGRADE_ARROW.get());
            ClientModEvents.registerArrowProperties((Item)ModItems.DIAMOND_UPGRADE_ARROW.get());
        }

        private static void registerArrowProperties(Item item) {
            ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation(OvergearedMod.MOD_ID, "potion_type"), (stack, level, entity, seed) -> {
                if (!stack.m_41782_()) {
                    return 0.0f;
                }
                CompoundTag tag = stack.m_41783_();
                if (tag.m_128441_("LingeringPotion")) {
                    return 2.0f;
                }
                if (tag.m_128441_("Potion") || tag.m_128441_("CustomPotionEffects")) {
                    return 1.0f;
                }
                return 0.0f;
            });
        }

        @SubscribeEvent
        public static void registerBER(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.STEEL_SMITHING_ANVIL_BE.get(), SmithingAnvilBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.STONE_SMITHING_ANVIL_BE.get(), SmithingAnvilBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.TIER_A_SMITHING_ANVIL_BE.get(), SmithingAnvilBlockEntityRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.TIER_B_SMITHING_ANVIL_BE.get(), SmithingAnvilBlockEntityRenderer::new);
        }

        @SubscribeEvent
        public static void registerGuiOverlays(RegisterGuiOverlaysEvent event) {
            event.registerBelowAll("anvil_mg", AnvilMinigameOverlay.ANVIL_MG);
        }

        @SubscribeEvent
        public static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(CustomCopperHelmet.LAYER_LOCATION, CustomCopperHelmet::createBodyLayer);
            event.registerLayerDefinition(CustomCopperLeggings.LAYER_LOCATION, CustomCopperLeggings::createBodyLayer);
        }

        @SubscribeEvent
        public static void onRegisterItemColors(RegisterColorHandlersEvent.Item event) {
            ClientModEvents.registerArrowColor(event, (Item)ModItems.IRON_UPGRADE_ARROW.get());
            ClientModEvents.registerArrowColor(event, (Item)ModItems.STEEL_UPGRADE_ARROW.get());
            ClientModEvents.registerArrowColor(event, (Item)ModItems.DIAMOND_UPGRADE_ARROW.get());
            ClientModEvents.registerArrowColor(event, (Item)ModItems.LINGERING_ARROW.get());
        }

        private static void registerArrowColor(RegisterColorHandlersEvent.Item event, Item item) {
            event.register((stack, tintIndex) -> tintIndex == 0 && stack.m_41782_() ? ClientModEvents.getColor(stack) : -1, new ItemLike[]{item});
        }

        @SubscribeEvent
        public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer((EntityType)ModEntities.LINGERING_ARROW.get(), LingeringArrowEntityRenderer::new);
            event.registerEntityRenderer((EntityType)ModEntities.UPGRADE_ARROW.get(), UpgradeArrowEntityRenderer::new);
        }

        public static int getColor(ItemStack pStack) {
            CompoundTag compoundtag = pStack.m_41783_();
            if (compoundtag != null && compoundtag.m_128425_("CustomPotionColor", 99)) {
                return compoundtag.m_128451_("CustomPotionColor");
            }
            return ClientModEvents.getPotion(pStack) == Potions.f_43598_ ? 0xF800F8 : ClientModEvents.getColor(ClientModEvents.getMobEffects(pStack));
        }

        public static int getColor(Collection<MobEffectInstance> pEffects) {
            int i = 3694022;
            if (pEffects.isEmpty()) {
                return 3694022;
            }
            float f = 0.0f;
            float f1 = 0.0f;
            float f2 = 0.0f;
            int j = 0;
            for (MobEffectInstance mobeffectinstance : pEffects) {
                if (!mobeffectinstance.m_19572_()) continue;
                int k = mobeffectinstance.m_19544_().m_19484_();
                int l = mobeffectinstance.m_19564_() + 1;
                f += (float)(l * (k >> 16 & 0xFF)) / 255.0f;
                f1 += (float)(l * (k >> 8 & 0xFF)) / 255.0f;
                f2 += (float)(l * (k >> 0 & 0xFF)) / 255.0f;
                j += l;
            }
            if (j == 0) {
                return 0;
            }
            f = f / (float)j * 255.0f;
            f1 = f1 / (float)j * 255.0f;
            f2 = f2 / (float)j * 255.0f;
            return (int)f << 16 | (int)f1 << 8 | (int)f2;
        }

        public static Potion getPotion(ItemStack pStack) {
            return ClientModEvents.getPotion(pStack.m_41783_());
        }

        public static Potion getPotion(@Nullable CompoundTag tag) {
            if (tag == null) {
                return Potions.f_43598_;
            }
            if (tag.m_128425_("LingeringPotion", 8)) {
                return Potion.m_43489_((String)tag.m_128461_("LingeringPotion"));
            }
            if (tag.m_128441_("LingeringPotion") && tag.m_128471_("LingeringPotion")) {
                return Potion.m_43489_((String)tag.m_128461_("Potion"));
            }
            if (tag.m_128425_("Potion", 8)) {
                return Potion.m_43489_((String)tag.m_128461_("Potion"));
            }
            return Potions.f_43598_;
        }

        public static List<MobEffectInstance> getMobEffects(ItemStack pStack) {
            return ClientModEvents.getAllEffects(pStack.m_41783_());
        }

        public static List<MobEffectInstance> getAllEffects(@Nullable CompoundTag pCompoundTag) {
            ArrayList list = Lists.newArrayList();
            list.addAll(ClientModEvents.getPotion(pCompoundTag).m_43488_());
            ClientModEvents.getCustomEffects(pCompoundTag, list);
            return list;
        }

        public static void getCustomEffects(@Nullable CompoundTag pCompoundTag, List<MobEffectInstance> pEffectList) {
            if (pCompoundTag != null && pCompoundTag.m_128425_("CustomPotionEffects", 9)) {
                ListTag listtag = pCompoundTag.m_128437_("CustomPotionEffects", 10);
                for (int i = 0; i < listtag.size(); ++i) {
                    CompoundTag compoundtag = listtag.m_128728_(i);
                    MobEffectInstance mobeffectinstance = MobEffectInstance.m_19560_((CompoundTag)compoundtag);
                    if (mobeffectinstance == null) continue;
                    pEffectList.add(mobeffectinstance);
                }
            }
        }
    }

    @Mod.EventBusSubscriber(modid="overgeared", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class CommonModEvents {
        @SubscribeEvent
        public static void onCommonSetup(FMLCommonSetupEvent event) {
            event.enqueueWork(() -> {
                DispenserBlock.m_52672_((ItemLike)((ItemLike)ModItems.LINGERING_ARROW.get()), (DispenseItemBehavior)new UpgradeArrowDispenseBehavior());
                DispenserBlock.m_52672_((ItemLike)((ItemLike)ModItems.IRON_UPGRADE_ARROW.get()), (DispenseItemBehavior)new UpgradeArrowDispenseBehavior());
                DispenserBlock.m_52672_((ItemLike)((ItemLike)ModItems.STEEL_UPGRADE_ARROW.get()), (DispenseItemBehavior)new UpgradeArrowDispenseBehavior());
                DispenserBlock.m_52672_((ItemLike)((ItemLike)ModItems.DIAMOND_UPGRADE_ARROW.get()), (DispenseItemBehavior)new UpgradeArrowDispenseBehavior());
            });
        }
    }
}

