/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.util;

import java.util.LinkedList;
import java.util.Queue;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TickScheduler {
    private static final Queue<ScheduledTask> taskQueue = new LinkedList<ScheduledTask>();

    public static void schedule(int delayTicks, Runnable action) {
        if (action != null && delayTicks >= 0) {
            taskQueue.add(new ScheduledTask(delayTicks, action));
        }
    }

    public static void clear() {
        taskQueue.clear();
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        int size = taskQueue.size();
        for (int i = 0; i < size; ++i) {
            ScheduledTask task = taskQueue.poll();
            if (task == null) continue;
            --task.remainingTicks;
            if (task.remainingTicks <= 0) {
                try {
                    task.action.run();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            taskQueue.add(task);
        }
    }

    private static class ScheduledTask {
        int remainingTicks;
        Runnable action;

        ScheduledTask(int delayTicks, Runnable action) {
            this.remainingTicks = delayTicks;
            this.action = action;
        }
    }
}

