/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.block;

import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.stirdrem.overgeared.AnvilTier;
import net.stirdrem.overgeared.block.custom.AlloySmelterBlock;
import net.stirdrem.overgeared.block.custom.BlueprintWorkbenchBlock;
import net.stirdrem.overgeared.block.custom.NetherAlloySmelterBlock;
import net.stirdrem.overgeared.block.custom.SteelSmithingAnvil;
import net.stirdrem.overgeared.block.custom.StoneSmithingAnvil;
import net.stirdrem.overgeared.block.custom.TierASmithingAnvil;
import net.stirdrem.overgeared.block.custom.TierBSmithingAnvil;
import net.stirdrem.overgeared.item.ModItems;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"overgeared");
    public static final RegistryObject<Block> SMITHING_ANVIL = ModBlocks.registerBlock("smithing_anvil", () -> new SteelSmithingAnvil(AnvilTier.IRON, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50322_).m_60955_()));
    public static final RegistryObject<Block> TIER_A_SMITHING_ANVIL = ModBlocks.registerBlock("tier_a_smithing_anvil", () -> new TierASmithingAnvil(AnvilTier.ABOVE_A, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50322_).m_60955_()));
    public static final RegistryObject<Block> TIER_B_SMITHING_ANVIL = ModBlocks.registerBlock("tier_b_smithing_anvil", () -> new TierBSmithingAnvil(AnvilTier.ABOVE_B, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50322_).m_60955_()));
    public static final RegistryObject<Block> STONE_SMITHING_ANVIL = ModBlocks.registerBlock("stone_anvil", () -> new StoneSmithingAnvil(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60955_()));
    public static final RegistryObject<Block> STEEL_BLOCK = ModBlocks.registerBlock("steel_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_)));
    public static final RegistryObject<Block> DRAFTING_TABLE = ModBlocks.registerBlock("drafting_table", () -> new BlueprintWorkbenchBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50091_)));
    public static final RegistryObject<Block> ALLOY_FURNACE = ModBlocks.registerBlock("alloy_furnace", () -> new AlloySmelterBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50076_).m_60955_().m_60999_().m_60978_(3.5f).m_60953_(ModBlocks.litBlockEmission(13))));
    public static final RegistryObject<Block> NETHER_ALLOY_FURNACE = ModBlocks.registerBlock("nether_alloy_furnace", () -> new NetherAlloySmelterBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50076_).m_60955_().m_60999_().m_60978_(3.5f).m_60953_(ModBlocks.litBlockEmission(13))));
    private BlockState defaultBlockState;

    private static ToIntFunction<BlockState> litBlockEmission(int pLightValue) {
        return p_50763_ -> (Boolean)p_50763_.m_61143_((Property)BlockStateProperties.f_61443_) != false ? pLightValue : 0;
    }

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, RegistryObject<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }

    public final BlockState defaultBlockState() {
        return this.defaultBlockState;
    }
}

