/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.entity.custom;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class LingeringArrowEntity
extends Arrow {
    private static final EntityDataAccessor<Integer> DATA_POTION_COLOR = SynchedEntityData.m_135353_(LingeringArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final ItemStack referenceStack;

    public LingeringArrowEntity(Level level, LivingEntity shooter, ItemStack stack) {
        super(level, shooter);
        this.referenceStack = stack;
        int color = PotionUtils.m_43575_((ItemStack)stack);
        this.f_19804_.m_135381_(DATA_POTION_COLOR, (Object)color);
    }

    public LingeringArrowEntity(EntityType<? extends Arrow> type, Level level) {
        super(type, level);
        this.referenceStack = ItemStack.f_41583_;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_POTION_COLOR, (Object)-1);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("PotionColor", ((Integer)this.f_19804_.m_135370_(DATA_POTION_COLOR)).intValue());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_("PotionColor", 99)) {
            this.f_19804_.m_135381_(DATA_POTION_COLOR, (Object)tag.m_128451_("PotionColor"));
        }
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (!this.m_9236_().f_46443_) {
            ItemStack stack = this.referenceStack;
            Potion potion = PotionUtils.m_43579_((ItemStack)stack);
            List effects = PotionUtils.m_43566_((CompoundTag)stack.m_41783_());
            if (!effects.isEmpty()) {
                this.makeAreaOfEffectCloud(stack, effects, result);
            }
            int n = potion.m_43491_() ? 2007 : 2002;
        }
    }

    protected void m_8060_(BlockHitResult pResult) {
        super.m_8060_(pResult);
        if (!this.m_9236_().f_46443_) {
            ItemStack stack = this.referenceStack;
            Potion potion = PotionUtils.m_43579_((ItemStack)stack);
            List effects = PotionUtils.m_43547_((ItemStack)stack);
            if (!effects.isEmpty()) {
                this.makeAreaOfEffectCloud(stack, effects, (HitResult)pResult);
            }
            int n = potion.m_43491_() ? 2007 : 2002;
        }
    }

    private void makeAreaOfEffectCloud(ItemStack stack, List<MobEffectInstance> effects, HitResult result) {
        Vec3 hit = result.m_82450_();
        Vec3 motion = this.m_20184_();
        double verticalRatio = motion.f_82480_ / motion.m_82553_();
        double offset = verticalRatio > 0.0 ? -verticalRatio * 0.5 : -0.2;
        double cloudY = hit.f_82480_ + offset + 0.25;
        double cloudX = hit.f_82479_;
        double cloudZ = hit.f_82481_;
        AreaEffectCloud cloud = new AreaEffectCloud(this.m_9236_(), cloudX, cloudY, cloudZ);
        Entity owner = this.m_19749_();
        if (owner instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)owner;
            cloud.m_19718_(le);
        }
        cloud.m_19712_(3.0f);
        cloud.m_19732_(-0.5f);
        cloud.m_19740_(10);
        cloud.m_19738_(-cloud.m_19743_() / (float)cloud.m_19748_());
        cloud.m_19722_(this.f_36855_);
        for (MobEffectInstance inst : effects) {
            MobEffectInstance reducedEffect = new MobEffectInstance(inst.m_19544_(), Math.max(inst.m_19557_() / 8, 1), inst.m_19564_(), inst.m_19571_(), inst.m_19572_(), inst.m_19575_());
            cloud.m_19716_(reducedEffect);
        }
        CompoundTag compoundtag = stack.m_41783_();
        if (compoundtag != null && compoundtag.m_128425_("CustomPotionColor", 99)) {
            cloud.m_19714_(compoundtag.m_128451_("CustomPotionColor"));
        }
        this.m_9236_().m_7967_((Entity)cloud);
    }

    private void m_36876_(int amount) {
        int color = (Integer)this.f_19804_.m_135370_(DATA_POTION_COLOR);
        if (color != -1 && amount > 0) {
            double r = (double)(color >> 16 & 0xFF) / 255.0;
            double g = (double)(color >> 8 & 0xFF) / 255.0;
            double b = (double)(color & 0xFF) / 255.0;
            for (int j = 0; j < amount; ++j) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), r, g, b);
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_36703_) {
            if (this.f_36704_ % 5 == 0) {
                this.m_36876_(1);
            }
        } else {
            this.m_36876_(2);
        }
    }
}

