/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.recipe;

import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.stirdrem.overgeared.BlueprintQuality;
import net.stirdrem.overgeared.config.ServerConfig;
import net.stirdrem.overgeared.item.ModItems;
import net.stirdrem.overgeared.recipe.ModRecipes;
import net.stirdrem.overgeared.util.CastingConfigHelper;

public class ClayToolCastRecipe
extends CustomRecipe {
    private static final int[] CLAY_SLOTS = new int[]{1, 3, 5, 7};
    private Level lastLevel = null;

    public ClayToolCastRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer inv, Level level) {
        if (inv.m_6643_() != 9) {
            return false;
        }
        this.lastLevel = level;
        ItemStack center = inv.m_8020_(4);
        if (center.m_41619_()) {
            return false;
        }
        String toolType = CastingConfigHelper.getToolTypeForItem(level, center);
        if ("none".equals(toolType)) {
            return false;
        }
        boolean clayPattern = true;
        boolean netherPattern = true;
        for (int slot : CLAY_SLOTS) {
            ItemStack stack = inv.m_8020_(slot);
            clayPattern &= stack.m_150930_(Items.f_42461_);
            netherPattern &= stack.m_150930_(Items.f_42691_);
        }
        if (!clayPattern && !netherPattern) {
            return false;
        }
        for (int i = 0; i < 9; ++i) {
            if (i == 4 || i == 1 || i == 3 || i == 5 || i == 7 || inv.m_8020_(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        int maxAmount;
        if (!((Boolean)ServerConfig.ENABLE_CASTING.get()).booleanValue()) {
            return ItemStack.f_41583_;
        }
        ItemStack center = inv.m_8020_(4);
        if (center.m_41619_()) {
            return ItemStack.f_41583_;
        }
        Object level = this.lastLevel != null ? this.lastLevel : ServerLifecycleHooks.getCurrentServer().m_129783_();
        String toolType = CastingConfigHelper.getToolTypeForItem(level, center);
        if (toolType == null) {
            return ItemStack.f_41583_;
        }
        if ("none".equals(toolType) || toolType.isBlank()) {
            return ItemStack.f_41583_;
        }
        boolean netherPattern = true;
        for (int slot : CLAY_SLOTS) {
            ItemStack stack = inv.m_8020_(slot);
            netherPattern &= stack.m_150930_(Items.f_42691_);
        }
        ItemStack result = netherPattern ? new ItemStack((ItemLike)ModItems.NETHER_TOOL_CAST.get()) : new ItemStack((ItemLike)ModItems.UNFIRED_TOOL_CAST.get());
        CompoundTag centerTag = center.m_41783_();
        String quality = "none";
        if (centerTag != null && centerTag.m_128441_("ForgingQuality") && (quality = centerTag.m_128461_("ForgingQuality")).isEmpty()) {
            quality = "none";
        }
        if ((maxAmount = CastingConfigHelper.getMaxMaterialAmount(toolType)) <= 0) {
            maxAmount = 9;
        }
        if (!quality.equals("none")) {
            quality = BlueprintQuality.getPrevious(BlueprintQuality.fromString(quality)).getId();
        }
        CompoundTag tag = result.m_41784_();
        tag.m_128359_("ToolType", toolType);
        tag.m_128359_("Quality", quality);
        tag.m_128405_("Amount", 0);
        tag.m_128405_("MaxAmount", maxAmount);
        tag.m_128365_("Materials", (Tag)new CompoundTag());
        return result;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList remaining = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        ItemStack centerItem = inv.m_8020_(4);
        if (!centerItem.m_41619_()) {
            remaining.set(4, (Object)centerItem.m_41777_());
        }
        return remaining;
    }

    public boolean m_8004_(int w, int h) {
        return w * h >= 9;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.CLAY_TOOL_CAST.get();
    }
}

