/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.recipe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.stirdrem.overgeared.config.ServerConfig;
import net.stirdrem.overgeared.item.ModItems;
import net.stirdrem.overgeared.recipe.ModRecipes;
import net.stirdrem.overgeared.util.CastingConfigHelper;

public class DynamicToolCastRecipe
extends CustomRecipe {
    public DynamicToolCastRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    private static String getItemIdStringSafe(ItemStack stack) {
        if (stack.m_41619_()) {
            return "NONE";
        }
        ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        if (key == null) {
            return "NONE";
        }
        return key.toString();
    }

    public boolean matches(CraftingContainer inv, Level level) {
        ItemStack cast = ItemStack.f_41583_;
        boolean foundMaterial = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_150930_((Item)ModItems.CLAY_TOOL_CAST.get()) || stack.m_150930_((Item)ModItems.NETHER_TOOL_CAST.get())) {
                if (!cast.m_41619_()) {
                    return false;
                }
                cast = stack;
                continue;
            }
            String itemId = DynamicToolCastRecipe.getItemIdStringSafe(stack);
            String material = CastingConfigHelper.getMaterialForItem(stack);
            if (!material.equals("NONE")) {
                foundMaterial = true;
                continue;
            }
            return false;
        }
        return !cast.m_41619_() && foundMaterial;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        if (!((Boolean)ServerConfig.ENABLE_CASTING.get()).booleanValue()) {
            return ItemStack.f_41583_;
        }
        ItemStack cast = ItemStack.f_41583_;
        HashMap<String, Integer> materialTotals = new HashMap<String, Integer>();
        ArrayList<ItemStack> inputItems = new ArrayList<ItemStack>();
        int newAmount = 0;
        int maxAmount = 0;
        String toolType = "NONE";
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_150930_((Item)ModItems.CLAY_TOOL_CAST.get()) || stack.m_150930_((Item)ModItems.NETHER_TOOL_CAST.get())) {
                cast = stack.m_41777_();
                CompoundTag tag = cast.m_41784_();
                toolType = tag.m_128461_("ToolType");
                maxAmount = CastingConfigHelper.getMaxMaterialAmount(toolType);
                continue;
            }
            if (stack.m_41619_()) continue;
            String itemId = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString();
            String material = CastingConfigHelper.getMaterialForItem(stack);
            if (material.equals("NONE")) continue;
            int value = CastingConfigHelper.getMaterialValue(stack);
            materialTotals.put(material, materialTotals.getOrDefault(material, 0) + value);
            newAmount += value;
            ItemStack singleItem = stack.m_41777_();
            singleItem.m_41764_(1);
            inputItems.add(singleItem);
        }
        if (cast.m_41619_()) {
            return ItemStack.f_41583_;
        }
        CompoundTag castTag = cast.m_41784_();
        CompoundTag existingMatTag = castTag.m_128469_("Materials");
        int existingAmount = castTag.m_128451_("Amount");
        int totalAmount = existingAmount + newAmount;
        if (maxAmount > 0 && totalAmount > maxAmount) {
            return ItemStack.f_41583_;
        }
        for (String mat : existingMatTag.m_128431_()) {
            int oldVal = existingMatTag.m_128451_(mat);
            materialTotals.put(mat, materialTotals.getOrDefault(mat, 0) + oldVal);
        }
        CompoundTag newMatTag = new CompoundTag();
        for (Map.Entry entry : materialTotals.entrySet()) {
            newMatTag.m_128405_((String)entry.getKey(), ((Integer)entry.getValue()).intValue());
        }
        this.addItemStacksToInputList(castTag, inputItems);
        castTag.m_128365_("Materials", (Tag)newMatTag);
        castTag.m_128405_("Amount", totalAmount);
        castTag.m_128359_("ToolType", toolType);
        return cast;
    }

    private void addItemStacksToInputList(CompoundTag castTag, List<ItemStack> newInputItems) {
        ListTag inputList = castTag.m_128425_("input", 9) ? castTag.m_128437_("input", 10) : new ListTag();
        ArrayList<ItemStack> existingItems = new ArrayList<ItemStack>();
        for (Tag inputTag : inputList) {
            ItemStack existingItem;
            if (!(inputTag instanceof CompoundTag) || (existingItem = ItemStack.m_41712_((CompoundTag)((CompoundTag)inputTag))).m_41619_()) continue;
            existingItems.add(existingItem);
        }
        for (ItemStack newItem : newInputItems) {
            boolean merged = false;
            for (int i = 0; i < existingItems.size(); ++i) {
                ItemStack existingItem = (ItemStack)existingItems.get(i);
                if (!this.areItemStacksIdentical(existingItem, newItem)) continue;
                existingItem.m_41764_(existingItem.m_41613_() + newItem.m_41613_());
                merged = true;
                break;
            }
            if (merged) continue;
            existingItems.add(newItem.m_41777_());
        }
        ListTag mergedInputList = new ListTag();
        for (ItemStack item : existingItems) {
            CompoundTag itemTag = new CompoundTag();
            item.m_41739_(itemTag);
            mergedInputList.add((Object)itemTag);
        }
        castTag.m_128365_("input", (Tag)mergedInputList);
    }

    private boolean areItemStacksIdentical(ItemStack stack1, ItemStack stack2) {
        if (!ItemStack.m_41656_((ItemStack)stack1, (ItemStack)stack2)) {
            return false;
        }
        CompoundTag tag1 = stack1.m_41783_();
        CompoundTag tag2 = stack2.m_41783_();
        if (tag1 == null && tag2 == null) {
            return true;
        }
        if (tag1 == null || tag2 == null) {
            return false;
        }
        return tag1.equals((Object)tag2);
    }

    private void addItemStacksToInputListEfficient(CompoundTag castTag, List<ItemStack> newInputItems) {
        String signature;
        ListTag inputList = castTag.m_128425_("input", 9) ? castTag.m_128437_("input", 10) : new ListTag();
        HashMap<String, CompoundTag> itemMap = new HashMap<String, CompoundTag>();
        for (Tag inputTag : inputList) {
            if (!(inputTag instanceof CompoundTag)) continue;
            CompoundTag itemTag = (CompoundTag)inputTag;
            signature = this.getItemSignature(itemTag);
            itemMap.put(signature, itemTag);
        }
        for (ItemStack newItem : newInputItems) {
            CompoundTag newItemTag = new CompoundTag();
            newItem.m_41739_(newItemTag);
            signature = this.getItemSignature(newItemTag);
            if (itemMap.containsKey(signature)) {
                CompoundTag existingTag = (CompoundTag)itemMap.get(signature);
                int existingCount = existingTag.m_128445_("Count") & 0xFF;
                int newCount = newItemTag.m_128445_("Count") & 0xFF;
                existingTag.m_128344_("Count", (byte)Math.min(existingCount + newCount, 64));
                continue;
            }
            itemMap.put(signature, newItemTag);
        }
        ListTag mergedInputList = new ListTag();
        mergedInputList.addAll(itemMap.values());
        castTag.m_128365_("input", (Tag)mergedInputList);
    }

    private String getItemSignature(CompoundTag itemTag) {
        String itemId = itemTag.m_128461_("id");
        CompoundTag tag = itemTag.m_128469_("tag");
        return itemId + "#" + tag.toString();
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.CRAFTING_DYNAMIC_TOOL_CAST.get();
    }
}

