/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SmithingTemplateItem;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.stirdrem.overgeared.block.entity.AbstractSmithingAnvilBlockEntity;
import net.stirdrem.overgeared.item.ModItems;
import net.stirdrem.overgeared.recipe.ForgingRecipe;
import net.stirdrem.overgeared.recipe.ModRecipeTypes;
import net.stirdrem.overgeared.util.ModTags;
import org.jetbrains.annotations.NotNull;

public class AbstractSmithingAnvilMenu
extends AbstractContainerMenu {
    private final Container container = new SimpleContainer(new ItemStack[0]);
    public final AbstractSmithingAnvilBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;
    private final ResultContainer resultContainer = new ResultContainer();
    private Slot resultSlot;
    private final Player player;
    private final boolean hasBlueprint;
    private final List<Integer> craftingSlotIndices = new ArrayList<Integer>();
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 12;

    public AbstractSmithingAnvilMenu(MenuType<?> pMenuType, int pContainerId, Inventory inv, AbstractSmithingAnvilBlockEntity entity, ContainerData data, boolean hasBlueprint) {
        super(pMenuType, pContainerId);
        AbstractSmithingAnvilMenu.m_38869_((Container)inv, (int)12);
        this.blockEntity = entity;
        this.level = inv.f_35978_.m_9236_();
        this.data = data;
        this.player = inv.f_35978_;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.hasBlueprint = hasBlueprint;
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)iItemHandler, 9, 152, 61){

                public boolean m_5857_(@NotNull ItemStack stack) {
                    return stack.m_204117_(ModTags.Items.SMITHING_HAMMERS);
                }

                public boolean m_8010_(Player player) {
                    return true;
                }
            });
            if (hasBlueprint) {
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)iItemHandler, 11, 8, 35){

                    public boolean m_5857_(@NotNull ItemStack stack) {
                        return stack.m_150930_((Item)ModItems.BLUEPRINT.get()) || stack.m_41720_() instanceof SmithingTemplateItem;
                    }

                    public boolean m_8010_(Player player) {
                        return true;
                    }

                    public int m_6641_() {
                        return 1;
                    }

                    public int m_5866_(@NotNull ItemStack stack) {
                        return 1;
                    }

                    public void m_5852_(@NotNull ItemStack stack) {
                        super.m_5852_(stack.m_255036_(1));
                    }
                });
            }
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    Slot slotIndex = this.m_38897_((Slot)new SlotItemHandler((IItemHandler)iItemHandler, j + i * 3, 30 + j * 18, 17 + i * 18){

                        public boolean m_8010_(Player player) {
                            return true;
                        }
                    });
                    this.craftingSlotIndices.add(slotIndex.f_40219_);
                }
            }
            this.resultSlot = new SlotItemHandler((IItemHandler)iItemHandler, 10, 124, 35){
                private int removeCount;

                public boolean m_5857_(ItemStack stack) {
                    return false;
                }

                public boolean m_8010_(Player player) {
                    return true;
                }

                public void m_142406_(Player player, ItemStack stack) {
                    this.m_5845_(stack);
                    Container craftingContainer = AbstractSmithingAnvilMenu.this.container;
                    NonNullList remainders = player.m_9236_().m_7465_().m_44069_((RecipeType)ModRecipeTypes.FORGING.get(), AbstractSmithingAnvilMenu.this.container, player.m_9236_());
                    for (int i = 0; i < remainders.size(); ++i) {
                        ItemStack toRemove = craftingContainer.m_8020_(i);
                        ItemStack toReplace = (ItemStack)remainders.get(i);
                        if (!toRemove.m_41619_()) {
                            craftingContainer.m_7407_(i, 1);
                            toRemove = craftingContainer.m_8020_(i);
                        }
                        if (toReplace.m_41619_()) continue;
                        if (toRemove.m_41619_()) {
                            craftingContainer.m_6836_(i, toRemove);
                            continue;
                        }
                        if (ItemStack.m_150942_((ItemStack)toRemove, (ItemStack)toReplace)) {
                            toReplace.m_41769_(toRemove.m_41613_());
                            craftingContainer.m_6836_(i, toReplace);
                            continue;
                        }
                        if (player.m_150109_().m_36054_(toReplace)) continue;
                        player.m_36176_(toReplace, false);
                    }
                }

                public ItemStack m_6201_(int amount) {
                    if (this.m_6657_()) {
                        this.removeCount += Math.min(amount, this.m_7993_().m_41613_());
                    }
                    return super.m_6201_(amount);
                }

                public void m_7169_(ItemStack output, int amount) {
                    this.removeCount += amount;
                    this.m_5845_(output);
                }

                protected void m_6405_(int amount) {
                    this.removeCount = amount;
                }

                protected void m_5845_(ItemStack stack) {
                    Container container;
                    if (this.removeCount > 0) {
                        stack.m_41678_(AbstractSmithingAnvilMenu.this.player.m_9236_(), AbstractSmithingAnvilMenu.this.player, this.removeCount);
                    }
                    if ((container = this.f_40218_) instanceof RecipeHolder) {
                        RecipeHolder recipeHolder = (RecipeHolder)container;
                        recipeHolder.m_58395_(AbstractSmithingAnvilMenu.this.player, List.of());
                    }
                    this.removeCount = 0;
                }
            };
            this.m_38897_(this.resultSlot);
        });
        this.m_38884_(data);
    }

    public List<Integer> getInputSlots() {
        return new ArrayList<Integer>(this.craftingSlotIndices);
    }

    public ItemStack m_7648_(Player playerIn, int pIndex) {
        Slot sourceSlot = (Slot)this.f_38839_.get(pIndex);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (pIndex < 36) {
            if (!this.m_38903_(sourceStack, 36, 47, false)) {
                return ItemStack.f_41583_;
            }
        } else if (pIndex < 48) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            System.out.println("Invalid slotIndex:" + pIndex);
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean isCrafting() {
        return this.data.m_6413_(0) > 0;
    }

    public int getScaledProgress() {
        int progress = this.data.m_6413_(0);
        int maxProgress = this.data.m_6413_(1);
        int progressArrowSize = 24;
        return maxProgress != 0 && progress != 0 ? progress * progressArrowSize / maxProgress : 0;
    }

    public boolean m_6875_(Player player) {
        BlockState state = player.m_9236_().m_8055_(this.blockEntity.m_58899_());
        Block block = state.m_60734_();
        boolean isValid = block.m_49966_().m_204336_(ModTags.Blocks.SMITHING_ANVIL);
        return AbstractContainerMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)block) && isValid;
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public int getRemainingHits() {
        int progress = this.data.m_6413_(0);
        int maxProgress = this.data.m_6413_(1);
        return maxProgress - progress;
    }

    public ItemStack getResultItem() {
        if (this.blockEntity != null) {
            return this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).map(handler -> {
                ItemStack result = handler.getStackInSlot(10);
                return result.m_41777_();
            }).orElse(ItemStack.f_41583_);
        }
        return ItemStack.f_41583_;
    }

    public ItemStack getGhostResult() {
        Optional<ForgingRecipe> recipeOptional = this.blockEntity.getCurrentRecipe();
        if (recipeOptional.isPresent()) {
            ForgingRecipe recipe = recipeOptional.get();
            if (this.blockEntity.hasRecipe()) {
                return recipe.m_8043_(this.level.m_9598_()).m_41777_();
            }
        }
        return ItemStack.f_41583_;
    }
}

