/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.block.custom;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import net.stirdrem.overgeared.AnvilTier;
import net.stirdrem.overgeared.block.entity.AbstractSmithingAnvilBlockEntity;
import net.stirdrem.overgeared.config.ServerConfig;
import net.stirdrem.overgeared.event.AnvilMinigameEvents;
import net.stirdrem.overgeared.event.ModEvents;
import net.stirdrem.overgeared.event.ModItemInteractEvents;
import net.stirdrem.overgeared.networking.ModMessages;
import net.stirdrem.overgeared.networking.packet.PacketSendCounterC2SPacket;
import net.stirdrem.overgeared.networking.packet.ResetMinigameS2CPacket;
import net.stirdrem.overgeared.sound.ModSounds;
import net.stirdrem.overgeared.util.ModTags;
import org.jetbrains.annotations.Nullable;
import org.joml.Random;
import org.joml.Vector3f;

public abstract class AbstractSmithingAnvilNew
extends BaseEntityBlock
implements Fallable {
    protected static final int HAMMER_SOUND_DURATION_TICKS = 6;
    protected static String quality = null;
    protected static AnvilTier tier;

    public AbstractSmithingAnvilNew(AnvilTier anvilTier, BlockBehaviour.Properties properties) {
        super(properties);
        tier = anvilTier;
    }

    public String getQuality() {
        return quality != null ? quality : "none";
    }

    public static void setQuality(String quality) {
        AbstractSmithingAnvilNew.quality = quality;
    }

    public abstract VoxelShape m_5940_(BlockState var1, BlockGetter var2, BlockPos var3, CollisionContext var4);

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (pState.m_60734_() != pNewState.m_60734_() && (blockEntity = pLevel.m_7702_(pPos)) instanceof AbstractSmithingAnvilBlockEntity) {
            ((AbstractSmithingAnvilBlockEntity)blockEntity).drops();
            if (!pLevel.m_5776_()) {
                ModEvents.resetMinigameForAnvil(pLevel, pPos);
            }
        }
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack held = player.m_21120_(hand);
        boolean isHammer = held.m_204117_(ModTags.Items.SMITHING_HAMMERS);
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof AbstractSmithingAnvilBlockEntity)) {
            return InteractionResult.PASS;
        }
        AbstractSmithingAnvilBlockEntity anvil = (AbstractSmithingAnvilBlockEntity)be;
        if (level.m_5776_()) {
            if (player.m_6047_()) {
                return InteractionResult.SUCCESS;
            }
            if (anvil.hasRecipe() && isHammer) {
                AnvilMinigameEvents.resetPopUps();
                if (!pos.equals((Object)AnvilMinigameEvents.getAnvilPos(player.m_20148_()))) {
                    return InteractionResult.SUCCESS;
                }
                if (!AnvilMinigameEvents.isIsVisible()) {
                    return InteractionResult.SUCCESS;
                }
                String quality = AnvilMinigameEvents.handleHit();
                ModMessages.sendToServer(new PacketSendCounterC2SPacket(pos, quality));
                AnvilMinigameEvents.speedUp();
                return InteractionResult.SUCCESS;
            }
            AnvilMinigameEvents.setIsVisible(pos, false);
            return InteractionResult.SUCCESS;
        }
        long now = level.m_46467_();
        if (anvil.hasRecipe()) {
            UUID currentOwner = anvil.getOwnerUUID();
            if (currentOwner != null && !currentOwner.equals(player.m_20148_()) && player instanceof ServerPlayer) {
                GameProfile ownerProfile;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Player ownerPlayer = level.m_46003_(currentOwner);
                String ownerName = ownerPlayer != null ? ownerPlayer.m_5446_().getString() : ((ownerProfile = (GameProfile)level.m_7654_().m_129927_().m_11002_(currentOwner).orElse(null)) != null ? ownerProfile.getName() : "Another player");
                serverPlayer.m_240418_((Component)Component.m_237110_((String)"message.overgeared.anvil_in_use_by_another", (Object[])new Object[]{ownerName}).m_130940_(ChatFormatting.RED), true);
                return InteractionResult.FAIL;
            }
            BlockPos pos1 = ModItemInteractEvents.playerAnvilPositions.get(player.m_20148_());
            if (pos1 != null && isHammer && (anvil.isMinigameOn() || !anvil.hasQuality() && !anvil.needsMinigame() || !((Boolean)ServerConfig.ENABLE_MINIGAME.get()).booleanValue())) {
                if (!pos.equals((Object)ModItemInteractEvents.playerAnvilPositions.get(player.m_20148_()))) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.m_240418_((Component)Component.m_237115_((String)"message.overgeared.another_anvil_in_use").m_130940_(ChatFormatting.RED), true);
                    return InteractionResult.FAIL;
                }
                if (!((Boolean)ServerConfig.ENABLE_MINIGAME.get()).booleanValue()) {
                    anvil.setBusyUntil(now + 6L);
                }
                held.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                anvil.increaseForgingProgress(level, pos, state);
                this.spawnAnvilParticles(level, pos);
                if (anvil.getHitsRemaining() == 1) {
                    if (anvil.isFailedResult()) {
                        level.m_5594_(null, pos, (SoundEvent)ModSounds.FORGING_FAILED.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    } else {
                        level.m_5594_(null, pos, (SoundEvent)ModSounds.FORGING_COMPLETE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                } else {
                    level.m_5594_(null, pos, (SoundEvent)ModSounds.ANVIL_HIT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
            ModItemInteractEvents.hideMinigame((ServerPlayer)player);
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)anvil, (BlockPos)pos);
        } else {
            ModItemInteractEvents.releaseAnvil((ServerPlayer)player, pos);
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)anvil, (BlockPos)pos);
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    protected void spawnAnvilParticles(Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Random random = new Random();
            for (int i = 0; i < 6; ++i) {
                double offsetX = 0.5 + ((double)random.nextFloat() - 0.5);
                double offsetY = 1.0 + (double)random.nextFloat() * 0.5;
                double offsetZ = 0.5 + ((double)random.nextFloat() - 0.5);
                double velocityX = ((double)random.nextFloat() - 0.5) * 0.1;
                double velocityY = (double)random.nextFloat() * 0.1;
                double velocityZ = ((double)random.nextFloat() - 0.5) * 0.1;
                serverLevel.m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 0.5f, 0.0f), 1.0f), (double)pos.m_123341_() + offsetX, (double)pos.m_123342_() + offsetY, (double)pos.m_123343_() + offsetZ, 1, velocityX, velocityY, velocityZ, 1.0);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, (double)pos.m_123341_() + offsetX, (double)pos.m_123342_() + offsetY, (double)pos.m_123343_() + offsetZ, 1, velocityX, velocityY, velocityZ, 1.0);
            }
        }
    }

    @Nullable
    public abstract BlockEntity m_142194_(BlockPos var1, BlockState var2);

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (!level.m_5776_() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ModEvents.resetMinigameForPlayer(serverPlayer, pos);
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        if (!level.m_5776_()) {
            ModEvents.resetMinigameForAnvil(level, pos);
        }
        super.onBlockExploded(state, level, pos, explosion);
    }

    protected void resetMinigameData(Level level, BlockPos pos) {
        if (!level.m_5776_()) {
            for (ServerPlayer player : level.m_7654_().m_6846_().m_11314_()) {
                UUID playerId = player.m_20148_();
                if (!ModItemInteractEvents.playerAnvilPositions.getOrDefault(playerId, BlockPos.f_121853_).equals((Object)pos)) continue;
                ModMessages.sendToPlayer(new ResetMinigameS2CPacket(pos), player);
                ModItemInteractEvents.playerAnvilPositions.remove(playerId);
                ModItemInteractEvents.playerMinigameVisibility.remove(playerId);
                break;
            }
        }
    }

    public static String getTier() {
        return tier.getDisplayName();
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, level, pos, oldState, isMoving);
        level.m_186460_(pos, (Block)this, 2);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource pRandom) {
        BlockPos below;
        BlockState stateBelow;
        if (!level.f_46443_ && FallingBlock.m_53241_((BlockState)(stateBelow = level.m_8055_(below = pos.m_7495_())))) {
            FallingBlockEntity falling = FallingBlockEntity.m_201971_((Level)level, (BlockPos)pos, (BlockState)state);
            this.customizeFallingEntity(falling, (Level)level);
        }
    }

    protected void customizeFallingEntity(FallingBlockEntity entity, Level level) {
        entity.m_149656_(2.0f, 40);
        entity.f_31943_ = true;
    }

    public void m_48792_(Level pLevel, BlockPos pPos, BlockState pState, BlockState pReplaceableState, FallingBlockEntity pFallingBlock) {
        if (!pFallingBlock.m_20067_()) {
            pLevel.m_46796_(1031, pPos, 0);
        }
    }

    public DamageSource m_252932_(Entity pEntity) {
        return pEntity.m_269291_().m_269230_(pEntity);
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        pLevel.m_186460_(pPos, (Block)this, 2);
        return super.m_7417_(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }
}

