/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.block.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.stirdrem.overgeared.block.entity.AbstractSmithingAnvilBlockEntity;

public class SmithingAnvilBlockEntityRenderer
implements BlockEntityRenderer<AbstractSmithingAnvilBlockEntity> {
    private static final float BASE_Y = 1.01f;
    private static final float ITEM_HEIGHT = 0.02f;
    private static final float BLOCK_HEIGHT = 0.2f;
    private static final float BLOCK_BASE_Y_OFFSET = 0.09f;

    public SmithingAnvilBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(AbstractSmithingAnvilBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        ItemStack output = pBlockEntity.getRenderStack(10);
        boolean inputsEmpty = this.areInputSlotsEmpty(pBlockEntity);
        float zOffset = inputsEmpty ? 0.0f : -0.43f;
        int progress = pBlockEntity.getContainerData().m_6413_(0);
        int max = pBlockEntity.getContainerData().m_6413_(1);
        float heightScale = max <= 0 ? 1.0f : 1.0f - (float)progress / (float)max;
        if (!output.m_41619_()) {
            float yOffset = this.isBlockItem(output) ? 1.05f : 1.02f;
            this.renderStack(pPoseStack, pBuffer, itemRenderer, output, pBlockEntity, 0.0f, yOffset, zOffset, 110.0f, 0.4f, 1.0f);
        }
        HashSet<Item> renderedItems = new HashSet<Item>();
        HashSet<Integer> renderedSlots = new HashSet<Integer>();
        int rendered = 0;
        if ((rendered = this.renderPass(pPoseStack, pBuffer, itemRenderer, pBlockEntity, renderedItems, renderedSlots, 0.0f, rendered, true, heightScale)) < 3) {
            this.renderPass(pPoseStack, pBuffer, itemRenderer, pBlockEntity, renderedItems, renderedSlots, 0.0f, rendered, false, heightScale);
        }
        ItemStack hammer = pBlockEntity.getRenderStack(9);
        this.renderStack(pPoseStack, pBuffer, itemRenderer, hammer, pBlockEntity, 0.0f, 1.025f, 0.43f, 135.0f, 0.5f, 1.0f);
    }

    private boolean areInputSlotsEmpty(AbstractSmithingAnvilBlockEntity be) {
        for (int i = 0; i < 9; ++i) {
            if (be.getRenderStack(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    private int renderPass(PoseStack pPoseStack, MultiBufferSource pBuffer, ItemRenderer itemRenderer, AbstractSmithingAnvilBlockEntity pBlockEntity, Set<Item> renderedItems, Set<Integer> renderedSlots, float zOffset, int renderedCount, boolean checkUniqueness, float heightScale) {
        float currentHeight = 1.01f;
        for (int i : renderedSlots) {
            ItemStack prev = pBlockEntity.getRenderStack(i);
            currentHeight += this.isBlockItem(prev) ? 0.2f : 0.02f;
        }
        int rendered = renderedCount;
        for (int i = 0; i < 9 && rendered < 3; ++i) {
            ItemStack stack;
            if (renderedSlots.contains(i) || (stack = pBlockEntity.getRenderStack(i)).m_41619_()) continue;
            Item item = stack.m_41720_();
            if (checkUniqueness && renderedItems.contains(item)) continue;
            float scale = this.isBlockItem(stack) ? 0.4f : 0.35f;
            float rotation = 96.0f + (float)rendered * 14.0f;
            float yOffset = currentHeight;
            if (this.isBlockItem(stack)) {
                yOffset += 0.09f;
            }
            this.renderStack(pPoseStack, pBuffer, itemRenderer, stack, pBlockEntity, 0.0f, yOffset, zOffset, rotation, scale, heightScale);
            currentHeight += this.isBlockItem(stack) ? 0.2f : 0.02f;
            renderedItems.add(item);
            renderedSlots.add(i);
            ++rendered;
        }
        return rendered;
    }

    private boolean isBlockItem(ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return false;
        }
        Item item = stack.m_41720_();
        Block block = Block.m_49814_((Item)item);
        return block != Blocks.f_50016_;
    }

    private void renderStack(PoseStack poseStack, MultiBufferSource buffer, ItemRenderer itemRenderer, ItemStack itemStack, AbstractSmithingAnvilBlockEntity blockEntity, float xOffset, float yOffset, float zOffset, float rotationDegrees, float scale, float heightScale) {
        if (itemStack == null || itemStack.m_41619_()) {
            return;
        }
        poseStack.m_85836_();
        BlockState state = blockEntity.m_58900_();
        Direction facing = state.m_61138_((Property)BlockStateProperties.f_61374_) ? (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_) : Direction.NORTH;
        float facingRotationDegrees = switch (facing) {
            case Direction.NORTH -> 180.0f;
            case Direction.SOUTH -> 0.0f;
            case Direction.WEST -> 270.0f;
            case Direction.EAST -> 90.0f;
            default -> 0.0f;
        };
        double radians = Math.toRadians(facingRotationDegrees);
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        float rotatedX = (float)((double)xOffset * cos - (double)zOffset * sin);
        float rotatedZ = (float)((double)xOffset * sin + (double)zOffset * cos);
        poseStack.m_85837_((double)(0.5f - rotatedX), (double)yOffset - 0.01 * (double)(1.0f - heightScale), (double)(0.5f + rotatedZ));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(facingRotationDegrees));
        boolean isBlock = itemStack.m_41720_() instanceof BlockItem;
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rotationDegrees));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(isBlock ? 0.0f : 90.0f));
        poseStack.m_85841_(scale, scale, scale * heightScale);
        itemRenderer.m_269128_(itemStack, ItemDisplayContext.FIXED, this.getLightLevel(blockEntity.m_58904_(), blockEntity.m_58899_()), OverlayTexture.f_118083_, poseStack, buffer, blockEntity.m_58904_(), 1);
        poseStack.m_85849_();
    }

    private int getLightLevel(Level level, BlockPos pos) {
        int bLight = level.m_45517_(LightLayer.BLOCK, pos);
        int sLight = level.m_45517_(LightLayer.SKY, pos);
        return LightTexture.m_109885_((int)bLight, (int)sLight);
    }
}

