/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.stirdrem.overgeared.networking.ModMessages;
import net.stirdrem.overgeared.networking.packet.KnappingChipC2SPacket;
import net.stirdrem.overgeared.screen.RockKnappingMenu;

public class RockKnappingScreen
extends AbstractContainerScreen<RockKnappingMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.m_214293_((String)"overgeared", (String)"textures/gui/rock_knapping_gui.png");
    private static final ResourceLocation CHIPPED_TEXTURE = ResourceLocation.m_214293_((String)"overgeared", (String)"textures/gui/blank.png");
    private static final ResourceLocation UNCHIPPED_TEXTURE = ResourceLocation.m_135820_((String)"textures/block/stone.png");
    private static final int GRID_ORIGIN_X = 32;
    private static final int GRID_ORIGIN_Y = 19;
    private static final int SLOT_SIZE = 16;
    private final Set<Integer> chippedSpots = new HashSet<Integer>();

    public RockKnappingScreen(RockKnappingMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = 166;
        this.f_97731_ = this.f_97727_ - 94;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97728_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2;
        this.chippedSpots.clear();
        this.addKnappingButtons();
    }

    protected void m_181908_() {
        super.m_181908_();
        if (!((RockKnappingMenu)this.f_97732_).isKnappingFinished()) {
            this.addKnappingButtons();
        } else {
            this.m_169413_();
        }
    }

    private void addKnappingButtons() {
        this.m_169413_();
        if (((RockKnappingMenu)this.f_97732_).isKnappingFinished()) {
            return;
        }
        boolean hasResult = !((RockKnappingMenu)this.f_97732_).m_38853_(9).m_7993_().m_41619_();
        boolean resultCollected = ((RockKnappingMenu)this.f_97732_).isResultCollected();
        boolean canContinueKnapping = hasResult && !resultCollected;
        for (int i = 0; i < 9; ++i) {
            int col = i % 3;
            int row = i / 3;
            int x = this.f_97735_ + 32 + col * 16;
            int y = this.f_97736_ + 19 + row * 16;
            int index = i;
            ResourceLocation texture = ((RockKnappingMenu)this.f_97732_).isChipped(i) || resultCollected ? CHIPPED_TEXTURE : UNCHIPPED_TEXTURE;
            boolean isChipped = ((RockKnappingMenu)this.f_97732_).isChipped(i);
            ImageButton button = new ImageButton(x, y, 16, 16, 0, 0, 0, texture, 16, 16, btn -> {
                if (!(hasResult && !canContinueKnapping || isChipped)) {
                    ((RockKnappingMenu)this.f_97732_).setChip(index);
                    this.chippedSpots.add(index);
                    if (!resultCollected) {
                        ModMessages.sendToServer(new KnappingChipC2SPacket(index));
                        this.f_96541_.f_91074_.m_5496_(SoundEvents.f_12442_, 1.0f, 1.0f);
                    }
                    this.addKnappingButtons();
                }
            }){

                public boolean m_6375_(double mouseX, double mouseY, int button) {
                    if (!((RockKnappingMenu)RockKnappingScreen.this.f_97732_).isKnappingFinished()) {
                        return super.m_6375_(mouseX, mouseY, button);
                    }
                    return false;
                }

                public void m_7435_(SoundManager pHandler) {
                }
            };
            button.f_93623_ = !((RockKnappingMenu)this.f_97732_).isKnappingFinished();
            this.m_142416_((GuiEventListener)button);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = this.f_97735_;
        int y = this.f_97736_;
        graphics.m_280218_(TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 0x404040, false);
        graphics.m_280614_(this.f_96547_, this.f_169604_, 8, this.f_97731_, 0x404040, false);
    }

    private void handleKnappingDrag(double mouseX, double mouseY) {
        for (int i = 0; i < 9; ++i) {
            int col = i % 3;
            int row = i / 3;
            int x = this.f_97735_ + 32 + col * 16;
            int y = this.f_97736_ + 19 + row * 16;
            if (!(mouseX >= (double)x) || !(mouseX < (double)(x + 16)) || !(mouseY >= (double)y) || !(mouseY < (double)(y + 16)) || ((RockKnappingMenu)this.f_97732_).isKnappingFinished() || ((RockKnappingMenu)this.f_97732_).isChipped(i)) continue;
            ((RockKnappingMenu)this.f_97732_).setChip(i);
            this.chippedSpots.add(i);
            if (!((RockKnappingMenu)this.f_97732_).isResultCollected()) {
                ModMessages.sendToServer(new KnappingChipC2SPacket(i));
                this.f_96541_.f_91074_.m_5496_(SoundEvents.f_12442_, 1.0f, 1.0f);
            }
            this.addKnappingButtons();
            break;
        }
    }
}

