/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.stirdrem.overgeared.config.ServerConfig;
import net.stirdrem.overgeared.datapack.MaterialSettingsReloadListener;
import net.stirdrem.overgeared.recipe.ItemToToolTypeRecipe;
import net.stirdrem.overgeared.recipe.ModRecipeTypes;

public class ConfigHelper {
    public static String getToolTypeDisplayName(String toolType) {
        return "tooltype.overgeared." + toolType.toLowerCase();
    }

    public static int getMaxMaterialAmount(String toolType) {
        for (List e : (List)ServerConfig.CASTING_TOOL_TYPES.get()) {
            List row = e;
            if (!row.get(0).equals(toolType)) continue;
            return ((Number)row.get(1)).intValue();
        }
        return 0;
    }

    public static String getMaterialDisplayName(String materialId) {
        return "material.overgeared." + materialId.toLowerCase();
    }

    public static String getToolTypeForItem(Level level, ItemStack stack) {
        return level.m_7465_().m_44013_((RecipeType)ModRecipeTypes.ITEM_TO_TOOLTYPE.get()).stream().filter(r -> r.getInput().test(stack)).map(ItemToToolTypeRecipe::getToolType).findFirst().orElse("none");
    }

    public static String getMaterialForItem(ItemStack stack) {
        return ConfigHelper.getMaterialForItem(stack.m_41720_());
    }

    public static String getMaterialForItem(Item item) {
        Optional<MaterialSettingsReloadListener.MaterialEntry> datapackEntry = MaterialSettingsReloadListener.getAllMaterialEntries().stream().filter(entry -> ConfigHelper.matchesItemOrTag(item, entry.getItemOrTag())).findFirst();
        if (datapackEntry.isPresent()) {
            return datapackEntry.get().getMaterialId();
        }
        for (List e : (List)ServerConfig.MATERIAL_SETTING.get()) {
            List row = e;
            String key = (String)row.get(0);
            if (!ConfigHelper.matchesItemOrTag(item, key)) continue;
            return (String)row.get(1);
        }
        return "none";
    }

    public static int getMaterialValue(ItemStack stack) {
        return ConfigHelper.getMaterialValue(stack.m_41720_());
    }

    public static int getMaterialValue(Item item) {
        Optional<MaterialSettingsReloadListener.MaterialEntry> datapackEntry = MaterialSettingsReloadListener.getAllMaterialEntries().stream().filter(entry -> ConfigHelper.matchesItemOrTag(item, entry.getItemOrTag())).findFirst();
        if (datapackEntry.isPresent()) {
            return datapackEntry.get().getMaterialValue();
        }
        for (List e : (List)ServerConfig.MATERIAL_SETTING.get()) {
            List row = e;
            String key = (String)row.get(0);
            if (!ConfigHelper.matchesItemOrTag(item, key)) continue;
            return ((Number)row.get(2)).intValue();
        }
        return 0;
    }

    public static boolean isValidMaterial(ItemStack stack) {
        return ConfigHelper.isValidMaterial(stack.m_41720_());
    }

    public static boolean isValidMaterial(Item item) {
        boolean isValidInDatapack = MaterialSettingsReloadListener.getAllMaterialEntries().stream().anyMatch(entry -> ConfigHelper.matchesItemOrTag(item, entry.getItemOrTag()));
        if (isValidInDatapack) {
            return true;
        }
        for (List e : (List)ServerConfig.MATERIAL_SETTING.get()) {
            List row = e;
            String key = (String)row.get(0);
            if (!ConfigHelper.matchesItemOrTag(item, key)) continue;
            return true;
        }
        return false;
    }

    public static Map<String, Integer> getMaterialValuesForItem(ItemStack stack) {
        return ConfigHelper.getMaterialValuesForItem(stack.m_41720_());
    }

    public static Map<String, Integer> getMaterialValuesForItem(Item item) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        MaterialSettingsReloadListener.getAllMaterialEntries().stream().filter(entry -> ConfigHelper.matchesItemOrTag(item, entry.getItemOrTag())).forEach(entry -> result.put(entry.getMaterialId(), entry.getMaterialValue()));
        for (List e : (List)ServerConfig.MATERIAL_SETTING.get()) {
            List row = e;
            String key = (String)row.get(0);
            if (!ConfigHelper.matchesItemOrTag(item, key)) continue;
            String materialId = (String)row.get(1);
            int value = ((Number)row.get(2)).intValue();
            result.put(materialId, value);
        }
        return result;
    }

    private static boolean matchesItemOrTag(Item item, String key) {
        if (BuiltInRegistries.f_257033_.m_7981_((Object)item).toString().equals(key)) {
            return true;
        }
        if (key.startsWith("#")) {
            String tagId = key.substring(1);
            TagKey tag = TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)new ResourceLocation(tagId));
            return item.m_204114_().m_203656_(tag);
        }
        return false;
    }

    public static Set<String> getAllMaterialIds() {
        HashSet<String> materialIds = new HashSet<String>();
        MaterialSettingsReloadListener.getAllMaterialEntries().stream().map(MaterialSettingsReloadListener.MaterialEntry::getMaterialId).forEach(materialIds::add);
        Iterator iterator = ((List)ServerConfig.MATERIAL_SETTING.get()).iterator();
        while (iterator.hasNext()) {
            List e;
            List row = e = (List)iterator.next();
            materialIds.add((String)row.get(1));
        }
        return materialIds;
    }

    public static List<String> getItemsForMaterial(String materialId) {
        ArrayList<String> items = new ArrayList<String>();
        MaterialSettingsReloadListener.getEntriesForMaterial(materialId).stream().map(MaterialSettingsReloadListener.MaterialEntry::getItemOrTag).forEach(items::add);
        for (List e : (List)ServerConfig.MATERIAL_SETTING.get()) {
            List row = e;
            if (!row.get(1).equals(materialId)) continue;
            items.add((String)row.get(0));
        }
        return items;
    }
}

