/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.client;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.stirdrem.overgeared.client.OvergearedConfigScreen;

@OnlyIn(value=Dist.CLIENT)
public class BlacklistEditorScreen
extends Screen {
    private final String blacklistName;
    private final List<String> originalItems;
    private final Consumer<List<? extends String>> setter;
    private final double savedScrollPosition;
    private final Screen parentScreen;
    private BlacklistEditorList itemList;
    private EditBox addItemField;
    private Button addButton;
    private Button doneButton;
    private List<String> items;

    public BlacklistEditorScreen(String blacklistName, List<? extends String> currentItems, Consumer<List<? extends String>> setter, double savedScrollPosition, Screen parentScreen) {
        super((Component)Component.m_237113_((String)("Edit " + blacklistName)));
        this.blacklistName = blacklistName;
        this.originalItems = new ArrayList<String>();
        for (String string : currentItems) {
            this.originalItems.add(string);
        }
        this.setter = setter;
        this.savedScrollPosition = savedScrollPosition;
        this.parentScreen = parentScreen;
        this.items = new ArrayList<String>(this.originalItems);
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = this.f_96543_ / 2;
        int listWidth = this.f_96543_;
        int listHeight = this.f_96544_ - 100;
        this.itemList = new BlacklistEditorList(Minecraft.m_91087_(), listWidth, listHeight, 40, 40 + listHeight, 20);
        this.itemList.m_93507_((this.f_96543_ - listWidth) / 2);
        this.m_7787_((GuiEventListener)this.itemList);
        this.refreshItemList();
        this.addItemField = new EditBox(this.f_96547_, centerX - 120, this.f_96544_ - 50, 200, 20, (Component)Component.m_237113_((String)"Enter item ID or tag..."));
        this.addItemField.m_94199_(256);
        this.m_142416_((GuiEventListener)this.addItemField);
        this.addButton = Button.m_253074_((Component)Component.m_237113_((String)"Add"), btn -> {
            String newItem = this.addItemField.m_94155_().trim();
            if (!newItem.isEmpty() && !this.items.contains(newItem)) {
                this.items.add(newItem);
                this.addItemField.m_94144_("");
                this.refreshItemList();
            }
        }).m_252987_(centerX + 90, this.f_96544_ - 50, 50, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.addButton);
        this.doneButton = Button.m_253074_((Component)Component.m_237113_((String)"Done"), btn -> {
            this.setter.accept(this.items);
            if (this.parentScreen instanceof OvergearedConfigScreen) {
                OvergearedConfigScreen configScreen = (OvergearedConfigScreen)this.parentScreen;
                configScreen.setScrollPosition(this.savedScrollPosition);
                configScreen.restoreScrollPosition();
            }
            this.f_96541_.m_91152_(this.parentScreen);
        }).m_252987_(centerX - 105, this.f_96544_ - 25, 100, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.doneButton);
        Button cancelButton = Button.m_253074_((Component)Component.m_237113_((String)"Cancel"), btn -> {
            if (this.parentScreen instanceof OvergearedConfigScreen) {
                OvergearedConfigScreen configScreen = (OvergearedConfigScreen)this.parentScreen;
                configScreen.setScrollPosition(this.savedScrollPosition);
                configScreen.restoreScrollPosition();
            }
            this.f_96541_.m_91152_(this.parentScreen);
        }).m_252987_(centerX + 5, this.f_96544_ - 25, 100, 20).m_253136_();
        this.m_142416_((GuiEventListener)cancelButton);
    }

    private void refreshItemList() {
        this.itemList.m_6702_().clear();
        for (String item : this.items) {
            this.itemList.addNewEntry(new BlacklistItemEntry(item));
        }
    }

    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(gui);
        this.itemList.m_88315_(gui, mouseX, mouseY, partialTicks);
        super.m_88315_(gui, mouseX, mouseY, partialTicks);
        int centerX = this.f_96543_ / 2;
        gui.m_280137_(this.f_96547_, "Edit " + this.blacklistName, centerX, 15, 0xFFFFFF);
        gui.m_280137_(this.f_96547_, "Add item IDs or tags (prefix with # for tags)", centerX, 25, 0xAAAAAA);
        gui.m_280137_(this.f_96547_, "Current items: " + this.items.size(), centerX, this.f_96544_ - 70, 0xAAAAAA);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            Screen screen = this.parentScreen;
            if (screen instanceof OvergearedConfigScreen) {
                OvergearedConfigScreen configScreen = (OvergearedConfigScreen)screen;
                configScreen.setScrollPosition(this.savedScrollPosition);
                configScreen.restoreScrollPosition();
            }
            this.f_96541_.m_91152_(this.parentScreen);
            return true;
        }
        if (keyCode == 257 && this.addItemField.m_93696_()) {
            String newItem = this.addItemField.m_94155_().trim();
            if (!newItem.isEmpty() && !this.items.contains(newItem)) {
                this.items.add(newItem);
                this.addItemField.m_94144_("");
                this.refreshItemList();
            }
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private class BlacklistEditorList
    extends ObjectSelectionList<BlacklistItemEntry> {
        private final int entryPadding = 30;

        public BlacklistEditorList(Minecraft mc, int width, int height, int top, int bottom, int itemHeight) {
            super(mc, width, height, top, bottom, itemHeight);
            this.entryPadding = 30;
        }

        public int m_5759_() {
            return this.f_93388_ - 60;
        }

        public int m_5747_() {
            return this.f_93393_ + 30;
        }

        public int m_5756_() {
            return this.f_93392_ - 25;
        }

        public void addNewEntry(BlacklistItemEntry entry) {
            super.m_7085_((AbstractSelectionList.Entry)entry);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (super.m_6375_(mouseX, mouseY, button)) {
                return true;
            }
            this.m_6987_(null);
            return false;
        }
    }

    private class BlacklistItemEntry
    extends ObjectSelectionList.Entry<BlacklistItemEntry> {
        private final String item;
        private final Button removeButton;

        public BlacklistItemEntry(String item) {
            this.item = item;
            this.removeButton = Button.m_253074_((Component)Component.m_237113_((String)"Remove"), btn -> {
                BlacklistEditorScreen.this.items.remove(item);
                BlacklistEditorScreen.this.refreshItemList();
            }).m_252987_(0, 0, 60, 16).m_253136_();
        }

        public void m_6311_(GuiGraphics gui, int idx, int y, int x, int listWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float pt) {
            int color = this.item.startsWith("#") ? 0x55FF55 : 0xFFFFFF;
            gui.m_280488_(BlacklistEditorScreen.this.f_96547_, this.item, x + 5, y + 2, color);
            this.removeButton.m_252865_(x + listWidth - 90);
            this.removeButton.m_253211_(y);
            this.removeButton.m_88315_(gui, mouseX, mouseY, pt);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.removeButton.m_5953_(mouseX, mouseY)) {
                return this.removeButton.m_6375_(mouseX, mouseY, button);
            }
            return false;
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            return this.removeButton.m_6348_(mouseX, mouseY, button);
        }

        public Component m_142172_() {
            return Component.m_237113_((String)this.item);
        }
    }
}

