/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.datagen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class CustomCookingRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory category;
    private final CookingBookCategory bookCategory;
    private final Item resultItem;
    private final Ingredient ingredient;
    private final float experience;
    private final int cookingTime;
    private final Advancement.Builder advancement = Advancement.Builder.m_285878_();
    @Nullable
    private String group;
    private final RecipeSerializer<? extends AbstractCookingRecipe> serializer;
    @Nullable
    private CompoundTag resultNbt;

    CustomCookingRecipeBuilder(RecipeCategory category, CookingBookCategory bookCategory, @Nullable CompoundTag resultNbt, ItemLike result, Ingredient ingredient, float experience, int cookingTime, RecipeSerializer<? extends AbstractCookingRecipe> serializer) {
        this.category = category;
        this.bookCategory = bookCategory;
        this.resultNbt = resultNbt;
        this.resultItem = result.m_5456_();
        this.ingredient = ingredient;
        this.experience = experience;
        this.cookingTime = cookingTime;
        this.serializer = serializer;
    }

    public static CustomCookingRecipeBuilder generic(Ingredient pIngredient, RecipeCategory pCategory, @Nullable CompoundTag resultNbt, ItemLike pResult, float pExperience, int pCookingTime, RecipeSerializer<? extends AbstractCookingRecipe> pSerializer) {
        return new CustomCookingRecipeBuilder(pCategory, CustomCookingRecipeBuilder.determineRecipeCategory(pSerializer, pResult), resultNbt, pResult, pIngredient, pExperience, pCookingTime, pSerializer);
    }

    public static CustomCookingRecipeBuilder smelting(Ingredient pIngredient, RecipeCategory pCategory, @Nullable CompoundTag resultNbt, ItemLike pResult, float pExperience, int pCookingTime) {
        return new CustomCookingRecipeBuilder(pCategory, CustomCookingRecipeBuilder.determineBlastingRecipeCategory(pResult), resultNbt, pResult, pIngredient, pExperience, pCookingTime, (RecipeSerializer<? extends AbstractCookingRecipe>)RecipeSerializer.f_44091_);
    }

    public static CustomCookingRecipeBuilder blasting(Ingredient pIngredient, RecipeCategory pCategory, @Nullable CompoundTag resultNbt, ItemLike pResult, float pExperience, int pCookingTime) {
        return new CustomCookingRecipeBuilder(pCategory, CustomCookingRecipeBuilder.determineBlastingRecipeCategory(pResult), resultNbt, pResult, pIngredient, pExperience, pCookingTime, (RecipeSerializer<? extends AbstractCookingRecipe>)RecipeSerializer.f_44092_);
    }

    public CustomCookingRecipeBuilder group(@Nullable String groupName) {
        this.group = groupName;
        return this;
    }

    public CustomCookingRecipeBuilder unlockedBy(String criterionName, CriterionTriggerInstance criterionTrigger) {
        this.advancement.m_138386_(criterionName, criterionTrigger);
        return this;
    }

    public CustomCookingRecipeBuilder withResultNbt(String nbtJson) {
        try {
            this.resultNbt = TagParser.m_129359_((String)nbtJson);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid NBT json: " + nbtJson, e);
        }
        return this;
    }

    public Item m_142372_() {
        return this.resultItem;
    }

    private static CookingBookCategory determineBlastingRecipeCategory(ItemLike pResult) {
        return pResult.m_5456_() instanceof BlockItem ? CookingBookCategory.BLOCKS : CookingBookCategory.MISC;
    }

    private static CookingBookCategory determineRecipeCategory(RecipeSerializer<? extends AbstractCookingRecipe> pSerializer, ItemLike pResult) {
        if (pSerializer == RecipeSerializer.f_44091_) {
            return CustomCookingRecipeBuilder.determineSmeltingRecipeCategory(pResult);
        }
        if (pSerializer == RecipeSerializer.f_44092_) {
            return CustomCookingRecipeBuilder.determineBlastingRecipeCategory(pResult);
        }
        if (pSerializer != RecipeSerializer.f_44093_ && pSerializer != RecipeSerializer.f_44094_) {
            throw new IllegalStateException("Unknown cooking recipe type");
        }
        return CookingBookCategory.FOOD;
    }

    public void m_126140_(Consumer<FinishedRecipe> consumer, ResourceLocation recipeId) {
        this.ensureValid(recipeId);
        this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)recipeId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)recipeId)).m_138360_(RequirementsStrategy.f_15979_);
        consumer.accept(new Result(recipeId, this.group == null ? "" : this.group, this.bookCategory, this.ingredient, this.resultItem, this.experience, this.cookingTime, this.advancement, recipeId.m_246208_("recipes/" + this.category.m_247710_() + "/"), this.serializer, this.resultNbt));
    }

    private void ensureValid(ResourceLocation id) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
    }

    private static CookingBookCategory determineSmeltingRecipeCategory(ItemLike result) {
        if (result.m_5456_().m_41472_()) {
            return CookingBookCategory.FOOD;
        }
        return result.m_5456_() instanceof BlockItem ? CookingBookCategory.BLOCKS : CookingBookCategory.MISC;
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final String group;
        private final CookingBookCategory category;
        private final Ingredient ingredient;
        private final Item result;
        private final float experience;
        private final int cookingTime;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;
        private final RecipeSerializer<? extends AbstractCookingRecipe> serializer;
        @Nullable
        private final CompoundTag resultNbt;

        public Result(ResourceLocation id, String group, CookingBookCategory category, Ingredient ingredient, Item result, float experience, int cookingTime, Advancement.Builder advancement, ResourceLocation advancementId, RecipeSerializer<? extends AbstractCookingRecipe> serializer, @Nullable CompoundTag resultNbt) {
            this.id = id;
            this.group = group;
            this.category = category;
            this.ingredient = ingredient;
            this.result = result;
            this.experience = experience;
            this.cookingTime = cookingTime;
            this.advancement = advancement;
            this.advancementId = advancementId;
            this.serializer = serializer;
            this.resultNbt = resultNbt;
        }

        public void m_7917_(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            json.addProperty("category", this.category.m_7912_());
            json.add("ingredient", this.ingredient.m_43942_());
            json.addProperty("experience", (Number)Float.valueOf(this.experience));
            json.addProperty("cookingtime", (Number)this.cookingTime);
            JsonObject resultObject = new JsonObject();
            resultObject.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)this.result).toString());
            if (this.resultNbt != null && !this.resultNbt.m_128456_()) {
                JsonObject nbtJson = new JsonObject();
                for (String key : this.resultNbt.m_128431_()) {
                    Tag tag = this.resultNbt.m_128423_(key);
                    if (tag instanceof IntTag) {
                        nbtJson.addProperty(key, (Number)((IntTag)tag).m_7047_());
                        continue;
                    }
                    if (!(tag instanceof StringTag)) continue;
                    nbtJson.addProperty(key, tag.m_7916_());
                }
                resultObject.add("nbt", (JsonElement)nbtJson);
            }
            json.add("result", (JsonElement)resultObject);
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

