/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.block.entity;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.stirdrem.overgeared.block.entity.ModBlockEntities;
import net.stirdrem.overgeared.recipe.NetherAlloySmeltingRecipe;
import net.stirdrem.overgeared.screen.NetherAlloySmelterMenu;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NetherAlloySmelterBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    private static final int INPUT_SLOTS = 9;
    private static final int FUEL_SLOT = 9;
    private static final int OUTPUT_SLOT = 10;
    private final ItemStackHandler itemHandler = new ItemStackHandler(11){

        protected void onContentsChanged(int slot) {
            NetherAlloySmelterBlockEntity.this.m_6596_();
        }
    };
    private final ContainerData data;
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private final LazyOptional<? extends IItemHandler>[] sidedHandlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    private int burnTime;
    private int maxBurnTime;
    private int cookTime;
    private int cookTimeTotal;
    private float storedExperience = 0.0f;

    public NetherAlloySmelterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.NETHER_ALLOY_FURNACE_BE.get(), pos, state);
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> NetherAlloySmelterBlockEntity.this.burnTime;
                    case 1 -> NetherAlloySmelterBlockEntity.this.maxBurnTime;
                    case 2 -> NetherAlloySmelterBlockEntity.this.cookTime;
                    case 3 -> NetherAlloySmelterBlockEntity.this.cookTimeTotal;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        NetherAlloySmelterBlockEntity.this.burnTime = value;
                        break;
                    }
                    case 1: {
                        NetherAlloySmelterBlockEntity.this.maxBurnTime = value;
                        break;
                    }
                    case 2: {
                        NetherAlloySmelterBlockEntity.this.cookTime = value;
                        break;
                    }
                    case 3: {
                        NetherAlloySmelterBlockEntity.this.cookTimeTotal = value;
                    }
                }
            }

            public int m_6499_() {
                return 4;
            }
        };
    }

    public static void tick(Level level, BlockPos pos, BlockState state, NetherAlloySmelterBlockEntity be) {
        boolean wasLit = be.burnTime > 0;
        boolean dirty = false;
        if (be.burnTime > 0) {
            --be.burnTime;
        }
        ItemStack fuel = be.itemHandler.getStackInSlot(9);
        if (be.burnTime == 0 && be.canSmelt()) {
            be.maxBurnTime = be.burnTime = ForgeHooks.getBurnTime((ItemStack)fuel, (RecipeType)RecipeType.f_44108_);
            if (be.burnTime > 0 && !fuel.m_41619_()) {
                Item fuelContainer = fuel.m_41720_().m_41469_();
                fuel.m_41774_(1);
                if (fuel.m_41619_() && fuelContainer != null) {
                    be.itemHandler.setStackInSlot(9, new ItemStack((ItemLike)fuelContainer));
                }
                dirty = true;
            }
        }
        if (be.isLit() && be.canSmelt()) {
            ++be.cookTime;
            if (be.cookTime >= be.cookTimeTotal) {
                be.cookTime = 0;
                be.smelt();
                dirty = true;
            }
        } else if (!be.canSmelt()) {
            be.cookTime = 0;
        }
        if (wasLit != be.isLit()) {
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(be.isLit()));
            level.m_7731_(pos, state, 3);
            dirty = true;
        }
        if (dirty) {
            be.m_6596_();
        }
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        for (LazyOptional<? extends IItemHandler> handler : this.sidedHandlers) {
            handler.invalidate();
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            if (side == Direction.UP) {
                return this.sidedHandlers[0].cast();
            }
            if (side == Direction.DOWN) {
                return this.sidedHandlers[1].cast();
            }
            return this.sidedHandlers[2].cast();
        }
        return super.getCapability(cap, side);
    }

    private boolean canSmelt() {
        SimpleContainer inv = new SimpleContainer(9);
        for (int i = 0; i < 9; ++i) {
            inv.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Optional recipe = this.f_58857_.m_7465_().m_44015_((RecipeType)NetherAlloySmeltingRecipe.Type.INSTANCE, (Container)inv, this.f_58857_);
        if (recipe.isEmpty()) {
            return false;
        }
        this.cookTimeTotal = ((NetherAlloySmeltingRecipe)recipe.get()).getCookingTime();
        ItemStack result = ((NetherAlloySmeltingRecipe)recipe.get()).m_8043_(this.f_58857_.m_9598_());
        ItemStack output = this.itemHandler.getStackInSlot(10);
        return !result.m_41619_() && (output.m_41619_() || output.m_150930_(result.m_41720_()) && output.m_41613_() + result.m_41613_() <= output.m_41741_());
    }

    private void smelt() {
        if (!this.canSmelt()) {
            return;
        }
        SimpleContainer inv = new SimpleContainer(9);
        for (int i = 0; i < 9; ++i) {
            inv.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Optional recipe = this.f_58857_.m_7465_().m_44015_((RecipeType)NetherAlloySmeltingRecipe.Type.INSTANCE, (Container)inv, this.f_58857_);
        if (recipe.isPresent()) {
            NetherAlloySmeltingRecipe alloyRecipe = (NetherAlloySmeltingRecipe)recipe.get();
            ItemStack result = alloyRecipe.m_8043_(this.f_58857_.m_9598_());
            ItemStack output = this.itemHandler.getStackInSlot(10);
            if (output.m_41619_()) {
                this.itemHandler.setStackInSlot(10, result.m_41777_());
            } else if (output.m_150930_(result.m_41720_())) {
                output.m_41769_(result.m_41613_());
            }
            for (int i = 0; i < 9; ++i) {
                ItemStack input = this.itemHandler.getStackInSlot(i);
                if (input.m_41619_()) continue;
                input.m_41774_(1);
            }
            if (!this.f_58857_.f_46443_ && alloyRecipe.getExperience() > 0.0f) {
                this.storedExperience += alloyRecipe.getExperience();
            }
        }
    }

    private void spawnExperience(float xp) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        int i = Mth.m_14143_((float)xp);
        float f = xp - (float)i;
        if (f > 0.0f && Math.random() < (double)f) {
            ++i;
        }
        while (i > 0) {
            int split = ExperienceOrb.m_20782_((int)i);
            i -= split;
            this.f_58857_.m_7967_((Entity)new ExperienceOrb(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.0, (double)this.f_58858_.m_123343_() + 0.5, split));
        }
    }

    private boolean isLit() {
        return this.burnTime > 0;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.overgeared.nether_alloy_smelter");
    }

    protected Component m_6820_() {
        return null;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInv, Player player) {
        return new NetherAlloySmelterMenu(id, playerInv, (BlockEntity)this, this.data);
    }

    protected AbstractContainerMenu m_6555_(int pContainerId, Inventory pInventory) {
        return null;
    }

    public void awardStoredExperience(Player player) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (this.storedExperience > 0.0f && player != null) {
            int total = (int)this.storedExperience;
            float fractional = this.storedExperience - (float)total;
            if (fractional > 0.0f && Math.random() < (double)fractional) {
                ++total;
            }
            player.m_6756_(total);
            this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11871_, SoundSource.PLAYERS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
            this.storedExperience = 0.0f;
            this.m_6596_();
        }
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("burnTime", this.burnTime);
        tag.m_128405_("maxBurnTime", this.maxBurnTime);
        tag.m_128405_("cookTime", this.cookTime);
        tag.m_128405_("cookTimeTotal", this.cookTimeTotal);
        tag.m_128350_("storedXp", this.storedExperience);
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        this.burnTime = tag.m_128451_("burnTime");
        this.maxBurnTime = tag.m_128451_("maxBurnTime");
        this.cookTime = tag.m_128451_("cookTime");
        this.cookTimeTotal = tag.m_128451_("cookTimeTotal");
        this.storedExperience = tag.m_128457_("storedXp");
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public int[] m_7071_(Direction side) {
        if (side == Direction.UP) {
            int[] inputSlots = new int[9];
            for (int i = 0; i < 9; ++i) {
                inputSlots[i] = i;
            }
            return inputSlots;
        }
        if (side == Direction.DOWN) {
            return new int[]{10};
        }
        return new int[]{9};
    }

    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction direction) {
        if (index == 10) {
            return false;
        }
        if (index == 9) {
            return ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_) > 0;
        }
        return true;
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return index == 10;
    }

    public int m_6643_() {
        return this.itemHandler.getSlots();
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        ItemStack stack = this.itemHandler.getStackInSlot(slot);
        if (!stack.m_41619_()) {
            ItemStack result = stack.m_41620_(amount);
            this.m_6596_();
            return result;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack m_8016_(int slot) {
        ItemStack stack = this.itemHandler.getStackInSlot(slot);
        this.itemHandler.setStackInSlot(slot, ItemStack.f_41583_);
        return stack;
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.itemHandler.setStackInSlot(slot, stack);
        this.m_6596_();
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public int getInputSlotsCount() {
        return 9;
    }

    public int getFuelSlot() {
        return 9;
    }

    public int getOutputSlot() {
        return 10;
    }
}

