/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.compat;

import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.stirdrem.overgeared.block.ModBlocks;
import net.stirdrem.overgeared.recipe.AlloySmeltingRecipe;

public class AlloySmeltingRecipeCategory
implements IRecipeCategory<AlloySmeltingRecipe> {
    public static final ResourceLocation UID = ResourceLocation.m_214293_((String)"overgeared", (String)"alloy_smelting");
    public static final ResourceLocation TEXTURE = ResourceLocation.m_214293_((String)"overgeared", (String)"textures/gui/furnace_jei.png");
    public static final RecipeType<AlloySmeltingRecipe> ALLOY_SMELTING_TYPE = new RecipeType(UID, AlloySmeltingRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final int animationTime = 200;
    private final IDrawableAnimated arrowAnimated;
    private final IDrawableStatic arrowStatic;
    private final IDrawableAnimated flameAnimated;
    private final IDrawableStatic flameStatic;

    public AlloySmeltingRecipeCategory(IGuiHelper helper) {
        this.background = helper.drawableBuilder(TEXTURE, 0, 0, 107, 43).setTextureSize(130, 43).build();
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.ALLOY_FURNACE.get()));
        this.arrowStatic = helper.drawableBuilder(TEXTURE, 107, 14, 22, 16).setTextureSize(130, 43).build();
        this.arrowAnimated = helper.createAnimatedDrawable(this.arrowStatic, 200, IDrawableAnimated.StartDirection.LEFT, false);
        this.flameStatic = helper.drawableBuilder(TEXTURE, 107, 0, 14, 13).setTextureSize(130, 43).build();
        this.flameAnimated = helper.createAnimatedDrawable(this.flameStatic, 100, IDrawableAnimated.StartDirection.TOP, true);
    }

    public RecipeType<AlloySmeltingRecipe> getRecipeType() {
        return ALLOY_SMELTING_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"gui.overgeared.jei.category.alloy_smelting");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(AlloySmeltingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Float exp = Float.valueOf(recipe.getExperience());
        this.arrowAnimated.draw(guiGraphics, 47, 9);
        this.flameAnimated.draw(guiGraphics, 51, 29);
        Object expText = exp.floatValue() == (float)exp.intValue() ? exp.intValue() + " XP" : String.format("%.1f XP", exp);
        int textWidth = Minecraft.m_91087_().f_91062_.m_92895_((String)expText);
        int xPos = this.background.getWidth() - textWidth;
        guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, (String)expText, xPos, 35, -1, true);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AlloySmeltingRecipe recipe, IFocusGroup focuses) {
        List<Ingredient> ingredients = recipe.getIngredientsList();
        int inputCount = ingredients.size();
        if (inputCount >= 1) {
            builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredients(ingredients.get(0));
        }
        if (inputCount >= 2) {
            builder.addSlot(RecipeIngredientRole.INPUT, 1, 19).addIngredients(ingredients.get(1));
        }
        if (inputCount >= 3) {
            builder.addSlot(RecipeIngredientRole.INPUT, 19, 1).addIngredients(ingredients.get(2));
        }
        if (inputCount >= 4) {
            builder.addSlot(RecipeIngredientRole.INPUT, 19, 19).addIngredients(ingredients.get(3));
        }
        if (inputCount > 4) {
            for (int i = 4; i < inputCount && i < 8; ++i) {
                int row = (i - 4) / 2;
                int col = (i - 4) % 2;
                builder.addSlot(RecipeIngredientRole.INPUT, 37 + col * 18, 1 + row * 18).addIngredients(ingredients.get(i));
            }
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 86, 10).addItemStack(recipe.m_8043_(null));
    }
}

