/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.compat;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.stirdrem.overgeared.AnvilTier;
import net.stirdrem.overgeared.block.ModBlocks;
import net.stirdrem.overgeared.item.ModItems;
import net.stirdrem.overgeared.recipe.ForgingRecipe;

public class ForgingRecipeCategory
implements IRecipeCategory<ForgingRecipe> {
    public static final ResourceLocation UID = ResourceLocation.m_214293_((String)"overgeared", (String)"forging");
    public static final ResourceLocation TEXTURE = ResourceLocation.m_214293_((String)"overgeared", (String)"textures/gui/smithing_anvil_jei.png");
    public static final ResourceLocation RESULT_BIG = ResourceLocation.m_214293_((String)"overgeared", (String)"textures/gui/result_big.png");
    public static final ResourceLocation RESULT_TWOSLOT = ResourceLocation.m_214293_((String)"overgeared", (String)"textures/gui/twoslot.png");
    public static final RecipeType<ForgingRecipe> FORGING_RECIPE_TYPE = new RecipeType(UID, ForgingRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private static final int imageWidth = 138;
    private static final int imageHeight = 54;
    private final int animationTime = 200;
    private final IDrawableStatic arrowStatic;
    private final IDrawableAnimated arrowAnimated;

    public ForgingRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 7, 16, 138, 54);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.SMITHING_ANVIL.get()));
        this.arrowStatic = helper.createDrawable(TEXTURE, 176, 0, 24, 17);
        this.arrowAnimated = helper.createAnimatedDrawable(this.arrowStatic, 200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public RecipeType<ForgingRecipe> getRecipeType() {
        return FORGING_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"gui.overgeared.smithing_anvil");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void draw(ForgingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        String hitsText = Component.m_237110_((String)"tooltip.overgeared.recipe.hits", (Object[])new Object[]{recipe.getRemainingHits()}).getString();
        String tierRaw = recipe.getAnvilTier();
        AnvilTier tierName = AnvilTier.fromDisplayName(tierRaw);
        MutableComponent tierText = Component.m_237115_((String)"tooltip.overgeared.recipe.tier").m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)Component.m_237115_((String)tierName.getLang()));
        if (recipe.hasQuality() || !recipe.needsMinigame()) {
            guiGraphics.m_280163_(RESULT_BIG, 112, 14, 0.0f, 0.0f, 26, 26, 26, 26);
        } else {
            guiGraphics.m_280163_(RESULT_TWOSLOT, 116, 9, 0.0f, 0.0f, 18, 36, 18, 36);
        }
        guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, hitsText, 79, 1, -8355712, false);
        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)tierText, 79, 47, -8355712, false);
        this.arrowAnimated.draw(guiGraphics, 82, 19);
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ForgingRecipe recipe, IFocusGroup focuses) {
        int gridWidth = 3;
        int gridHeight = 3;
        int recipeWidth = recipe.width;
        int recipeHeight = recipe.height;
        NonNullList<Ingredient> ingredients = recipe.m_7527_();
        Set<String> type = recipe.getBlueprintTypes();
        for (int gridY = 0; gridY < gridHeight; ++gridY) {
            for (int gridX = 0; gridX < gridWidth; ++gridX) {
                int recipeIndex = gridY * recipeWidth + gridX;
                if (gridX < recipeWidth && gridY < recipeHeight && recipeIndex < ingredients.size()) {
                    Ingredient ingredient = (Ingredient)ingredients.get(recipeIndex);
                    builder.addSlot(RecipeIngredientRole.INPUT, 23 + gridX * 18, 1 + gridY * 18).addIngredients(ingredient);
                    continue;
                }
                builder.addSlot(RecipeIngredientRole.INPUT, 23 + gridX * 18, 1 + gridY * 18).addIngredients(Ingredient.f_43901_);
            }
        }
        builder.addSlot(RecipeIngredientRole.CATALYST, 1, 19).addItemStacks(this.createBlueprintStacksForRecipe(recipe));
        if (recipe.hasQuality() || !recipe.needsMinigame()) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 117, 19).addItemStack(recipe.m_8043_(null));
        } else {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 117, 10).addItemStack(recipe.m_8043_(null));
            ItemStack failedStack = recipe.getFailedResultItem(null).m_41777_();
            CompoundTag failedTag = failedStack.m_41784_();
            failedTag.m_128379_("failedResult", true);
            failedStack.m_41751_(failedTag);
            builder.addSlot(RecipeIngredientRole.OUTPUT, 117, 28).addItemStack(failedStack);
        }
    }

    private List<ItemStack> createBlueprintStacksForRecipe(ForgingRecipe recipe) {
        Set<String> types = recipe.getBlueprintTypes();
        boolean required = recipe.requiresBlueprint();
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (String type : types) {
            ItemStack stack = new ItemStack((ItemLike)ModItems.BLUEPRINT.get());
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("ToolType", type);
            tag.m_128379_("Required", required);
            stack.m_41751_(tag);
            stacks.add(stack);
        }
        return stacks;
    }
}

