/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.compat;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.stirdrem.overgeared.AnvilTier;
import net.stirdrem.overgeared.block.ModBlocks;
import net.stirdrem.overgeared.compat.AlloySmeltingRecipeCategory;
import net.stirdrem.overgeared.compat.BlueprintCloningRecipeMaker;
import net.stirdrem.overgeared.compat.ClayToolCastRecipeMaker;
import net.stirdrem.overgeared.compat.FletchingCategory;
import net.stirdrem.overgeared.compat.FlintKnappingCategory;
import net.stirdrem.overgeared.compat.ForgingRecipeCategory;
import net.stirdrem.overgeared.compat.KnappingRecipeCategory;
import net.stirdrem.overgeared.compat.NetherAlloySmeltingRecipeCategory;
import net.stirdrem.overgeared.compat.NetherToolCastRecipeMaker;
import net.stirdrem.overgeared.compat.OvergearedAnvilRecipes;
import net.stirdrem.overgeared.compat.SteelAnvilCategory;
import net.stirdrem.overgeared.compat.StoneAnvilCategory;
import net.stirdrem.overgeared.config.ServerConfig;
import net.stirdrem.overgeared.item.ModItems;
import net.stirdrem.overgeared.recipe.AlloySmeltingRecipe;
import net.stirdrem.overgeared.recipe.ExplanationRecipe;
import net.stirdrem.overgeared.recipe.FletchingRecipe;
import net.stirdrem.overgeared.recipe.ForgingRecipe;
import net.stirdrem.overgeared.recipe.JeiBetterBrewingRecipe;
import net.stirdrem.overgeared.recipe.NetherAlloySmeltingRecipe;
import net.stirdrem.overgeared.recipe.RockKnappingRecipe;
import net.stirdrem.overgeared.screen.AlloySmelterScreen;
import net.stirdrem.overgeared.screen.FletchingStationMenu;
import net.stirdrem.overgeared.screen.FletchingStationScreen;
import net.stirdrem.overgeared.screen.ModMenuTypes;
import net.stirdrem.overgeared.screen.NetherAlloySmelterScreen;
import net.stirdrem.overgeared.screen.RockKnappingScreen;
import net.stirdrem.overgeared.screen.SteelSmithingAnvilMenu;
import net.stirdrem.overgeared.screen.SteelSmithingAnvilScreen;
import net.stirdrem.overgeared.screen.StoneSmithingAnvilMenu;
import net.stirdrem.overgeared.screen.StoneSmithingAnvilScreen;
import net.stirdrem.overgeared.screen.TierASmithingAnvilMenu;
import net.stirdrem.overgeared.screen.TierASmithingAnvilScreen;
import net.stirdrem.overgeared.screen.TierBSmithingAnvilMenu;
import net.stirdrem.overgeared.screen.TierBSmithingAnvilScreen;
import net.stirdrem.overgeared.util.ModTags;

@JeiPlugin
public class JEIOvergearedModPlugin
implements IModPlugin {
    Map<String, Integer> categoryPriority = Map.of("tool_head", 0, "tools", 1, "armor", 2, "plate", 3, "misc", 4);

    public static ItemStack setLingeringPotion(ItemStack pStack, Potion pPotion) {
        ResourceLocation resourcelocation = BuiltInRegistries.f_256980_.m_7981_((Object)pPotion);
        if (pPotion == Potions.f_43598_) {
            pStack.m_41749_("LingeringPotion");
        } else {
            pStack.m_41784_().m_128359_("LingeringPotion", resourcelocation.toString());
        }
        return pStack;
    }

    private static String categorizeRecipe(ForgingRecipe recipe) {
        ItemStack output = recipe.m_8043_(null);
        if (output.m_204117_(Tags.Items.ARMORS)) {
            return "armor";
        }
        if (output.m_204117_(ModTags.Items.TOOL_PARTS)) {
            return "tool_head";
        }
        if (output.m_204117_(Tags.Items.TOOLS)) {
            return "tools";
        }
        if (output.m_150930_((Item)ModItems.IRON_PLATE.get()) || output.m_150930_((Item)ModItems.STEEL_PLATE.get()) || output.m_150930_((Item)ModItems.COPPER_PLATE.get())) {
            return "plate";
        }
        return "misc";
    }

    public ResourceLocation getPluginUid() {
        return ResourceLocation.m_214293_((String)"overgeared", (String)"jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new ForgingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new KnappingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new FlintKnappingCategory(registration.getJeiHelpers().getGuiHelper())});
        RegistryAccess registryAccess = Minecraft.m_91087_().m_91403_().m_105152_();
        registration.addRecipeCategories(new IRecipeCategory[]{new StoneAnvilCategory(registration.getJeiHelpers().getGuiHelper(), registryAccess)});
        registration.addRecipeCategories(new IRecipeCategory[]{new SteelAnvilCategory(registration.getJeiHelpers().getGuiHelper(), registryAccess)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FletchingCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new AlloySmeltingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new NetherAlloySmeltingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        RecipeManager recipeManager = Minecraft.m_91087_().f_91073_.m_7465_();
        List allForgingRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ForgingRecipe.Type.INSTANCE);
        List<ForgingRecipe> stoneTierRecipes = allForgingRecipes.stream().filter(recipe -> recipe.getAnvilTier().equalsIgnoreCase(AnvilTier.STONE.getDisplayName())).toList();
        List<ForgingRecipe> steelTierRecipes = allForgingRecipes.stream().filter(recipe -> recipe.getAnvilTier().equalsIgnoreCase(AnvilTier.IRON.getDisplayName())).toList();
        List<ForgingRecipe> ATierRecipes = allForgingRecipes.stream().filter(recipe -> recipe.getAnvilTier().equalsIgnoreCase(AnvilTier.ABOVE_A.getDisplayName())).toList();
        List<ForgingRecipe> BTierRecipes = allForgingRecipes.stream().filter(recipe -> recipe.getAnvilTier().equalsIgnoreCase(AnvilTier.ABOVE_B.getDisplayName())).toList();
        ArrayList<ForgingRecipe> combinedSteelCategory = new ArrayList<ForgingRecipe>();
        combinedSteelCategory.addAll(stoneTierRecipes);
        combinedSteelCategory.addAll(steelTierRecipes);
        combinedSteelCategory.addAll(ATierRecipes);
        combinedSteelCategory.addAll(BTierRecipes);
        combinedSteelCategory.sort((a, b) -> {
            int priorityB;
            String catA = JEIOvergearedModPlugin.categorizeRecipe(a);
            String catB = JEIOvergearedModPlugin.categorizeRecipe(b);
            int priorityA = this.categoryPriority.getOrDefault(catA, 999);
            if (priorityA != (priorityB = this.categoryPriority.getOrDefault(catB, 999).intValue())) {
                return Integer.compare(priorityA, priorityB);
            }
            return a.m_8043_(null).m_41611_().getString().compareToIgnoreCase(b.m_8043_(null).m_41611_().getString());
        });
        registration.addRecipes(ForgingRecipeCategory.FORGING_RECIPE_TYPE, combinedSteelCategory);
        List knappingRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)RockKnappingRecipe.Type.INSTANCE);
        registration.addRecipes(KnappingRecipeCategory.KNAPPING_RECIPE_TYPE, knappingRecipes);
        List alloyingRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)AlloySmeltingRecipe.Type.INSTANCE);
        registration.addRecipes(AlloySmeltingRecipeCategory.ALLOY_SMELTING_TYPE, alloyingRecipes);
        List netherAlloySmeltingRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)NetherAlloySmeltingRecipe.Type.INSTANCE);
        registration.addRecipes(NetherAlloySmeltingRecipeCategory.ALLOY_SMELTING_TYPE, netherAlloySmeltingRecipes);
        if (((Boolean)ServerConfig.ENABLE_CASTING.get()).booleanValue()) {
            registration.addRecipes(RecipeTypes.CRAFTING, ClayToolCastRecipeMaker.createRecipes());
            registration.addRecipes(RecipeTypes.CRAFTING, NetherToolCastRecipeMaker.createRecipes());
        }
        registration.addRecipes(RecipeTypes.CRAFTING, BlueprintCloningRecipeMaker.createRecipes());
        if (((Boolean)ServerConfig.ENABLE_DRAGON_BREATH_RECIPE.get()).booleanValue()) {
            registration.addRecipes(RecipeTypes.BREWING, this.dragonBreathRecipe());
        }
        List<ExplanationRecipe> recipes = List.of(new ExplanationRecipe(new ItemStack((ItemLike)ModItems.ROCK.get())));
        registration.addRecipes(FlintKnappingCategory.FLINT_KNAPPING, recipes);
        List<ExplanationRecipe> StoneAnvilRecipes = List.of(new ExplanationRecipe(new ItemStack((ItemLike)ModBlocks.STONE_SMITHING_ANVIL.get())));
        List<ExplanationRecipe> SteelAnvilRecipes = List.of(new ExplanationRecipe(new ItemStack((ItemLike)ModBlocks.SMITHING_ANVIL.get())));
        registration.addRecipes(StoneAnvilCategory.STONE_ANVIL_GET, StoneAnvilRecipes);
        registration.addRecipes(SteelAnvilCategory.STEEL_ANVIL_GET, SteelAnvilRecipes);
        registration.addRecipes(RecipeTypes.ANVIL, OvergearedAnvilRecipes.getOvergearedAnvilRecipes(registration.getVanillaRecipeFactory(), registration.getIngredientManager()).toList());
        if (((Boolean)ServerConfig.ENABLE_FLETCHING_RECIPES.get()).booleanValue()) {
            List fletchingRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)FletchingRecipe.Type.INSTANCE);
            registration.addRecipes(FletchingCategory.FLETCHING_RECIPE_TYPE, fletchingRecipes);
            List<FletchingRecipe> dynamicConversions = this.generatePotionConversions();
            if (((Boolean)ServerConfig.UPGRADE_ARROW_POTION_TOGGLE.get()).booleanValue()) {
                registration.addRecipes(FletchingCategory.FLETCHING_RECIPE_TYPE, dynamicConversions);
            }
        }
    }

    private List<IJeiBrewingRecipe> dragonBreathRecipe() {
        ArrayList<IJeiBrewingRecipe> recipes = new ArrayList<IJeiBrewingRecipe>();
        ItemStack thickPotion = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43601_);
        ItemStack chorusFruit = new ItemStack((ItemLike)Items.f_42730_);
        ItemStack dragonBreath = new ItemStack((ItemLike)Items.f_42735_);
        ResourceLocation recipeId = ResourceLocation.m_214293_((String)"overgeared", (String)"dragon_breath_brewing");
        recipes.add(new JeiBetterBrewingRecipe(List.of(thickPotion), List.of(chorusFruit), dragonBreath, recipeId));
        return recipes;
    }

    private List<FletchingRecipe> generatePotionConversions() {
        ItemStack output;
        ItemStack potionStack;
        ArrayList<FletchingRecipe> list = new ArrayList<FletchingRecipe>();
        ItemStack[] arrowTypes = (Boolean)ServerConfig.UPGRADE_ARROW_POTION_TOGGLE.get() != false ? new ItemStack[]{new ItemStack((ItemLike)Items.f_42412_), new ItemStack((ItemLike)ModItems.IRON_UPGRADE_ARROW.get()), new ItemStack((ItemLike)ModItems.STEEL_UPGRADE_ARROW.get()), new ItemStack((ItemLike)ModItems.DIAMOND_UPGRADE_ARROW.get())} : new ItemStack[]{new ItemStack((ItemLike)Items.f_42412_)};
        int idCounter = 0;
        for (ItemStack arrow : arrowTypes) {
            for (Potion potion : ForgeRegistries.POTIONS) {
                if (potion == Potions.f_43598_) continue;
                potionStack = new ItemStack((ItemLike)Items.f_42589_);
                PotionUtils.m_43549_((ItemStack)potionStack, (Potion)potion);
                output = arrow.m_150930_(Items.f_42412_) ? new ItemStack((ItemLike)Items.f_42738_) : arrow.m_41777_();
                PotionUtils.m_43549_((ItemStack)output, (Potion)potion);
                list.add(new FletchingRecipe(ResourceLocation.m_214293_((String)"overgeared", (String)("lingering_conv_" + idCounter++)), Ingredient.f_43901_, Ingredient.m_43927_((ItemStack[])new ItemStack[]{arrow}), Ingredient.f_43901_, Ingredient.m_43927_((ItemStack[])new ItemStack[]{potionStack}), output, ItemStack.f_41583_, ItemStack.f_41583_, "Potion", "LingeringPotion"));
            }
        }
        for (ItemStack arrow : arrowTypes) {
            for (Potion potion : ForgeRegistries.POTIONS) {
                if (potion == Potions.f_43598_) continue;
                potionStack = new ItemStack((ItemLike)Items.f_42739_);
                PotionUtils.m_43549_((ItemStack)potionStack, (Potion)potion);
                if (arrow.m_150930_(Items.f_42412_)) {
                    output = new ItemStack((ItemLike)ModItems.LINGERING_ARROW.get());
                    PotionUtils.m_43549_((ItemStack)output, (Potion)potion);
                } else {
                    output = arrow.m_41777_();
                    JEIOvergearedModPlugin.setLingeringPotion(output, potion);
                }
                list.add(new FletchingRecipe(ResourceLocation.m_214293_((String)"overgeared", (String)("lingering_conv_" + idCounter++)), Ingredient.f_43901_, Ingredient.m_43927_((ItemStack[])new ItemStack[]{arrow}), Ingredient.f_43901_, Ingredient.m_43927_((ItemStack[])new ItemStack[]{potionStack}), output, ItemStack.f_41583_, ItemStack.f_41583_, "Potion", "LingeringPotion"));
            }
        }
        return list;
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(SteelSmithingAnvilScreen.class, 90, 35, 22, 15, new RecipeType[]{ForgingRecipeCategory.FORGING_RECIPE_TYPE});
        registration.addRecipeClickArea(NetherAlloySmelterScreen.class, 90, 35, 22, 15, new RecipeType[]{NetherAlloySmeltingRecipeCategory.ALLOY_SMELTING_TYPE});
        registration.addRecipeClickArea(AlloySmelterScreen.class, 86, 35, 22, 15, new RecipeType[]{AlloySmeltingRecipeCategory.ALLOY_SMELTING_TYPE});
        registration.addRecipeClickArea(FletchingStationScreen.class, 90, 35, 22, 15, new RecipeType[]{FletchingCategory.FLETCHING_RECIPE_TYPE});
        registration.addRecipeClickArea(TierASmithingAnvilScreen.class, 90, 35, 22, 15, new RecipeType[]{ForgingRecipeCategory.FORGING_RECIPE_TYPE});
        registration.addRecipeClickArea(TierBSmithingAnvilScreen.class, 90, 35, 22, 15, new RecipeType[]{ForgingRecipeCategory.FORGING_RECIPE_TYPE});
        registration.addRecipeClickArea(StoneSmithingAnvilScreen.class, 90, 35, 22, 15, new RecipeType[]{ForgingRecipeCategory.FORGING_RECIPE_TYPE});
        registration.addRecipeClickArea(RockKnappingScreen.class, 90, 35, 22, 15, new RecipeType[]{KnappingRecipeCategory.KNAPPING_RECIPE_TYPE});
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.useNbtForSubtypes(new Item[]{(Item)ModItems.LINGERING_ARROW.get()});
        registration.useNbtForSubtypes(new Item[]{(Item)ModItems.IRON_UPGRADE_ARROW.get()});
        registration.useNbtForSubtypes(new Item[]{(Item)ModItems.STEEL_UPGRADE_ARROW.get()});
        registration.useNbtForSubtypes(new Item[]{(Item)ModItems.DIAMOND_UPGRADE_ARROW.get()});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(SteelSmithingAnvilMenu.class, (MenuType)ModMenuTypes.STEEL_SMITHING_ANVIL_MENU.get(), ForgingRecipeCategory.FORGING_RECIPE_TYPE, 38, 9, 0, 36);
        registration.addRecipeTransferHandler(StoneSmithingAnvilMenu.class, (MenuType)ModMenuTypes.STONE_SMITHING_ANVIL_MENU.get(), ForgingRecipeCategory.FORGING_RECIPE_TYPE, 37, 9, 0, 36);
        registration.addRecipeTransferHandler(TierASmithingAnvilMenu.class, (MenuType)ModMenuTypes.TIER_A_SMITHING_ANVIL_MENU.get(), ForgingRecipeCategory.FORGING_RECIPE_TYPE, 38, 9, 0, 36);
        registration.addRecipeTransferHandler(TierBSmithingAnvilMenu.class, (MenuType)ModMenuTypes.TIER_B_SMITHING_ANVIL_MENU.get(), ForgingRecipeCategory.FORGING_RECIPE_TYPE, 38, 9, 0, 36);
        registration.addRecipeTransferHandler(FletchingStationMenu.class, (MenuType)ModMenuTypes.FLETCHING_STATION_MENU.get(), FletchingCategory.FLETCHING_RECIPE_TYPE, 0, 4, 5, 36);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.ALLOY_FURNACE.get()), new RecipeType[]{AlloySmeltingRecipeCategory.ALLOY_SMELTING_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.NETHER_ALLOY_FURNACE.get()), new RecipeType[]{NetherAlloySmeltingRecipeCategory.ALLOY_SMELTING_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.STONE_SMITHING_ANVIL.get()), new RecipeType[]{ForgingRecipeCategory.FORGING_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.SMITHING_ANVIL.get()), new RecipeType[]{ForgingRecipeCategory.FORGING_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.ROCK.get()), new RecipeType[]{KnappingRecipeCategory.KNAPPING_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.TIER_A_SMITHING_ANVIL.get()), new RecipeType[]{ForgingRecipeCategory.FORGING_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.TIER_B_SMITHING_ANVIL.get()), new RecipeType[]{ForgingRecipeCategory.FORGING_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50622_), new RecipeType[]{FletchingCategory.FLETCHING_RECIPE_TYPE});
    }

    private List<ItemStack> getTippedArrowPotions() {
        ArrayList<ItemStack> potions = new ArrayList<ItemStack>();
        for (Potion potion : ForgeRegistries.POTIONS) {
            if (potion == Potions.f_43598_) continue;
            potions.add(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)potion));
        }
        return potions;
    }

    private List<ItemStack> getLingeringPotions() {
        ArrayList<ItemStack> potions = new ArrayList<ItemStack>();
        for (Potion potion : ForgeRegistries.POTIONS) {
            if (potion == Potions.f_43598_) continue;
            potions.add(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42739_), (Potion)potion));
        }
        return potions;
    }
}

