/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.compat;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.stirdrem.overgeared.config.ServerConfig;
import net.stirdrem.overgeared.item.ModItems;
import net.stirdrem.overgeared.util.CastingConfigHelper;

public final class NetherToolCastRecipeMaker {
    private NetherToolCastRecipeMaker() {
    }

    public static List<CraftingRecipe> createRecipes() {
        Map<String, List<List>> grouped = ((List)ServerConfig.TOOL_HEAD_SETTING.get()).stream().filter(row -> row instanceof List && row.size() >= 2).collect(Collectors.groupingBy(row -> (String)row.get(1)));
        return grouped.entrySet().stream().map(entry -> {
            String toolType = (String)entry.getKey();
            List<Item> toolHeads = ((List)entry.getValue()).stream().map(row -> (String)row.get(0)).map(ResourceLocation::m_135820_).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_257033_).m_7745_(arg_0)).filter(item -> item != Items.f_41852_).toList();
            if (toolHeads.isEmpty()) {
                return null;
            }
            return NetherToolCastRecipeMaker.createRecipe(toolHeads, toolType);
        }).filter(Objects::nonNull).toList();
    }

    private static CraftingRecipe createRecipe(List<Item> toolHeads, String toolType) {
        Ingredient headIngredient = Ingredient.m_43921_(toolHeads.stream().map(ItemStack::new));
        NonNullList inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.f_43901_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42691_}), Ingredient.f_43901_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42691_}), headIngredient, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42691_}), Ingredient.f_43901_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42691_}), Ingredient.f_43901_});
        ItemStack output = NetherToolCastRecipeMaker.createOutput(toolType);
        ResourceLocation id = ResourceLocation.m_214293_((String)"overgeared", (String)("jei.clay_cast." + toolType));
        return new ShapedRecipe(id, "jei.clay_cast", CraftingBookCategory.MISC, 3, 3, inputs, output);
    }

    private static ItemStack createOutput(String toolType) {
        ItemStack result = new ItemStack((ItemLike)ModItems.NETHER_TOOL_CAST.get());
        CompoundTag tag = result.m_41784_();
        tag.m_128359_("ToolType", toolType);
        tag.m_128405_("Amount", 0);
        tag.m_128405_("MaxAmount", CastingConfigHelper.getMaxMaterialAmount(toolType));
        return result;
    }
}

