/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.compat;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.stirdrem.overgeared.block.ModBlocks;
import net.stirdrem.overgeared.recipe.ExplanationRecipe;

public class SteelAnvilCategory
implements IRecipeCategory<ExplanationRecipe> {
    private static final ResourceLocation BACKGROUND_LOCATION = ResourceLocation.m_214293_((String)"overgeared", (String)"textures/gui/explanation_jei.png");
    public static final ResourceLocation UID = ResourceLocation.m_214293_((String)"overgeared", (String)"steel_anvil");
    public static final RecipeType<ExplanationRecipe> STEEL_ANVIL_GET = new RecipeType(UID, ExplanationRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final Component title;
    private final List<ItemStack> hammerItems;
    private static final int CYCLE_TIME = 60;

    public SteelAnvilCategory(IGuiHelper guiHelper, RegistryAccess registryAccess) {
        this.background = guiHelper.drawableBuilder(BACKGROUND_LOCATION, 0, 0, 150, 200).setTextureSize(150, 200).build();
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)ModBlocks.SMITHING_ANVIL.get()));
        this.title = Component.m_237115_((String)"jei.overgeared.category.steel_anvil");
        TagKey hammerTag = TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_257033_.m_123023_(), (ResourceLocation)ResourceLocation.m_214293_((String)"overgeared", (String)"smithing_hammers"));
        this.hammerItems = registryAccess.m_175515_(Registries.f_256913_).m_203431_(hammerTag).stream().flatMap(tag -> tag.m_203614_()).map(ItemStack::new).collect(Collectors.toList());
    }

    public RecipeType<ExplanationRecipe> getRecipeType() {
        return STEEL_ANVIL_GET;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ExplanationRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 72, 18).addItemStacks(this.hammerItems);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 72, 60).addItemStack(recipe.getResultItem());
    }

    public void draw(ExplanationRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        int textWidth = 140;
        int textX = 5;
        int textY = 85;
        SteelAnvilCategory.renderWrappedText(guiGraphics, (Component)Component.m_237115_((String)"jei.overgeared.steel_anvil.description"), textX, textY, textWidth, ChatFormatting.DARK_GRAY.m_126665_(), false);
    }

    public static void renderWrappedText(GuiGraphics guiGraphics, Component text, int x, int y, int width, int color, boolean shadow) {
        Font font = Minecraft.m_91087_().f_91062_;
        List lines = font.m_92923_((FormattedText)text, width);
        for (int i = 0; i < lines.size(); ++i) {
            FormattedCharSequence formattedCharSequence = (FormattedCharSequence)lines.get(i);
            Objects.requireNonNull(font);
            guiGraphics.m_280649_(font, formattedCharSequence, x, y + i * 9, color, shadow);
        }
    }

    public static int calculateTextHeight(Component text, int width) {
        Font font = Minecraft.m_91087_().f_91062_;
        int n = font.m_92923_((FormattedText)text, width).size();
        Objects.requireNonNull(font);
        return n * 9;
    }
}

