/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.datagen;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.stirdrem.overgeared.AnvilTier;
import net.stirdrem.overgeared.ForgingBookCategory;
import net.stirdrem.overgeared.ForgingQuality;
import net.stirdrem.overgeared.recipe.ForgingRecipe;
import net.stirdrem.overgeared.util.ModTags;

public class ShapedForgingRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory category;
    private final ForgingBookCategory bookCategory;
    private final Item result;
    private final int count;
    private final int hammering;
    private final List<String> rows = Lists.newArrayList();
    private final Map<Character, Ingredient> key = new LinkedHashMap<Character, Ingredient>();
    private final Advancement.Builder advancement = Advancement.Builder.m_285878_();
    @Nullable
    private final List<String> blueprintTypes = new ArrayList<String>();
    @Nullable
    private Boolean requiresBlueprint;
    @Nullable
    private Boolean hasQuality;
    @Nullable
    private Boolean hasPolishing;
    @Nullable
    private Boolean needQuenching;
    @Nullable
    private Boolean needsMinigame;
    @Nullable
    private String group;
    @Nullable
    private String tier;
    @Nullable
    private Item failedResult;
    @Nullable
    private int failedResultCount;
    @Nullable
    private ForgingQuality minimumQuality;
    private boolean showNotification = true;

    public ShapedForgingRecipeBuilder(RecipeCategory category, ForgingBookCategory bookCategory, ItemLike result, int count, int hammering) {
        this.category = category;
        this.bookCategory = bookCategory;
        this.result = result.m_5456_();
        this.count = count;
        this.hammering = hammering;
    }

    private static boolean isTools(Item item) {
        return item instanceof SwordItem || item instanceof DiggerItem || item instanceof ProjectileWeaponItem;
    }

    public static boolean isToolPart(ItemStack stack) {
        return !stack.m_41619_() && stack.m_204117_(ModTags.Items.TOOL_PARTS);
    }

    public static boolean isToolPart(Item item) {
        return item.m_204114_().m_203656_(ModTags.Items.TOOL_PARTS);
    }

    private static ForgingBookCategory determineWeaponRecipeCategory(ItemLike pResult) {
        if (ShapedForgingRecipeBuilder.isTools(pResult.m_5456_()) || ShapedForgingRecipeBuilder.isToolPart(pResult.m_5456_())) {
            return ForgingBookCategory.TOOLS;
        }
        return pResult.m_5456_() instanceof ArmorItem ? ForgingBookCategory.ARMORS : ForgingBookCategory.MISC;
    }

    public static ShapedForgingRecipeBuilder shaped(RecipeCategory category, ItemLike result, int hammering) {
        return new ShapedForgingRecipeBuilder(category, ShapedForgingRecipeBuilder.determineWeaponRecipeCategory(result), result, 1, hammering);
    }

    public static ShapedForgingRecipeBuilder shaped(RecipeCategory category, ItemLike result, int count, int hammering) {
        return new ShapedForgingRecipeBuilder(category, ShapedForgingRecipeBuilder.determineWeaponRecipeCategory(result), result, count, hammering);
    }

    public ShapedForgingRecipeBuilder define(Character pSymbol, TagKey<Item> pTag) {
        return this.define(pSymbol, Ingredient.m_204132_(pTag));
    }

    public ShapedForgingRecipeBuilder define(Character symbol, ItemLike item) {
        return this.define(symbol, Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public ShapedForgingRecipeBuilder define(Character pSymbol, Ingredient pIngredient) {
        if (this.key.containsKey(pSymbol)) {
            throw new IllegalArgumentException("Symbol '" + pSymbol + "' is already defined!");
        }
        if (pSymbol.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(pSymbol, pIngredient);
        return this;
    }

    public ShapedForgingRecipeBuilder pattern(String pPattern) {
        if (!this.rows.isEmpty() && pPattern.length() != this.rows.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.rows.add(pPattern);
        return this;
    }

    public ShapedForgingRecipeBuilder unlockedBy(String pCriterionName, CriterionTriggerInstance pCriterionTrigger) {
        this.advancement.m_138386_(pCriterionName, pCriterionTrigger);
        return this;
    }

    public ShapedForgingRecipeBuilder group(@Nullable String pGroupName) {
        this.group = pGroupName;
        return this;
    }

    public ShapedForgingRecipeBuilder tier(@Nullable AnvilTier pTier) {
        this.tier = pTier.getDisplayName();
        return this;
    }

    public ShapedForgingRecipeBuilder setQuality(@Nullable boolean hasQuality) {
        this.hasQuality = hasQuality;
        return this;
    }

    public ShapedForgingRecipeBuilder requiresBlueprint(@Nullable boolean requiresBlueprint) {
        this.requiresBlueprint = requiresBlueprint;
        return this;
    }

    public ShapedForgingRecipeBuilder needsMinigame(@Nullable boolean needsMinigame) {
        this.needsMinigame = needsMinigame;
        return this;
    }

    public ShapedForgingRecipeBuilder failedResult(ItemLike result) {
        this.failedResult = result.m_5456_();
        this.failedResultCount = 1;
        return this;
    }

    public ShapedForgingRecipeBuilder failedResult(ItemLike result, int count) {
        this.failedResult = result.m_5456_();
        this.failedResultCount = count;
        return this;
    }

    public ShapedForgingRecipeBuilder setBlueprint(String blueprintType) {
        if (blueprintType != null && !blueprintType.isBlank()) {
            this.blueprintTypes.add(blueprintType.toLowerCase());
        }
        return this;
    }

    public ShapedForgingRecipeBuilder minimumQuality(@Nullable ForgingQuality minimumQuality) {
        this.minimumQuality = minimumQuality;
        return this;
    }

    public ShapedForgingRecipeBuilder setPolishing(@Nullable boolean hasPolishing) {
        this.hasPolishing = hasPolishing;
        return this;
    }

    public ShapedForgingRecipeBuilder showNotification(boolean pShowNotification) {
        this.showNotification = pShowNotification;
        return this;
    }

    public ShapedForgingRecipeBuilder setNeedQuenching(@Nullable boolean needQuenching) {
        this.needQuenching = needQuenching;
        return this;
    }

    public Item m_142372_() {
        return this.result;
    }

    public Item getFailedResult() {
        return this.failedResult;
    }

    public void m_126140_(Consumer<FinishedRecipe> pRecipeOutput, ResourceLocation pRecipeId) {
        this.ensureValid(pRecipeId);
        int width = this.rows.get(0).length();
        int height = this.rows.size();
        NonNullList ingredients = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
        for (int i = 0; i < height; ++i) {
            String patternLine = this.rows.get(i);
            for (int j = 0; j < width; ++j) {
                char symbol = patternLine.charAt(j);
                Ingredient ingredient = this.key.getOrDefault(Character.valueOf(symbol), Ingredient.f_43901_);
                ingredients.set(i * width + j, (Object)ingredient);
            }
        }
        pRecipeOutput.accept(new Result((NonNullList<Ingredient>)ingredients, this.hammering, new ItemStack((ItemLike)this.result, this.count), pRecipeId, this.failedResult != null ? new ItemStack((ItemLike)this.failedResult, this.failedResultCount) : ItemStack.f_41583_, this.group == null ? "" : this.group, this.bookCategory, this.rows, this.key, this.advancement, pRecipeId.m_246208_("recipes/" + this.category.m_247710_() + "/"), this.showNotification, this.blueprintTypes, this.hasQuality != null && this.hasQuality == false ? null : Boolean.valueOf(this.requiresBlueprint != null ? this.requiresBlueprint : false), this.hasQuality == null || this.hasQuality != false, this.hasQuality != null && this.hasQuality == false ? null : Boolean.valueOf(this.hasPolishing != null ? this.hasPolishing : true), this.hasQuality != null && this.hasQuality != false ? null : Boolean.valueOf(this.needsMinigame != null && this.needsMinigame != false), this.hasQuality != null && this.hasQuality == false ? "" : (this.minimumQuality != null ? this.minimumQuality.getDisplayName() : ForgingQuality.POOR.getDisplayName()), this.tier == null ? "" : this.tier, this.needQuenching == null ? true : this.needQuenching));
    }

    private void ensureValid(ResourceLocation pRecipeId) {
        if (this.rows.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped forging recipe " + pRecipeId + "!");
        }
        int width = this.rows.get(0).length();
        for (String row : this.rows) {
            if (row.length() == width) continue;
            throw new IllegalStateException("Pattern must be the same width on every line!");
        }
    }

    static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final NonNullList<Ingredient> ingredients;
        private final int hammering;
        private final ItemStack result;
        private final ItemStack failedResult;
        private final List<String> pattern;
        private final Map<Character, Ingredient> key;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;
        private final boolean showNotification;
        private final String group;
        private final List<String> blueprintTypes;
        private final ForgingBookCategory category;
        private final Boolean requiresBlueprint;
        private final Boolean hasQuality;
        private final Boolean hasPolishing;
        private final Boolean needsMinigame;
        private final String minimumQuality;
        private final String tier;
        private final Boolean needQuenching;

        public Result(NonNullList<Ingredient> ingredients, int hammering, ItemStack result, ResourceLocation id, ItemStack failedResult, String group, ForgingBookCategory category, List<String> pattern, Map<Character, Ingredient> key, Advancement.Builder advancement, ResourceLocation advancementId, boolean showNotification, List<String> blueprintTypes, Boolean requiresBlueprint, Boolean hasQuality, Boolean hasPolishing, Boolean needsMinigame, String minimumQuality, String tier, Boolean needQuenching) {
            this.ingredients = ingredients;
            this.hammering = hammering;
            this.result = result;
            this.failedResult = failedResult;
            this.category = category;
            this.id = id;
            this.group = group;
            this.pattern = pattern;
            this.key = key;
            this.advancement = advancement;
            this.advancementId = advancementId;
            this.showNotification = showNotification;
            this.blueprintTypes = blueprintTypes;
            this.requiresBlueprint = requiresBlueprint;
            this.hasQuality = hasQuality;
            this.hasPolishing = hasPolishing;
            this.needsMinigame = needsMinigame;
            this.minimumQuality = minimumQuality;
            this.tier = tier;
            this.needQuenching = needQuenching;
        }

        public void m_7917_(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            if (this.requiresBlueprint != null) {
                json.addProperty("requires_blueprint", this.requiresBlueprint);
            }
            if (!this.blueprintTypes.isEmpty()) {
                JsonArray blueprintArray = new JsonArray();
                for (String string : this.blueprintTypes) {
                    blueprintArray.add(string);
                }
                json.add("blueprint", (JsonElement)blueprintArray);
            }
            json.addProperty("category", this.category.m_7912_());
            JsonArray patternArray = new JsonArray();
            for (String string : this.pattern) {
                patternArray.add(string);
            }
            json.add("pattern", (JsonElement)patternArray);
            if (!this.tier.isBlank()) {
                json.addProperty("tier", this.tier);
            }
            json.addProperty("hammering", (Number)this.hammering);
            if (this.hasQuality != null) {
                json.addProperty("has_quality", this.hasQuality);
            }
            if (!this.minimumQuality.isEmpty()) {
                json.addProperty("minimum_quality", this.minimumQuality);
            }
            if (this.needsMinigame != null || !this.needsMinigame.booleanValue()) {
                json.addProperty("needs_minigame", this.needsMinigame);
            }
            if (this.needQuenching != null) {
                json.addProperty("need_quenching", this.needQuenching);
            }
            if (this.hasPolishing != null) {
                json.addProperty("has_polishing", this.hasPolishing);
            }
            JsonObject keyObj = new JsonObject();
            for (Map.Entry<Character, Ingredient> entry : this.key.entrySet()) {
                keyObj.add(String.valueOf(entry.getKey()), entry.getValue().m_43942_());
            }
            json.add("key", (JsonElement)keyObj);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)this.result.m_41720_()).toString());
            if (this.result.m_41613_() > 1) {
                jsonObject.addProperty("count", (Number)this.result.m_41613_());
            }
            json.add("result", (JsonElement)jsonObject);
            if (!this.failedResult.m_41619_() && this.failedResult.m_41720_() != Items.f_41852_) {
                JsonObject jsonObject2 = new JsonObject();
                jsonObject2.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)this.failedResult.m_41720_()).toString());
                if (this.failedResult.m_41613_() > 1) {
                    jsonObject2.addProperty("count", (Number)this.failedResult.m_41613_());
                }
                json.add("result_failed", (JsonElement)jsonObject2);
            }
            json.addProperty("show_notification", Boolean.valueOf(this.showNotification));
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return ForgingRecipe.Serializer.INSTANCE;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

