/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.event;

import com.google.common.collect.LinkedHashMultimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.stirdrem.overgeared.BlueprintQuality;
import net.stirdrem.overgeared.OvergearedMod;
import net.stirdrem.overgeared.block.entity.AbstractSmithingAnvilBlockEntity;
import net.stirdrem.overgeared.config.ServerConfig;
import net.stirdrem.overgeared.event.AnvilMinigameEvents;
import net.stirdrem.overgeared.event.ModItemInteractEvents;
import net.stirdrem.overgeared.item.ModItems;
import net.stirdrem.overgeared.networking.ModMessages;
import net.stirdrem.overgeared.networking.packet.OnlyResetMinigameS2CPacket;
import net.stirdrem.overgeared.networking.packet.ResetMinigameS2CPacket;
import net.stirdrem.overgeared.util.ModTags;

@Mod.EventBusSubscriber(modid="overgeared")
public class ModEvents {
    private static final int HEATED_ITEM_CHECK_INTERVAL = 20;
    private static final float BURN_DAMAGE = 1.0f;
    private static int serverTick = 0;

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        ++serverTick;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.side == LogicalSide.CLIENT) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.player;
        if (serverTick % 20 != 0) {
            return;
        }
        Level level = player.m_9236_();
        ModEvents.handleAnvilDistance(player, level);
    }

    private static void handleAnvilDistance(ServerPlayer player, Level level) {
        int maxDist;
        double distSq;
        BlockPos anvilPos;
        BlockEntity be;
        if (AnvilMinigameEvents.hasAnvilPosition(player.m_20148_()) && (be = level.m_7702_(anvilPos = AnvilMinigameEvents.getAnvilPos(player.m_20148_()))) instanceof AbstractSmithingAnvilBlockEntity && (distSq = player.m_20183_().m_123331_((Vec3i)anvilPos)) > (double)((maxDist = ((Integer)ServerConfig.MAX_ANVIL_DISTANCE.get()).intValue()) * maxDist)) {
            ModEvents.resetMinigameForPlayer(player);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onItemAttributes(ItemAttributeModifierEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.m_41782_() && stack.m_41783_().m_128441_("ForgingQuality")) {
            String quality = stack.m_41783_().m_128461_("ForgingQuality");
            Item item = stack.m_41720_();
            ModEvents.applyWeaponAttributes(event, quality);
            ModEvents.applyArmorAttributes(event, quality);
        }
    }

    private static void applyWeaponAttributes(ItemAttributeModifierEvent event, String quality) {
        double damageBonus = ModEvents.getDamageBonusForQuality(quality);
        double speedBonus = ModEvents.getSpeedBonusForQuality(quality);
        ModEvents.modifyAttribute(event, Attributes.f_22281_, damageBonus);
        ModEvents.modifyAttribute(event, Attributes.f_22283_, speedBonus);
    }

    private static void applyArmorAttributes(ItemAttributeModifierEvent event, String quality) {
        double armorBonus = ModEvents.getArmorBonusForQuality(quality);
        ModEvents.modifyAttribute(event, Attributes.f_22284_, armorBonus);
    }

    private static void modifyAttribute(ItemAttributeModifierEvent event, Attribute attribute, double bonus) {
        LinkedHashMultimap originalModifiers = LinkedHashMultimap.create();
        originalModifiers.putAll(event.getOriginalModifiers());
        originalModifiers.get((Object)attribute).forEach(modifier -> {
            event.removeModifier(attribute, modifier);
            event.addModifier(attribute, ModEvents.createModifiedAttribute(modifier, bonus));
        });
    }

    private static AttributeModifier createModifiedAttribute(AttributeModifier original, double bonus) {
        return new AttributeModifier(original.m_22209_(), original.m_22214_() + "_forged", original.m_22218_() + bonus, original.m_22217_());
    }

    private static boolean isWeapon(Item item) {
        return item instanceof TieredItem || item instanceof ProjectileWeaponItem;
    }

    private static boolean isArmor(Item item) {
        return item instanceof ArmorItem;
    }

    private static double getDamageBonusForQuality(String quality) {
        return switch (quality.toLowerCase()) {
            case "master" -> (Double)ServerConfig.MASTER_WEAPON_DAMAGE.get();
            case "perfect" -> (Double)ServerConfig.PERFECT_WEAPON_DAMAGE.get();
            case "expert" -> (Double)ServerConfig.EXPERT_WEAPON_DAMAGE.get();
            case "well" -> (Double)ServerConfig.WELL_WEAPON_DAMAGE.get();
            case "poor" -> (Double)ServerConfig.POOR_WEAPON_DAMAGE.get();
            default -> 0.0;
        };
    }

    private static double getSpeedBonusForQuality(String quality) {
        return switch (quality.toLowerCase()) {
            case "master" -> (Double)ServerConfig.MASTER_WEAPON_SPEED.get();
            case "perfect" -> (Double)ServerConfig.PERFECT_WEAPON_SPEED.get();
            case "expert" -> (Double)ServerConfig.EXPERT_WEAPON_SPEED.get();
            case "well" -> (Double)ServerConfig.WELL_WEAPON_SPEED.get();
            case "poor" -> (Double)ServerConfig.POOR_WEAPON_SPEED.get();
            default -> 0.0;
        };
    }

    private static double getArmorBonusForQuality(String quality) {
        return switch (quality.toLowerCase()) {
            case "master" -> (Double)ServerConfig.MASTER_ARMOR_BONUS.get();
            case "perfect" -> (Double)ServerConfig.PERFECT_ARMOR_BONUS.get();
            case "expert" -> (Double)ServerConfig.EXPERT_ARMOR_BONUS.get();
            case "well" -> (Double)ServerConfig.WELL_ARMOR_BONUS.get();
            case "poor" -> (Double)ServerConfig.POOR_ARMOR_BONUS.get();
            default -> 0.0;
        };
    }

    @SubscribeEvent
    public static void onPlayerJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ModEvents.resetMinigameForPlayer(player);
        }
    }

    @SubscribeEvent
    public static void onPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ModEvents.resetMinigameForPlayer(player2);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ModEvents.resetMinigameForPlayer(player2);
        }
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        MinecraftServer server = event.getServer();
        for (ServerPlayer player : server.m_6846_().m_11314_()) {
            ModEvents.resetMinigameForPlayer(player);
        }
        OvergearedMod.LOGGER.info("Reset all minigames on server stop.");
    }

    public static void resetMinigameForPlayer(ServerPlayer player) {
        if (player == null) {
            return;
        }
        UUID playerId = player.m_20148_();
        ModMessages.sendToPlayer(new OnlyResetMinigameS2CPacket(), player);
        String blueprintQuality = BlueprintQuality.PERFECT.getDisplayName();
        if (ModItemInteractEvents.playerAnvilPositions.containsKey(player.m_20148_())) {
            BlockPos anvilPos = ModItemInteractEvents.playerAnvilPositions.get(player.m_20148_());
            BlockEntity be = player.m_9236_().m_7702_(anvilPos);
            if (be instanceof AbstractSmithingAnvilBlockEntity) {
                AbstractSmithingAnvilBlockEntity anvil = (AbstractSmithingAnvilBlockEntity)be;
                anvil.setProgress(0);
                anvil.m_6596_();
                anvil.setMinigameOn(false);
                ModMessages.sendToPlayer(new ResetMinigameS2CPacket(anvilPos), player);
                ModItemInteractEvents.releaseAnvil(player, anvilPos);
                ModItemInteractEvents.playerAnvilPositions.remove(playerId);
                ModItemInteractEvents.playerMinigameVisibility.remove(playerId);
                Block block = player.m_9236_().m_8055_(anvilPos).m_60734_();
                blueprintQuality = anvil.blueprintQuality();
            }
        }
        AnvilMinigameEvents.reset(blueprintQuality);
    }

    public static void resetMinigameForPlayer(ServerPlayer player, BlockPos anvilPos) {
        if (player == null) {
            return;
        }
        ModMessages.sendToPlayer(new OnlyResetMinigameS2CPacket(), player);
        BlockEntity be = player.m_9236_().m_7702_(anvilPos);
        String quality = "perfect";
        if (be instanceof AbstractSmithingAnvilBlockEntity) {
            AbstractSmithingAnvilBlockEntity anvil = (AbstractSmithingAnvilBlockEntity)be;
            anvil.setProgress(0);
            anvil.m_6596_();
            anvil.setMinigameOn(false);
            quality = anvil.blueprintQuality();
        }
        AnvilMinigameEvents.reset(quality);
        Block block = player.m_9236_().m_8055_(anvilPos).m_60734_();
        ModItemInteractEvents.playerAnvilPositions.remove(player.m_20148_());
        ModItemInteractEvents.playerMinigameVisibility.remove(player.m_20148_());
    }

    public static void resetMinigameForAnvil(Level level, BlockPos anvilPos) {
        String quality = "perfect";
        BlockEntity be = level.m_7702_(anvilPos);
        if (be instanceof AbstractSmithingAnvilBlockEntity) {
            AbstractSmithingAnvilBlockEntity anvil = (AbstractSmithingAnvilBlockEntity)be;
            anvil.setProgress(0);
            anvil.m_6596_();
            anvil.setMinigameOn(false);
            anvil.clearOwner();
            quality = anvil.blueprintQuality();
        }
        AnvilMinigameEvents.reset(quality);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (ServerPlayer player : serverLevel.m_7654_().m_6846_().m_11314_()) {
                UUID playerId = player.m_20148_();
                ModMessages.sendToPlayer(new ResetMinigameS2CPacket(anvilPos), player);
                if (!ModItemInteractEvents.playerAnvilPositions.getOrDefault(playerId, BlockPos.f_121853_).equals((Object)anvilPos)) continue;
                ModItemInteractEvents.playerAnvilPositions.remove(playerId);
                ModItemInteractEvents.playerMinigameVisibility.remove(playerId);
                break;
            }
        }
    }

    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        List tooltip = event.getToolTip();
        int insertOffset = 1;
        if (stack.m_41782_() && stack.m_41783_().m_128441_("ForgingQuality")) {
            MutableComponent qualityComponent;
            String quality;
            switch (quality = stack.m_41783_().m_128461_("ForgingQuality")) {
                case "poor": {
                    MutableComponent mutableComponent = Component.m_237115_((String)"tooltip.overgeared.poor").m_130940_(ChatFormatting.RED);
                    break;
                }
                case "well": {
                    MutableComponent mutableComponent = Component.m_237115_((String)"tooltip.overgeared.well").m_130940_(ChatFormatting.YELLOW);
                    break;
                }
                case "expert": {
                    MutableComponent mutableComponent = Component.m_237115_((String)"tooltip.overgeared.expert").m_130940_(ChatFormatting.BLUE);
                    break;
                }
                case "perfect": {
                    MutableComponent mutableComponent = Component.m_237115_((String)"tooltip.overgeared.perfect").m_130940_(ChatFormatting.GOLD);
                    break;
                }
                case "master": {
                    MutableComponent mutableComponent = Component.m_237115_((String)"tooltip.overgeared.master").m_130940_(ChatFormatting.LIGHT_PURPLE);
                    break;
                }
                default: {
                    MutableComponent mutableComponent = qualityComponent = null;
                }
            }
            if (qualityComponent != null) {
                tooltip.add(insertOffset++, qualityComponent);
            }
        }
        if (stack.m_41782_() && stack.m_41783_().m_128441_("Polished")) {
            boolean isPolished = stack.m_41783_().m_128471_("Polished");
            MutableComponent polishComponent = isPolished ? Component.m_237115_((String)"tooltip.overgeared.polished").m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}) : Component.m_237115_((String)"tooltip.overgeared.unpolished").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.ITALIC});
            tooltip.add(insertOffset++, polishComponent);
        }
        if (stack.m_41782_() && stack.m_41783_().m_128441_("Heated")) {
            tooltip.add(insertOffset++, Component.m_237115_((String)"tooltip.overgeared.heated").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.ITALIC}));
        }
        if (stack.m_41782_() && stack.m_41783_().m_128441_("failedResult")) {
            tooltip.add(insertOffset, Component.m_237115_((String)"tooltip.overgeared.failedResult").m_130940_(ChatFormatting.RED));
        }
        if (stack.m_204117_(ModTags.Items.SMITHING_HAMMERS)) {
            if (!Screen.m_96638_()) {
                tooltip.add(insertOffset, Component.m_237115_((String)"tooltip.overgeared.smithing_hammer.hold_shift").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            } else {
                tooltip.add(insertOffset++, Component.m_237115_((String)"tooltip.overgeared.smithing_hammer.advanced_tooltip.line1").m_130940_(ChatFormatting.GRAY));
                tooltip.add(insertOffset++, Component.m_237115_((String)"tooltip.overgeared.smithing_hammer.advanced_tooltip.line2").m_130940_(ChatFormatting.GRAY));
                if (((Boolean)ServerConfig.ENABLE_STONE_TO_ANVIL.get()).booleanValue()) {
                    tooltip.add(insertOffset++, Component.m_237115_((String)"tooltip.overgeared.smithing_hammer.advanced_tooltip.line3").m_130940_(ChatFormatting.GRAY));
                }
                if (((Boolean)ServerConfig.ENABLE_ANVIL_TO_SMITHING.get()).booleanValue()) {
                    tooltip.add(insertOffset++, Component.m_237115_((String)"tooltip.overgeared.smithing_hammer.advanced_tooltip.line4").m_130940_(ChatFormatting.GRAY));
                }
            }
        }
        if (stack.m_150930_(Items.f_42589_)) {
            CompoundTag tag = stack.m_41783_();
            int maxUses = (Integer)ServerConfig.MAX_POTION_TIPPING_USE.get();
            int used = 0;
            if (tag != null && tag.m_128425_("TippedUsed", 3)) {
                used = tag.m_128451_("TippedUsed");
            }
            int left = Math.max(0, maxUses - used);
            tooltip.add(Component.m_237110_((String)"tooltip.overgeared.potion_uses", (Object[])new Object[]{left, maxUses}).m_130940_(ChatFormatting.GRAY));
        }
        if (!((Boolean)ServerConfig.ENABLE_MOD_TOOLTIPS.get()).booleanValue()) {
            return;
        }
        if (stack.m_150930_(Items.f_42484_) && ((Boolean)ServerConfig.GET_ROCK_USING_FLINT.get()).booleanValue()) {
            tooltip.add(insertOffset++, Component.m_237115_((String)"tooltip.overgeared.flint_flavor").m_130940_(ChatFormatting.GRAY));
        }
        if (stack.m_150930_((Item)ModItems.DIAMOND_SHARD.get())) {
            tooltip.add(insertOffset++, Component.m_237115_((String)"tooltip.overgeared.diamond_shard").m_130940_(ChatFormatting.GRAY));
        }
        if (stack.m_204117_(ModTags.Items.HEATED_METALS)) {
            tooltip.add(insertOffset++, Component.m_237115_((String)"tooltip.overgeared.heatedingots.tooltip").m_130940_(ChatFormatting.RED));
        }
        if (stack.m_204117_(ModTags.Items.HEATABLE_METALS)) {
            tooltip.add(insertOffset++, Component.m_237115_((String)"tooltip.overgeared.heatablemetals.tooltip").m_130940_(ChatFormatting.GRAY));
        }
        if (stack.m_204117_(ModTags.Items.HOT_ITEMS)) {
            tooltip.add(insertOffset++, Component.m_237115_((String)"tooltip.overgeared.hotitems.tooltip").m_130940_(ChatFormatting.RED));
        }
        if (stack.m_204117_(ModTags.Items.GRINDABLE)) {
            tooltip.add(insertOffset, Component.m_237115_((String)"tooltip.overgeared.grindable").m_130940_(ChatFormatting.GRAY));
        }
    }

    @SubscribeEvent
    public static void onHammerDestroyed(PlayerDestroyItemEvent event) {
        BlockPos pos;
        ItemStack stack = event.getOriginal();
        if (!stack.m_204117_(ModTags.Items.SMITHING_HAMMERS)) {
            return;
        }
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (AnvilMinigameEvents.isIsVisible() && AnvilMinigameEvents.hasAnvilPosition(player.m_20148_()) && (pos = AnvilMinigameEvents.getAnvilPos(player.m_20148_())) != null) {
            ModEvents.resetMinigameForPlayer(serverPlayer);
        }
    }
}

