/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.item.custom;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.stirdrem.overgeared.BlueprintQuality;
import net.stirdrem.overgeared.item.ToolType;
import net.stirdrem.overgeared.item.ToolTypeRegistry;
import org.jetbrains.annotations.Nullable;

public class BlueprintItem
extends Item {
    public BlueprintItem(Item.Properties properties) {
        super(properties);
    }

    public ItemStack m_7968_() {
        ItemStack stack = super.m_7968_();
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_("Quality", BlueprintQuality.POOR.name());
        tag.m_128405_("Uses", 0);
        tag.m_128405_("UsesToLevel", BlueprintItem.getUsesToNextLevel(BlueprintQuality.POOR));
        List<ToolType> types = ToolTypeRegistry.getRegisteredTypesAll();
        tag.m_128359_("ToolType", !types.isEmpty() ? types.get(0).getId() : "SWORD");
        return stack;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return;
        }
        if (tag.m_128441_("Quality")) {
            BlueprintQuality quality = BlueprintItem.getQuality(stack);
            tooltip.add((Component)Component.m_237115_((String)"tooltip.overgeared.blueprint.quality").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)quality.getTranslationKey()).m_130940_(quality.getColor())));
            if (quality == BlueprintQuality.PERFECT || quality == BlueprintQuality.MASTER) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.overgeared.blueprint.maxlevel").m_130940_(ChatFormatting.LIGHT_PURPLE));
            }
        }
        if (tag.m_128441_("Uses")) {
            int uses = BlueprintItem.getUses(stack);
            int usesToLevel = BlueprintItem.getUsesToNextLevel(stack);
            if (!tag.m_128441_("Quality") || BlueprintItem.getQuality(stack) != BlueprintQuality.PERFECT && BlueprintItem.getQuality(stack) != BlueprintQuality.MASTER) {
                tooltip.add((Component)Component.m_237110_((String)"tooltip.overgeared.blueprint.progress", (Object[])new Object[]{uses, usesToLevel}).m_130940_(ChatFormatting.GRAY));
            }
        }
        if (tag.m_128441_("ToolType")) {
            ToolType toolType = BlueprintItem.getToolType(stack);
            tooltip.add((Component)Component.m_237115_((String)"tooltip.overgeared.blueprint.tool_type").m_130940_(ChatFormatting.GRAY).m_7220_((Component)toolType.getDisplayName().m_130940_(ChatFormatting.BLUE)));
        }
        if (tag.m_128441_("Required")) {
            boolean required = tag.m_128471_("Required");
            tooltip.add((Component)Component.m_237115_((String)(required ? "tooltip.overgeared.blueprint.required" : "tooltip.overgeared.blueprint.optional")).m_130940_(required ? ChatFormatting.RED : ChatFormatting.GRAY));
        }
    }

    public static BlueprintQuality getQuality(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_("Quality")) {
            return BlueprintQuality.POOR;
        }
        try {
            return BlueprintQuality.fromString(tag.m_128461_("Quality"));
        }
        catch (IllegalArgumentException e) {
            return BlueprintQuality.POOR;
        }
    }

    public static int getUses(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null ? tag.m_128451_("Uses") : 0;
    }

    public static int getUsesToNextLevel(ItemStack stack) {
        return BlueprintItem.getUsesToNextLevel(BlueprintItem.getQuality(stack));
    }

    public static ToolType getToolType(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_("ToolType")) {
            List<ToolType> types = ToolTypeRegistry.getRegisteredTypesAll();
            return !types.isEmpty() ? types.get(0) : ToolType.SWORD;
        }
        return ToolTypeRegistry.byId(tag.m_128461_("ToolType")).orElse(ToolType.SWORD);
    }

    public static void cycleToolType(ItemStack stack) {
        List<ToolType> available = ToolTypeRegistry.getRegisteredTypesAll();
        if (available.isEmpty()) {
            return;
        }
        ToolType current = BlueprintItem.getToolType(stack);
        int currentIndex = available.indexOf(current);
        int nextIndex = (currentIndex + 1) % available.size();
        stack.m_41784_().m_128359_("ToolType", available.get(nextIndex).getId());
    }

    private static int getUsesToNextLevel(BlueprintQuality quality) {
        return switch (quality) {
            default -> throw new IncompatibleClassChangeError();
            case BlueprintQuality.POOR -> BlueprintQuality.POOR.getUse();
            case BlueprintQuality.WELL -> BlueprintQuality.WELL.getUse();
            case BlueprintQuality.EXPERT -> BlueprintQuality.EXPERT.getUse();
            case BlueprintQuality.PERFECT -> BlueprintQuality.PERFECT.getUse();
            case BlueprintQuality.MASTER -> BlueprintQuality.MASTER.getUse();
        };
    }
}

