/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.networking.packet;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;
import net.stirdrem.overgeared.OvergearedMod;
import net.stirdrem.overgeared.screen.RockKnappingMenu;

public class KnappingChipC2SPacket {
    private final int index;

    public KnappingChipC2SPacket(int index) {
        this.index = index;
    }

    public KnappingChipC2SPacket(FriendlyByteBuf buf) {
        this.index = buf.readInt();
    }

    public static void encode(KnappingChipC2SPacket msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.index);
    }

    public static KnappingChipC2SPacket decode(FriendlyByteBuf buf) {
        return new KnappingChipC2SPacket(buf.readInt());
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            AbstractContainerMenu patt1175$temp;
            ServerPlayer player = context.getSender();
            if (player != null && (patt1175$temp = player.f_36096_) instanceof RockKnappingMenu) {
                RockKnappingMenu menu = (RockKnappingMenu)patt1175$temp;
                if (this.index >= 0 && this.index < 9) {
                    menu.setChip(this.index);
                    OvergearedMod.LOGGER.debug("Player {} chipped spot {} in knapping grid", (Object)player.m_7755_().getString(), (Object)this.index);
                }
            }
        });
        context.setPacketHandled(true);
        return true;
    }
}

