/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.screen;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.stirdrem.overgeared.item.ToolType;
import net.stirdrem.overgeared.item.ToolTypeRegistry;
import net.stirdrem.overgeared.networking.ModMessages;
import net.stirdrem.overgeared.networking.packet.SelectToolTypeC2SPacket;
import net.stirdrem.overgeared.screen.BlueprintWorkbenchMenu;

public class BlueprintWorkbenchScreen
extends AbstractContainerScreen<BlueprintWorkbenchMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.m_214293_((String)"overgeared", (String)"textures/gui/blueprint_workbench.png");
    private List<ToolType> toolTypes;
    private int selectedIndex = 0;
    private Button prevButton;
    private Button nextButton;
    private Button selectButton;
    private Component currentToolName;

    public BlueprintWorkbenchScreen(BlueprintWorkbenchMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = 166;
        this.toolTypes = ToolTypeRegistry.getRegisteredTypes();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97728_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2;
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.createButtons(x, y);
        this.selectButton.f_93623_ = false;
        if (this.toolTypes.isEmpty()) {
            this.handleNoToolsAvailable(x, y);
        } else {
            this.updateToolDisplay();
        }
    }

    protected void m_181908_() {
        super.m_181908_();
        boolean hasItem = !((BlueprintWorkbenchMenu)this.f_97732_).m_38853_(0).m_7993_().m_41619_();
        this.selectButton.f_93623_ = hasItem && !this.toolTypes.isEmpty();
    }

    private void createButtons(int x, int y) {
        int centerX = x + this.f_97726_ / 2;
        int buttonRowY = y + 15;
        int buttonWidth = 10;
        int buttonPosFromCenter = 40;
        this.prevButton = Button.m_253074_((Component)Component.m_237113_((String)"<"), btn -> {
            this.selectedIndex = (this.selectedIndex - 1 + this.toolTypes.size()) % this.toolTypes.size();
            this.updateToolDisplay();
        }).m_252794_(centerX - buttonWidth / 2 - buttonPosFromCenter, buttonRowY).m_253046_(buttonWidth, 12).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"tooltip.overgeared.previous_tool"))).m_253136_();
        this.nextButton = Button.m_253074_((Component)Component.m_237113_((String)">"), btn -> {
            this.selectedIndex = (this.selectedIndex + 1) % this.toolTypes.size();
            this.updateToolDisplay();
        }).m_252794_(centerX - buttonWidth / 2 + buttonPosFromCenter, buttonRowY).m_253046_(buttonWidth, 12).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"tooltip.overgeared.next_tool"))).m_253136_();
        int selectButtonWidth = 60;
        int selectButtonY = y + 58;
        this.selectButton = Button.m_253074_((Component)Component.m_237115_((String)"button.overgeared.select"), btn -> {
            if (!this.toolTypes.isEmpty()) {
                ModMessages.sendToServer(new SelectToolTypeC2SPacket(this.toolTypes.get(this.selectedIndex).getId(), ((BlueprintWorkbenchMenu)this.f_97732_).f_38840_));
            }
        }).m_252794_(x + this.f_97726_ / 2 - selectButtonWidth / 2, selectButtonY).m_253046_(selectButtonWidth, 14).m_253136_();
        this.m_142416_((GuiEventListener)this.prevButton);
        this.m_142416_((GuiEventListener)this.nextButton);
        this.m_142416_((GuiEventListener)this.selectButton);
    }

    private void handleNoToolsAvailable(int x, int y) {
        this.prevButton.f_93623_ = false;
        this.nextButton.f_93623_ = false;
        this.prevButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"tooltip.overgeared.no_tools_available")));
        this.nextButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"tooltip.overgeared.no_tools_available")));
        this.selectButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"tooltip.overgeared.no_tools_available")));
        this.currentToolName = Component.m_237113_((String)"Null");
    }

    private void updateToolDisplay() {
        if (!this.toolTypes.isEmpty()) {
            ToolType currentTool = this.toolTypes.get(this.selectedIndex);
            this.currentToolName = currentTool.getDisplayName();
            this.selectButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237110_((String)"tooltip.overgeared.select_tool", (Object[])new Object[]{this.currentToolName})));
            this.prevButton.f_93623_ = true;
            this.nextButton.f_93623_ = true;
        } else {
            this.handleNoToolsAvailable((this.f_96543_ - this.f_97726_) / 2, (this.f_96544_ - this.f_97727_) / 2);
        }
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
        if (this.currentToolName != null) {
            int textWidth = this.f_96547_.m_92852_((FormattedText)this.currentToolName);
            int textColor = this.toolTypes.isEmpty() ? 0xFF0000 : 0x404040;
            guiGraphics.m_280614_(this.f_96547_, this.currentToolName, x + this.f_97726_ / 2 - textWidth / 2, y + 18, textColor, false);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }
}

