/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.screen;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.stirdrem.overgeared.block.ModBlocks;
import net.stirdrem.overgeared.block.entity.NetherAlloySmelterBlockEntity;
import net.stirdrem.overgeared.screen.ModMenuTypes;

public class NetherAlloySmelterMenu
extends AbstractContainerMenu {
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 9;
    private final NetherAlloySmelterBlockEntity blockEntity;
    private final ContainerData data;
    private final Level level;

    public NetherAlloySmelterMenu(int id, Inventory inv, FriendlyByteBuf extraData) {
        this(id, inv, (BlockEntity)((NetherAlloySmelterBlockEntity)inv.f_35978_.m_9236_().m_7702_(extraData.m_130135_())), (ContainerData)new SimpleContainerData(11));
    }

    public NetherAlloySmelterMenu(int id, Inventory playerInv, final BlockEntity blockEntity, ContainerData data) {
        super((MenuType)ModMenuTypes.NETHER_ALLOY_SMELTER_MENU.get(), id);
        NetherAlloySmelterMenu.m_38869_((Container)playerInv, (int)11);
        this.blockEntity = (NetherAlloySmelterBlockEntity)blockEntity;
        this.data = data;
        this.level = playerInv.f_35978_.m_9236_();
        this.m_38884_(data);
        this.addPlayerInventory(playerInv);
        this.addPlayerHotbar(playerInv);
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    Slot slot = this.m_38897_((Slot)new SlotItemHandler((IItemHandler)iItemHandler, j + i * 3, 30 + j * 18, 17 + i * 18){

                        public boolean m_8010_(Player player) {
                            return true;
                        }
                    });
                }
            }
            this.m_38897_((Slot)new SlotItemHandler(iItemHandler, 9, 8, 53));
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)iItemHandler, 10, 124, 35){

                public void m_142406_(Player player, ItemStack stack) {
                    super.m_142406_(player, stack);
                    this.m_5845_(stack);
                    ((NetherAlloySmelterBlockEntity)blockEntity).awardStoredExperience(player);
                }

                public boolean m_5857_(ItemStack stack) {
                    return false;
                }

                public boolean m_8010_(Player player) {
                    return true;
                }
            });
        });
    }

    private void addPlayerInventory(Inventory playerInv) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInv, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInv) {
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInv, col, 8 + col * 18, 142));
        }
    }

    public boolean m_6875_(Player pPlayer) {
        return NetherAlloySmelterMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)pPlayer, (Block)((Block)ModBlocks.NETHER_ALLOY_FURNACE.get()));
    }

    public ItemStack m_7648_(Player player, int index) {
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSource = sourceStack.m_41777_();
        int startPlayer = 0;
        int endPlayer = 36;
        int startTE = 36;
        int endTE = 45;
        int inputStart = startTE;
        int inputEnd = startTE + 9;
        int fuelSlot = startTE + 9;
        int outputSlot = startTE + 10;
        if (index >= startTE && index < endTE) {
            if (index == outputSlot) {
                if (!this.m_38903_(sourceStack, startPlayer, endPlayer, true)) {
                    return ItemStack.f_41583_;
                }
                sourceSlot.m_40234_(sourceStack, copyOfSource);
            } else if (!this.m_38903_(sourceStack, startPlayer, endPlayer, false)) {
                return ItemStack.f_41583_;
            }
        } else if (index >= startPlayer && index < endPlayer) {
            if (ForgeHooks.getBurnTime((ItemStack)sourceStack, (RecipeType)RecipeType.f_44108_) > 0 ? !this.m_38903_(sourceStack, fuelSlot, fuelSlot + 1, false) && !this.m_38903_(sourceStack, inputStart, inputEnd, false) : !this.m_38903_(sourceStack, inputStart, inputEnd, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(player, sourceStack);
        return copyOfSource;
    }

    public boolean isLit() {
        return this.data.m_6413_(0) > 0;
    }

    public int getLitProgress() {
        int i = this.data.m_6413_(1);
        if (i == 0) {
            i = 200;
        }
        return this.data.m_6413_(0) * 13 / i;
    }

    public int getCookProgress() {
        int cookTime = this.data.m_6413_(2);
        int cookTimeTotal = this.data.m_6413_(3);
        return cookTimeTotal != 0 && cookTime != 0 ? cookTime * 24 / cookTimeTotal : 0;
    }
}

