/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.util;

import java.util.ArrayList;
import java.util.List;
import net.stirdrem.overgeared.config.ServerConfig;

public class CastingConfigHelper {
    public static String getToolTypeDisplayName(String toolType) {
        return "tooltype.overgeared." + toolType.toLowerCase();
    }

    public static int getMaxMaterialAmount(String toolType) {
        for (List e : (List)ServerConfig.CASTING_TOOL_TYPES.get()) {
            List row = e;
            if (!row.get(0).equals(toolType)) continue;
            return ((Number)row.get(1)).intValue();
        }
        return 0;
    }

    public static String getMaterialDisplayName(String materialId) {
        return "material.overgeared." + materialId.toLowerCase();
    }

    public static String getToolTypeForItem(String itemId) {
        for (List e : (List)ServerConfig.TOOL_HEAD_SETTING.get()) {
            List row = e;
            if (!row.get(0).equals(itemId)) continue;
            return (String)row.get(1);
        }
        return "none";
    }

    public static String getMaterialForItem(String itemId) {
        for (List e : (List)ServerConfig.MATERIAL_SETTING.get()) {
            List row = e;
            if (!row.get(0).equals(itemId)) continue;
            return (String)row.get(1);
        }
        return "none";
    }

    public static int getMaterialValue(String itemId) {
        for (List e : (List)ServerConfig.MATERIAL_SETTING.get()) {
            List row = e;
            if (!row.get(0).equals(itemId)) continue;
            return ((Number)row.get(2)).intValue();
        }
        return 0;
    }

    public static boolean isValidMaterial(String itemId) {
        for (List entry : (List)ServerConfig.MATERIAL_SETTING.get()) {
            List row = entry;
            if (row.size() < 3 || !row.get(0).equals(itemId)) continue;
            return true;
        }
        return false;
    }

    public static List<String> getAllItemsWithToolType(String toolType) {
        ArrayList<String> items = new ArrayList<String>();
        for (List e : (List)ServerConfig.TOOL_HEAD_SETTING.get()) {
            List row = e;
            if (row.size() < 2 || !row.get(1).equals(toolType)) continue;
            items.add((String)row.get(0));
        }
        return items;
    }
}

