/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.client;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.FormattedText;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.stirdrem.overgeared.config.ClientConfig;
import net.stirdrem.overgeared.event.AnvilMinigameEvents;

@OnlyIn(value=Dist.CLIENT)
public class PopupOverlay {
    private static final float POPUP_DURATION_MS = 10000.0f;
    public static final IGuiOverlay POPUP_OVERLAY = (gui, guiGraphics, partialTick, screenWidth, screenHeight) -> {
        if (!((Boolean)ClientConfig.POP_UP_TOGGLE.get()).booleanValue()) {
            return;
        }
        List<AnvilMinigameEvents.Popup> popups = AnvilMinigameEvents.getPopups();
        if (popups.isEmpty()) {
            return;
        }
        int y = screenHeight + 20 - (Integer)ClientConfig.MINIGAME_OVERLAY_HEIGHT.get();
        for (int i = 0; i < popups.size(); ++i) {
            AnvilMinigameEvents.Popup popup = popups.get(i);
            float progress = popup.age / 10000.0f;
            progress = Math.min(progress, 1.0f);
            float alpha = 1.0f - progress;
            float floatUp = progress * 12.0f;
            float scale = 1.0f + (1.0f - progress) * 0.15f;
            int color = (int)(alpha * 255.0f) << 24 | 0xFFFFFF;
            Font font = Minecraft.m_91087_().f_91062_;
            int textWidth = font.m_92852_((FormattedText)popup.text);
            float yOffset = (float)i * 6.0f;
            float popupY = (float)screenHeight / 2.0f - 40.0f - floatUp - yOffset;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)screenWidth / 2.0f, popupY, 0.0f);
            guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
            guiGraphics.m_280614_(font, popup.text, -textWidth / 2, screenHeight / 2 - 18 - (Integer)ClientConfig.MINIGAME_OVERLAY_HEIGHT.get(), color, false);
            guiGraphics.m_280168_().m_85849_();
        }
    };
}

