/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.datapack;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class GrindingBlacklistReloadListener
extends SimpleJsonResourceReloadListener {
    private static final Map<ResourceLocation, Ingredient> DATA = new ConcurrentHashMap<ResourceLocation, Ingredient>();
    public static final GrindingBlacklistReloadListener INSTANCE = new GrindingBlacklistReloadListener();
    private static final Gson GSON = new Gson();

    public GrindingBlacklistReloadListener() {
        super(GSON, "grinding_blacklist");
    }

    protected void apply(Map<ResourceLocation, JsonElement> resources, ResourceManager resourceManager, ProfilerFiller profiler) {
        DATA.clear();
        System.out.println("Found " + resources.size() + " grinding blacklist resources:");
        for (ResourceLocation resourceLocation : resources.keySet()) {
            System.out.println(" - " + resourceLocation);
        }
        for (Map.Entry entry : resources.entrySet()) {
            ResourceLocation id = (ResourceLocation)entry.getKey();
            JsonElement jsonElement = (JsonElement)entry.getValue();
            try {
                if (jsonElement.isJsonObject()) {
                    JsonObject json = jsonElement.getAsJsonObject();
                    Ingredient ingredient = this.parseIngredient(json);
                    DATA.put(id, ingredient);
                    continue;
                }
                throw new JsonSyntaxException("Expected JSON object for grinding blacklist entry: " + id);
            }
            catch (Exception e) {
                System.err.println("Failed to parse grinding blacklist entry: " + id + ", error: " + e.getMessage());
                e.printStackTrace();
            }
        }
        System.out.println("Loaded " + DATA.size() + " grinding blacklist entries");
        for (Map.Entry entry : DATA.entrySet()) {
            System.out.println("Blacklist entry: " + entry.getKey() + " -> " + Arrays.toString(((Ingredient)entry.getValue()).m_43908_()));
        }
    }

    private Ingredient parseIngredient(JsonObject json) {
        if (!json.has("item")) {
            throw new JsonSyntaxException("Missing 'item' for grinding blacklist entry");
        }
        JsonElement itemElement = json.get("item");
        return Ingredient.m_43917_((JsonElement)itemElement);
    }

    public static Map<ResourceLocation, Ingredient> getData() {
        return Collections.unmodifiableMap(DATA);
    }

    public static List<Ingredient> getAllIngredients() {
        return List.copyOf(DATA.values());
    }

    public static List<ItemStack> getAllBlacklistedItems() {
        ArrayList<ItemStack> allItems = new ArrayList<ItemStack>();
        for (Ingredient ingredient : DATA.values()) {
            ItemStack[] stacks = ingredient.m_43908_();
            if (stacks.length <= 0) continue;
            Collections.addAll(allItems, stacks);
        }
        return allItems;
    }

    public static boolean isBlacklisted(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        for (Ingredient ingredient : DATA.values()) {
            if (!ingredient.test(stack)) continue;
            return true;
        }
        return false;
    }

    public static void clear() {
        DATA.clear();
    }
}

