/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.stirdrem.overgeared.config.ServerConfig;
import net.stirdrem.overgeared.event.ModItemInteractEvents;
import net.stirdrem.overgeared.networking.ModMessages;
import net.stirdrem.overgeared.networking.packet.SetMinigameVisibleC2SPacket;

@Mod.EventBusSubscriber(modid="overgeared", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class AnvilMinigameEvents {
    public static UUID ownerUUID = null;
    private static boolean isVisible = false;
    public static boolean minigameStarted = false;
    public static ItemStack resultItem = null;
    public static int hitsRemaining = 0;
    public static int maxHits = 0;
    public static float arrowPosition = 1.0f;
    public static float arrowSpeed = 0.0f;
    public static float maxArrowSpeed = 0.0f;
    public static float speedIncreasePerHit = 0.0f;
    public static boolean movingRight = true;
    public static int perfectHits = 0;
    public static int goodHits = 0;
    public static int missedHits = 0;
    public static int perfectZoneStart = 45;
    public static int perfectZoneEnd = 55;
    public static int goodZoneStart = 35;
    public static int goodZoneEnd = 65;
    public static float zoneShrinkFactor = 0.95f;
    public static float zoneShiftAmount = 15.0f;
    public static float perfectZoneSize = perfectZoneEnd - perfectZoneStart;
    public static float minPerfectSize = 4.0f;
    public static Map<BlockPos, UUID> occupiedAnvils = Collections.synchronizedMap(new HashMap());
    public static int skillLevel = 0;
    private static int TICKS_PER_PRINT = 1;
    private static int tickAccumulator = 0;
    private static boolean movingDown = false;
    private static final List<Popup> POPUPS = new ArrayList<Popup>();
    private static final float POPUP_DURATION_MS = 10000.0f;
    private static int lastPerfect = 0;
    private static int lastGood = 0;
    private static int lastMiss = 0;
    private static float currentPerfectZoneSize = 0.0f;
    private static float currentGoodZoneSize = 0.0f;

    public static void ensureInitialized() {
        if (arrowSpeed == 0.0f) {
            AnvilMinigameEvents.setupForQuality("none");
        }
    }

    public static void setupForQuality(String quality) {
        switch (quality.toLowerCase()) {
            case "none": {
                arrowSpeed = ((Double)ServerConfig.DEFAULT_ARROW_SPEED.get()).floatValue();
                speedIncreasePerHit = ((Double)ServerConfig.DEFAULT_ARROW_SPEED_INCREASE.get()).floatValue();
                maxArrowSpeed = ((Double)ServerConfig.DEFAULT_MAX_ARROW_SPEED.get()).floatValue();
                zoneShrinkFactor = ((Double)ServerConfig.DEFAULT_ZONE_SHRINK_FACTOR.get()).floatValue();
                perfectZoneStart = (100 - (Integer)ServerConfig.DEFAULT_ZONE_STARTING_SIZE.get()) / 2;
                perfectZoneEnd = (100 + (Integer)ServerConfig.DEFAULT_ZONE_STARTING_SIZE.get()) / 2;
                goodZoneStart = Math.max((100 - (Integer)ServerConfig.DEFAULT_ZONE_STARTING_SIZE.get() * 3) / 2, 1);
                goodZoneEnd = Math.min((100 + (Integer)ServerConfig.DEFAULT_ZONE_STARTING_SIZE.get() * 3) / 2, 100);
                minPerfectSize = ((Integer)ServerConfig.DEFAULT_MIN_PERFECT_ZONE.get()).intValue();
                perfectZoneSize = perfectZoneEnd - perfectZoneStart;
                break;
            }
            case "master": {
                arrowSpeed = ((Double)ServerConfig.MASTER_ARROW_SPEED.get()).floatValue();
                speedIncreasePerHit = ((Double)ServerConfig.MASTER_ARROW_SPEED_INCREASE.get()).floatValue();
                maxArrowSpeed = ((Double)ServerConfig.MASTER_MAX_ARROW_SPEED.get()).floatValue();
                zoneShrinkFactor = ((Double)ServerConfig.MASTER_ZONE_SHRINK_FACTOR.get()).floatValue();
                perfectZoneStart = (100 - (Integer)ServerConfig.MASTER_ZONE_STARTING_SIZE.get()) / 2;
                perfectZoneEnd = (100 + (Integer)ServerConfig.MASTER_ZONE_STARTING_SIZE.get()) / 2;
                goodZoneStart = Math.max((100 - (Integer)ServerConfig.MASTER_ZONE_STARTING_SIZE.get() * 3) / 2, 1);
                goodZoneEnd = Math.min((100 + (Integer)ServerConfig.MASTER_ZONE_STARTING_SIZE.get() * 3) / 2, 100);
                minPerfectSize = ((Integer)ServerConfig.MASTER_MIN_PERFECT_ZONE.get()).intValue();
                perfectZoneSize = perfectZoneEnd - perfectZoneStart;
                break;
            }
            case "perfect": {
                arrowSpeed = ((Double)ServerConfig.PERFECT_ARROW_SPEED.get()).floatValue();
                speedIncreasePerHit = ((Double)ServerConfig.PERFECT_ARROW_SPEED_INCREASE.get()).floatValue();
                maxArrowSpeed = ((Double)ServerConfig.PERFECT_MAX_ARROW_SPEED.get()).floatValue();
                zoneShrinkFactor = ((Double)ServerConfig.PERFECT_ZONE_SHRINK_FACTOR.get()).floatValue();
                perfectZoneStart = (100 - (Integer)ServerConfig.PERFECT_ZONE_STARTING_SIZE.get()) / 2;
                perfectZoneEnd = (100 + (Integer)ServerConfig.PERFECT_ZONE_STARTING_SIZE.get()) / 2;
                goodZoneStart = Math.max((100 - (Integer)ServerConfig.PERFECT_ZONE_STARTING_SIZE.get() * 3) / 2, 1);
                goodZoneEnd = Math.min((100 + (Integer)ServerConfig.PERFECT_ZONE_STARTING_SIZE.get() * 3) / 2, 100);
                minPerfectSize = ((Integer)ServerConfig.PERFECT_MIN_PERFECT_ZONE.get()).intValue();
                perfectZoneSize = perfectZoneEnd - perfectZoneStart;
                break;
            }
            case "expert": {
                arrowSpeed = ((Double)ServerConfig.EXPERT_ARROW_SPEED.get()).floatValue();
                speedIncreasePerHit = ((Double)ServerConfig.EXPERT_ARROW_SPEED_INCREASE.get()).floatValue();
                maxArrowSpeed = ((Double)ServerConfig.EXPERT_MAX_ARROW_SPEED.get()).floatValue();
                zoneShrinkFactor = ((Double)ServerConfig.EXPERT_ZONE_SHRINK_FACTOR.get()).floatValue();
                perfectZoneStart = (100 - (Integer)ServerConfig.EXPERT_ZONE_STARTING_SIZE.get()) / 2;
                perfectZoneEnd = (100 + (Integer)ServerConfig.EXPERT_ZONE_STARTING_SIZE.get()) / 2;
                goodZoneStart = Math.max((100 - (Integer)ServerConfig.EXPERT_ZONE_STARTING_SIZE.get() * 3) / 2, 1);
                goodZoneEnd = Math.min((100 + (Integer)ServerConfig.EXPERT_ZONE_STARTING_SIZE.get() * 3) / 2, 100);
                minPerfectSize = ((Integer)ServerConfig.EXPERT_MIN_PERFECT_ZONE.get()).intValue();
                perfectZoneSize = perfectZoneEnd - perfectZoneStart;
                break;
            }
            case "well": {
                arrowSpeed = ((Double)ServerConfig.WELL_ARROW_SPEED.get()).floatValue();
                speedIncreasePerHit = ((Double)ServerConfig.WELL_ARROW_SPEED_INCREASE.get()).floatValue();
                maxArrowSpeed = ((Double)ServerConfig.WELL_MAX_ARROW_SPEED.get()).floatValue();
                zoneShrinkFactor = ((Double)ServerConfig.WELL_ZONE_SHRINK_FACTOR.get()).floatValue();
                perfectZoneStart = (100 - (Integer)ServerConfig.WELL_ZONE_STARTING_SIZE.get()) / 2;
                perfectZoneEnd = (100 + (Integer)ServerConfig.WELL_ZONE_STARTING_SIZE.get()) / 2;
                goodZoneStart = Math.max((100 - (Integer)ServerConfig.WELL_ZONE_STARTING_SIZE.get() * 3) / 2, 1);
                goodZoneEnd = Math.min((100 + (Integer)ServerConfig.WELL_ZONE_STARTING_SIZE.get() * 3) / 2, 100);
                minPerfectSize = ((Integer)ServerConfig.WELL_MIN_PERFECT_ZONE.get()).intValue();
                perfectZoneSize = perfectZoneEnd - perfectZoneStart;
                break;
            }
            default: {
                arrowSpeed = ((Double)ServerConfig.POOR_ARROW_SPEED.get()).floatValue();
                speedIncreasePerHit = ((Double)ServerConfig.POOR_ARROW_SPEED_INCREASE.get()).floatValue();
                maxArrowSpeed = ((Double)ServerConfig.POOR_MAX_ARROW_SPEED.get()).floatValue();
                zoneShrinkFactor = ((Double)ServerConfig.POOR_ZONE_SHRINK_FACTOR.get()).floatValue();
                perfectZoneStart = (100 - (Integer)ServerConfig.POOR_ZONE_STARTING_SIZE.get()) / 2;
                perfectZoneEnd = (100 + (Integer)ServerConfig.POOR_ZONE_STARTING_SIZE.get()) / 2;
                goodZoneStart = Math.max((100 - (Integer)ServerConfig.POOR_ZONE_STARTING_SIZE.get() * 3) / 2, 1);
                goodZoneEnd = Math.min((100 + (Integer)ServerConfig.POOR_ZONE_STARTING_SIZE.get() * 3) / 2, 100);
                minPerfectSize = ((Integer)ServerConfig.POOR_MIN_PERFECT_ZONE.get()).intValue();
                perfectZoneSize = perfectZoneEnd - perfectZoneStart;
            }
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        AnvilMinigameEvents.ensureInitialized();
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        if (!mc.m_91104_()) {
            AnvilMinigameEvents.updatePopups();
        }
        if (mc.m_91104_() || !AnvilMinigameEvents.isIsVisible()) {
            return;
        }
        if (++tickAccumulator < TICKS_PER_PRINT) {
            return;
        }
        tickAccumulator = 0;
        if (arrowPosition >= 100.0f) {
            movingDown = true;
        } else if (arrowPosition <= 1.0f) {
            movingDown = false;
        }
        float delta = arrowSpeed * (float)(movingDown ? -1 : 1);
        arrowPosition = Math.max(1.0f, Math.min(arrowPosition + delta, 100.0f));
    }

    private static void updatePopups() {
        for (int i = 0; i < POPUPS.size(); ++i) {
            Popup popup = POPUPS.get(i);
            popup.age += Minecraft.m_91087_().m_91297_() * 1000.0f;
            if (!(popup.age >= 10000.0f)) continue;
            POPUPS.remove(i--);
        }
    }

    public static void triggerPopup(Component text) {
        POPUPS.add(new Popup(text));
    }

    public static List<Popup> getPopups() {
        return POPUPS;
    }

    public static void speedUp() {
        arrowSpeed = Math.min(arrowSpeed + speedIncreasePerHit, maxArrowSpeed);
    }

    public static float getArrowPosition() {
        return arrowPosition;
    }

    public static boolean isIsVisible() {
        return isVisible;
    }

    public static void setIsVisible(BlockPos pos, boolean isVisible) {
        AnvilMinigameEvents.isVisible = isVisible;
        ModMessages.sendToServer(new SetMinigameVisibleC2SPacket(pos, isVisible));
    }

    public static void resetPopUps() {
        POPUPS.clear();
    }

    public static void reset(String blueprintQuality) {
        isVisible = false;
        minigameStarted = false;
        hitsRemaining = 0;
        perfectHits = 0;
        goodHits = 0;
        missedHits = 0;
        arrowPosition = 50.0f;
        movingDown = false;
        currentPerfectZoneSize = 0.0f;
        currentGoodZoneSize = 0.0f;
        lastPerfect = 0;
        lastGood = 0;
        lastMiss = 0;
        AnvilMinigameEvents.setupForQuality(blueprintQuality);
        AnvilMinigameEvents.randomizeCenter();
    }

    public static void reset() {
        isVisible = false;
        minigameStarted = false;
        hitsRemaining = 0;
        perfectHits = 0;
        goodHits = 0;
        missedHits = 0;
        arrowPosition = 50.0f;
        movingDown = false;
        lastPerfect = 0;
        lastGood = 0;
        lastMiss = 0;
        AnvilMinigameEvents.setupForQuality("none");
        AnvilMinigameEvents.randomizeCenter();
    }

    private static int clamp(int value, int min, int max) {
        return Math.max(min, Math.min(max, value));
    }

    private static void randomizeCenter() {
        float randomCenter = 20.0f + (float)Math.random() * 60.0f;
        float zoneSize = perfectZoneEnd - perfectZoneStart;
        float goodZoneSize = goodZoneEnd - goodZoneStart;
        int halfPerfect = (int)(zoneSize / 2.0f);
        int halfGood = (int)(goodZoneSize / 2.0f);
        perfectZoneStart = AnvilMinigameEvents.clamp((int)randomCenter - halfPerfect, 0, 100);
        perfectZoneEnd = AnvilMinigameEvents.clamp((int)randomCenter + halfPerfect, 0, 100);
        goodZoneStart = AnvilMinigameEvents.clamp((int)randomCenter - halfGood, 0, 100);
        goodZoneEnd = AnvilMinigameEvents.clamp((int)randomCenter + halfGood, 0, 100);
    }

    public static int getPerfectZoneStart() {
        return perfectZoneStart;
    }

    public static int getPerfectZoneEnd() {
        return perfectZoneEnd;
    }

    public static int getGoodZoneStart() {
        return goodZoneStart;
    }

    public static int getGoodZoneEnd() {
        return goodZoneEnd;
    }

    public static int getHitsRemaining() {
        return hitsRemaining;
    }

    public static int getMaxHits() {
        return maxHits;
    }

    public static int getPerfectHits() {
        return perfectHits;
    }

    public static int getGoodHits() {
        return goodHits;
    }

    public static int getMissedHits() {
        return missedHits;
    }

    public static String handleHit() {
        arrowSpeed = Math.min(arrowSpeed + speedIncreasePerHit, maxArrowSpeed);
        if (arrowPosition >= (float)perfectZoneStart && arrowPosition <= (float)perfectZoneEnd) {
            lastPerfect = ++perfectHits;
            AnvilMinigameEvents.triggerPopup((Component)Component.m_237115_((String)"overgeared.forging.perfect").m_130938_(s -> s.m_131136_(Boolean.valueOf(true)).m_178520_(16766720)));
        } else if (arrowPosition >= (float)goodZoneStart && arrowPosition <= (float)goodZoneEnd) {
            lastGood = ++goodHits;
            AnvilMinigameEvents.triggerPopup((Component)Component.m_237115_((String)"overgeared.forging.good").m_130938_(s -> s.m_131136_(Boolean.valueOf(true)).m_178520_(0x55FF55)));
        } else {
            lastMiss = ++missedHits;
            AnvilMinigameEvents.triggerPopup((Component)Component.m_237115_((String)"overgeared.forging.miss").m_130938_(s -> s.m_131136_(Boolean.valueOf(true)).m_178520_(0xFF5555)));
        }
        AnvilMinigameEvents.shrinkAndShiftZones();
        if (--hitsRemaining <= 0) {
            return AnvilMinigameEvents.finishForging();
        }
        return "poor";
    }

    public static void setHitsRemaining(int hitsRemaining) {
        AnvilMinigameEvents.hitsRemaining = hitsRemaining;
        maxHits = hitsRemaining;
    }

    public static String finishForging() {
        isVisible = false;
        minigameStarted = false;
        int totalHits = perfectHits + goodHits + missedHits;
        float qualityScore = 0.0f;
        if (totalHits > 0) {
            qualityScore = ((float)perfectHits * 1.0f + (float)goodHits * 0.6f) / (float)totalHits;
        }
        if ((double)qualityScore > (Double)ServerConfig.PERFECT_QUALITY_SCORE.get()) {
            return "perfect";
        }
        if ((double)qualityScore > (Double)ServerConfig.EXPERT_QUALITY_SCORE.get()) {
            return "expert";
        }
        if ((double)qualityScore > (Double)ServerConfig.WELL_QUALITY_SCORE.get()) {
            return "well";
        }
        return "poor";
    }

    public static void shrinkAndShiftZones() {
        if (currentPerfectZoneSize == 0.0f || currentGoodZoneSize == 0.0f) {
            currentPerfectZoneSize = perfectZoneEnd - perfectZoneStart;
            currentGoodZoneSize = goodZoneEnd - goodZoneStart;
        }
        currentPerfectZoneSize = Math.max(minPerfectSize, currentPerfectZoneSize * zoneShrinkFactor);
        currentGoodZoneSize = Math.max(currentPerfectZoneSize * 3.0f, currentGoodZoneSize * zoneShrinkFactor);
        float oldPerfectCenter = (float)(perfectZoneStart + perfectZoneEnd) / 2.0f;
        float oldGoodCenter = (float)(goodZoneStart + goodZoneEnd) / 2.0f;
        int oldPerfectStart = perfectZoneStart;
        int oldPerfectEnd = perfectZoneEnd;
        int oldGoodStart = goodZoneStart;
        int oldGoodEnd = goodZoneEnd;
        int newPerfectStart = perfectZoneStart;
        int newPerfectEnd = perfectZoneEnd;
        int newGoodStart = goodZoneStart;
        int newGoodEnd = goodZoneEnd;
        for (int attempts = 0; attempts < 30; ++attempts) {
            boolean goodTooClose;
            float newCenter = AnvilMinigameEvents.getWeightedRandomCenter(50.0f);
            int pStart = Math.round(newCenter - currentPerfectZoneSize / 2.0f);
            int pEnd = Math.round(newCenter + currentPerfectZoneSize / 2.0f);
            int gStart = Math.round(newCenter - currentGoodZoneSize / 2.0f);
            int gEnd = Math.round(newCenter + currentGoodZoneSize / 2.0f);
            pStart = AnvilMinigameEvents.clamp(pStart, 0, 100);
            pEnd = AnvilMinigameEvents.clamp(pEnd, 0, 100);
            gStart = AnvilMinigameEvents.clamp(gStart, 0, 100);
            gEnd = AnvilMinigameEvents.clamp(gEnd, 0, 100);
            float newPerfectCenter = (float)(pStart + pEnd) / 2.0f;
            float newGoodCenter = (float)(gStart + gEnd) / 2.0f;
            float minCenterDiff = 5.0f;
            float minEdgeDiff = 3.0f;
            boolean perfectTooClose = Math.abs(newPerfectCenter - oldPerfectCenter) < minCenterDiff || (float)Math.abs(pStart - oldPerfectStart) < minEdgeDiff || (float)Math.abs(pEnd - oldPerfectEnd) < minEdgeDiff;
            boolean bl = goodTooClose = Math.abs(newGoodCenter - oldGoodCenter) < minCenterDiff || (float)Math.abs(gStart - oldGoodStart) < minEdgeDiff || (float)Math.abs(gEnd - oldGoodEnd) < minEdgeDiff;
            if (perfectTooClose || goodTooClose) continue;
            newPerfectStart = pStart;
            newPerfectEnd = pEnd;
            newGoodStart = gStart;
            newGoodEnd = gEnd;
            break;
        }
        perfectZoneStart = newPerfectStart;
        perfectZoneEnd = newPerfectEnd;
        goodZoneStart = newGoodStart;
        goodZoneEnd = newGoodEnd;
    }

    private static boolean edgesTooCloseOrOverlapping(int newStart, int newEnd, int oldStart, int oldEnd, float overlapRatio, boolean clampedLeft, boolean clampedRight) {
        float overlapFraction;
        int newSize = Math.max(1, newEnd - newStart);
        int tolerance = 1;
        boolean startClose = Math.abs(newStart - oldStart) <= tolerance;
        boolean endClose = Math.abs(newEnd - oldEnd) <= tolerance;
        int overlap = Math.min(newEnd, oldEnd) - Math.max(newStart, oldStart);
        float f = overlapFraction = overlap > 0 ? (float)overlap / (float)newSize : 0.0f;
        if (clampedLeft && newStart == 0 && oldStart == 0 || clampedRight && newEnd == 100 && oldEnd == 100) {
            return overlapFraction > overlapRatio && (clampedLeft && endClose || clampedRight && startClose);
        }
        return startClose && endClose || overlapFraction > overlapRatio;
    }

    private static float getWeightedRandomCenter(float bias) {
        float rand = (float)Math.random();
        float weighted = (float)Math.pow(rand, 1.5);
        return bias + (weighted - 0.5f) * 100.0f;
    }

    public static BlockPos getAnvilPos(UUID playerId) {
        return ModItemInteractEvents.playerAnvilPositions.getOrDefault(playerId, BlockPos.f_121853_);
    }

    public static void setAnvilPos(UUID playerId, BlockPos pos) {
        ModItemInteractEvents.playerAnvilPositions.put(playerId, pos);
    }

    public static void clearAnvilPos(UUID playerId) {
        ModItemInteractEvents.playerAnvilPositions.remove(playerId);
    }

    public static void setMinigameStarted(BlockPos pos, boolean minigameStarted) {
        AnvilMinigameEvents.minigameStarted = minigameStarted;
    }

    public static UUID getOccupiedAnvil(BlockPos pos) {
        return occupiedAnvils.get(pos);
    }

    public static void putOccupiedAnvil(BlockPos pos, UUID me) {
        occupiedAnvils.put(pos, me);
    }

    public static boolean hasAnvilPosition(UUID playerId) {
        BlockPos pos = ModItemInteractEvents.playerAnvilPositions.get(playerId);
        return pos != null && !pos.equals((Object)BlockPos.f_121853_);
    }

    public static void hideMinigame(UUID playerId) {
        isVisible = false;
        BlockPos pos = ModItemInteractEvents.playerAnvilPositions.get(playerId);
        if (pos != null && !pos.equals((Object)BlockPos.f_121853_)) {
            ModMessages.sendToServer(new SetMinigameVisibleC2SPacket(pos, false));
        }
    }

    public static class Popup {
        public final Component text;
        public float age;

        public Popup(Component text) {
            this.text = text;
            this.age = 0.0f;
        }
    }
}

