/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.networking.packet;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.stirdrem.overgeared.block.entity.AbstractSmithingAnvilBlockEntity;
import net.stirdrem.overgeared.event.ModItemInteractEvents;

public class SetMinigameVisibleC2SPacket {
    private final Boolean visible;
    private final BlockPos pos;

    public SetMinigameVisibleC2SPacket(BlockPos pos, Boolean visible) {
        this.visible = visible;
        this.pos = pos;
    }

    public static void encode(SetMinigameVisibleC2SPacket pkt, FriendlyByteBuf buf) {
        buf.m_130064_(pkt.pos);
        buf.writeBoolean(pkt.visible.booleanValue());
    }

    public static SetMinigameVisibleC2SPacket decode(FriendlyByteBuf buf) {
        return new SetMinigameVisibleC2SPacket(buf.m_130135_(), buf.readBoolean());
    }

    public Boolean getVisible() {
        return this.visible;
    }

    public static void handle(SetMinigameVisibleC2SPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockEntity patt1490$temp;
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender != null && (patt1490$temp = sender.m_9236_().m_7702_(msg.pos)) instanceof AbstractSmithingAnvilBlockEntity) {
                AbstractSmithingAnvilBlockEntity anvilBlock = (AbstractSmithingAnvilBlockEntity)patt1490$temp;
                anvilBlock.setMinigameOn(msg.getVisible());
                ModItemInteractEvents.playerMinigameVisibility.put(sender.m_20148_(), msg.getVisible());
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

