/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.datapack;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.stirdrem.overgeared.OvergearedMod;
import net.stirdrem.overgeared.datapack.BlueprintTooltypesData;
import net.stirdrem.overgeared.item.ToolTypeRegistry;

public class BlueprintTooltypesReloadListener
extends SimpleJsonResourceReloadListener {
    public static final Map<ResourceLocation, BlueprintTooltypesData> DATA = new HashMap<ResourceLocation, BlueprintTooltypesData>();
    private static final Gson GSON = new Gson();

    public BlueprintTooltypesReloadListener() {
        super(GSON, "blueprint_tooltypes");
    }

    protected void apply(Map<ResourceLocation, JsonElement> objects, ResourceManager resourceManager, ProfilerFiller profiler) {
        DATA.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : objects.entrySet()) {
            ResourceLocation id = entry.getKey();
            JsonObject json = entry.getValue().getAsJsonObject();
            try {
                if (!json.has("tooltypes")) {
                    throw new JsonSyntaxException("Missing 'tooltypes' array: " + id);
                }
                JsonArray arr = json.getAsJsonArray("tooltypes");
                ArrayList<String> toolTypes = new ArrayList<String>();
                for (JsonElement e : arr) {
                    toolTypes.add(e.getAsString().toLowerCase(Locale.ROOT));
                }
                BlueprintTooltypesData data = new BlueprintTooltypesData(id, toolTypes);
                DATA.put(id, data);
            }
            catch (Exception e) {
                OvergearedMod.LOGGER.error("Failed to load blueprint tooltypes: {}", (Object)id, (Object)e);
            }
        }
        OvergearedMod.LOGGER.info("Loaded {} blueprint tooltype packs", (Object)DATA.size());
        ToolTypeRegistry.init();
    }
}

