/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.mixin;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PotionItem.class})
public abstract class PotionItemMixin {
    @Unique
    private static final String TIPPED_USED_TAG = "TippedUsed";
    @Unique
    private static final float MIN_DURATION_SCALE = 0.1f;

    @Inject(method={"finishUsingItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/alchemy/PotionUtils;getMobEffects(Lnet/minecraft/world/item/ItemStack;)Ljava/util/List;")}, cancellable=true)
    private void onFinishUsing(ItemStack stack, Level level, LivingEntity entity, CallbackInfoReturnable<ItemStack> cir) {
        ItemStack resultStack;
        if (stack.m_41619_() || !stack.m_41782_() || !stack.m_41783_().m_128441_(TIPPED_USED_TAG)) {
            return;
        }
        Player player = entity instanceof Player ? (Player)entity : null;
        int tippedUsed = stack.m_41783_().m_128451_(TIPPED_USED_TAG);
        float scale = PotionItemMixin.calculateDurationScale(tippedUsed);
        if (!level.f_46443_) {
            for (MobEffectInstance effect : PotionUtils.m_43547_((ItemStack)stack)) {
                if (effect.m_19544_().m_8093_()) {
                    effect.m_19544_().m_19461_((Entity)player, (Entity)player, entity, effect.m_19564_(), 1.0);
                    continue;
                }
                entity.m_7292_(PotionItemMixin.createScaledEffect(effect, scale));
            }
        }
        if (player != null) {
            player.m_36246_(Stats.f_12982_.m_12902_((Object)((PotionItem)this)));
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
        }
        ItemStack itemStack = resultStack = stack.m_41619_() ? new ItemStack((ItemLike)Items.f_42590_) : stack;
        if (player != null && !player.m_150110_().f_35937_ && stack.m_41619_()) {
            player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42590_));
        }
        entity.m_146850_(GameEvent.f_223704_);
        cir.setReturnValue((Object)resultStack);
    }

    @ModifyArg(method={"appendHoverText"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/alchemy/PotionUtils;addPotionTooltip(Lnet/minecraft/world/item/ItemStack;Ljava/util/List;F)V"), index=2)
    private float modifyTooltipDurationScale(ItemStack stack, List<Component> tooltip, float originalScale) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(TIPPED_USED_TAG)) {
            int tippedUsed = stack.m_41783_().m_128451_(TIPPED_USED_TAG);
            return PotionItemMixin.calculateDurationScale(tippedUsed);
        }
        return originalScale;
    }

    @Unique
    private static float calculateDurationScale(int tippedUsed) {
        return Math.max(0.1f, 1.0f - (float)tippedUsed / 8.0f);
    }

    @Unique
    private static MobEffectInstance createScaledEffect(MobEffectInstance original, float scale) {
        return new MobEffectInstance(original.m_19544_(), Math.max(1, (int)((float)original.m_19557_() * scale)), original.m_19564_(), original.m_19571_(), original.m_19572_(), original.m_19575_());
    }
}

