/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.stirdrem.overgeared.recipe.ModRecipeTypes;
import net.stirdrem.overgeared.recipe.ModRecipes;

public class ItemToToolTypeRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final Ingredient input;
    private final String toolType;

    public ItemToToolTypeRecipe(ResourceLocation id, Ingredient input, String toolType) {
        this.id = id;
        this.input = input;
        this.toolType = toolType;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public String getToolType() {
        return this.toolType;
    }

    public boolean matches(SimpleContainer container, Level level) {
        return this.input.test(container.m_8020_(0));
    }

    public ItemStack assemble(SimpleContainer container, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.ITEM_TO_TOOLTYPE.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.ITEM_TO_TOOLTYPE.get();
    }

    public List<ItemStack> getItems() {
        return List.of(this.input.m_43908_());
    }

    public static class Serializer
    implements RecipeSerializer<ItemToToolTypeRecipe> {
        public ItemToToolTypeRecipe fromJson(ResourceLocation id, JsonObject json) {
            if (!json.has("item")) {
                throw new JsonSyntaxException("Missing 'item' for item_to_tooltype recipe");
            }
            JsonElement itemElement = json.get("item");
            Ingredient input = Ingredient.m_43917_((JsonElement)itemElement);
            String toolType = json.get("tooltype").getAsString();
            return new ItemToToolTypeRecipe(id, input, toolType);
        }

        public ItemToToolTypeRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buf);
            String toolType = buf.m_130277_();
            return new ItemToToolTypeRecipe(id, input, toolType);
        }

        public void toNetwork(FriendlyByteBuf buf, ItemToToolTypeRecipe recipe) {
            recipe.input.m_43923_(buf);
            buf.m_130070_(recipe.toolType);
        }
    }
}

