/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.advancement;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class MakeSmithingAnvilTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public static final ResourceLocation ID = ResourceLocation.m_214293_((String)"overgeared", (String)"make_smithing_anvil");

    public ResourceLocation m_7295_() {
        return ID;
    }

    protected TriggerInstance createInstance(JsonObject json, ContextAwarePredicate player, DeserializationContext context) {
        String tier = null;
        if (json.has("tier")) {
            tier = json.get("tier").getAsString();
        }
        return new TriggerInstance(player, tier);
    }

    public void trigger(ServerPlayer player, String tierUsed) {
        this.m_66234_(player, instance -> instance.matches(tierUsed));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        @Nullable
        private final String tier;

        public TriggerInstance(ContextAwarePredicate player, @Nullable String tier) {
            super(ID, player);
            this.tier = tier;
        }

        public boolean matches(String tierUsed) {
            if (this.tier == null) {
                return true;
            }
            return this.tier.equals(tierUsed);
        }
    }
}

