/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.block.entity;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.stirdrem.overgeared.AnvilTier;
import net.stirdrem.overgeared.BlueprintQuality;
import net.stirdrem.overgeared.ForgingQuality;
import net.stirdrem.overgeared.OvergearedMod;
import net.stirdrem.overgeared.advancement.ModAdvancementTriggers;
import net.stirdrem.overgeared.block.custom.AbstractSmithingAnvilNew;
import net.stirdrem.overgeared.config.ServerConfig;
import net.stirdrem.overgeared.event.ModEvents;
import net.stirdrem.overgeared.recipe.ForgingRecipe;
import net.stirdrem.overgeared.util.ModTags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSmithingAnvilBlockEntity
extends BlockEntity
implements MenuProvider {
    protected static final int INPUT_SLOT = 0;
    protected static final int OUTPUT_SLOT = 10;
    protected final ItemStackHandler itemHandler = new ItemStackHandler(12){

        protected void onContentsChanged(int slot) {
            AbstractSmithingAnvilBlockEntity.this.m_6596_();
            if (!AbstractSmithingAnvilBlockEntity.this.f_58857_.m_5776_()) {
                AbstractSmithingAnvilBlockEntity.this.f_58857_.m_7260_(AbstractSmithingAnvilBlockEntity.this.m_58899_(), AbstractSmithingAnvilBlockEntity.this.m_58900_(), AbstractSmithingAnvilBlockEntity.this.m_58900_(), 3);
            }
        }
    };
    protected final ContainerData data;
    protected LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected int progress;
    protected int maxProgress;
    protected int hitRemains;
    protected long busyUntilGameTime = 0L;
    protected UUID ownerUUID = null;
    protected Map<BlockPos, UUID> occupiedAnvils = Collections.synchronizedMap(new HashMap());
    protected AnvilTier anvilTier;
    protected long sessionStartTime = 0L;
    protected ItemStack failedResult;
    protected Player player;
    protected ForgingRecipe lastRecipe = null;
    protected ItemStack lastBlueprint = ItemStack.f_41583_;
    private boolean minigameOn = false;
    protected AbstractSmithingAnvilNew anvilBlock;
    protected static final int BLUEPRINT_SLOT = 11;
    private static final String HEATED_TIME_TAG = "HeatedSince";

    public AbstractSmithingAnvilBlockEntity(AbstractSmithingAnvilNew anvilBlock, AnvilTier tier, BlockEntityType<?> type, BlockPos pPos, BlockState pBlockState) {
        super(type, pPos, pBlockState);
        this.anvilTier = tier;
        this.anvilBlock = anvilBlock;
        this.data = new ContainerData(){

            public int m_6413_(int pIndex) {
                return switch (pIndex) {
                    case 0 -> AbstractSmithingAnvilBlockEntity.this.progress;
                    case 1 -> AbstractSmithingAnvilBlockEntity.this.maxProgress;
                    case 2 -> AbstractSmithingAnvilBlockEntity.this.hitRemains;
                    default -> 0;
                };
            }

            public void m_8050_(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        AbstractSmithingAnvilBlockEntity.this.progress = pValue;
                        break;
                    }
                    case 1: {
                        AbstractSmithingAnvilBlockEntity.this.maxProgress = pValue;
                    }
                }
            }

            public int m_6499_() {
                return 3;
            }
        };
    }

    public static void applyForgingQuality(ItemStack stack, ForgingQuality quality) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_("ForgingQuality", quality.getDisplayName());
    }

    public ItemStack getRenderStack(int index) {
        return this.itemHandler.getStackInSlot(index);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.of(() -> this.itemHandler).cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"gui.overgeared.smithing_anvil");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("hitRemains", this.hitRemains);
        tag.m_128405_("progress", this.progress);
        tag.m_128405_("maxProgress", this.maxProgress);
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        if (this.ownerUUID != null) {
            tag.m_128362_("ownerUUID", this.ownerUUID);
            tag.m_128356_("sessionStartTime", this.sessionStartTime);
        }
        ListTag occupiedList = new ListTag();
        for (Map.Entry<BlockPos, UUID> entry : this.occupiedAnvils.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            BlockPos pos = entry.getKey();
            entryTag.m_128405_("x", pos.m_123341_());
            entryTag.m_128405_("y", pos.m_123342_());
            entryTag.m_128405_("z", pos.m_123343_());
            entryTag.m_128362_("uuid", entry.getValue());
            occupiedList.add((Object)entryTag);
        }
        tag.m_128365_("occupiedAnvils", (Tag)occupiedList);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("inventory")) {
            this.itemHandler.deserializeNBT(tag.m_128469_("inventory"));
        }
        if (tag.m_128441_("hitRemains")) {
            this.hitRemains = tag.m_128451_("hitRemains");
        }
        if (tag.m_128441_("progress")) {
            this.progress = tag.m_128451_("progress");
        }
        if (tag.m_128441_("maxProgress")) {
            this.maxProgress = tag.m_128451_("maxProgress");
        }
        if (tag.m_128403_("ownerUUID")) {
            this.ownerUUID = tag.m_128342_("ownerUUID");
            this.sessionStartTime = tag.m_128454_("sessionStartTime");
        } else {
            this.ownerUUID = null;
        }
        this.occupiedAnvils.clear();
        if (tag.m_128425_("occupiedAnvils", 9)) {
            ListTag occupiedList = tag.m_128437_("occupiedAnvils", 10);
            for (int i = 0; i < occupiedList.size(); ++i) {
                CompoundTag entryTag = occupiedList.m_128728_(i);
                int x = entryTag.m_128451_("x");
                int y = entryTag.m_128451_("y");
                int z = entryTag.m_128451_("z");
                UUID uuid = entryTag.m_128342_("uuid");
                this.occupiedAnvils.put(new BlockPos(x, y, z), uuid);
            }
        }
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public void increaseForgingProgress(Level pLevel, BlockPos pPos, BlockState pState) {
        Optional<ForgingRecipe> recipe = this.getCurrentRecipe();
        if (this.hasRecipe()) {
            ForgingRecipe currentRecipe = recipe.get();
            this.maxProgress = currentRecipe.getHammeringRequired();
            this.increaseCraftingProgress();
            AbstractSmithingAnvilBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            if (this.hasProgressFinished()) {
                this.craftItem();
                this.resetProgress(pPos);
            }
        } else {
            this.resetProgress(pPos);
        }
    }

    public void resetProgress(BlockPos pos) {
        this.progress = 0;
        this.maxProgress = 0;
        this.lastRecipe = null;
        if (!this.f_58857_.m_5776_()) {
            ModEvents.resetMinigameForPlayer((ServerPlayer)this.player);
        }
        this.player = null;
    }

    protected void craftItem() {
        String quality;
        int i;
        Optional<ForgingRecipe> recipeOptional = this.getCurrentRecipe();
        if (recipeOptional.isEmpty()) {
            return;
        }
        ForgingRecipe recipe = recipeOptional.get();
        ItemStack result = recipe.m_8043_(this.m_58904_().m_9598_());
        this.failedResult = recipe.getFailedResultItem(this.m_58904_().m_9598_());
        ForgingQuality minimumQuality = recipe.getMinimumQuality();
        ForgingQuality maxIngredientQuality = null;
        for (i = 0; i < 9; ++i) {
            ForgingQuality q;
            ItemStack ingredient = this.itemHandler.getStackInSlot(i);
            if (!ingredient.m_41782_() || !ingredient.m_41783_().m_128441_("ForgingQuality") || (q = ForgingQuality.fromString(ingredient.m_41783_().m_128461_("ForgingQuality"))) == null || maxIngredientQuality != null && q.ordinal() <= maxIngredientQuality.ordinal()) continue;
            maxIngredientQuality = q;
        }
        if (recipe.hasQuality() && this.player != null && ((Boolean)ServerConfig.PLAYER_AUTHOR_TOOLTIPS.get()).booleanValue()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("Creator", this.player.m_7755_().getString());
            result.m_41751_(tag);
        }
        if (recipe.hasQuality()) {
            ForgingQuality quality2;
            String qualityStr;
            if (((Boolean)ServerConfig.ENABLE_MINIGAME.get()).booleanValue() && !Objects.equals(qualityStr = this.determineForgingQuality(), ForgingQuality.NONE.getDisplayName()) && (quality2 = ForgingQuality.fromString(qualityStr)) != null) {
                if (minimumQuality != null && quality2.ordinal() < minimumQuality.ordinal()) {
                    quality2 = minimumQuality;
                }
                if (maxIngredientQuality != null && quality2.ordinal() > maxIngredientQuality.ordinal() && ((Boolean)ServerConfig.INGREDIENTS_DEFINE_MAX_QUALITY.get()).booleanValue()) {
                    quality2 = maxIngredientQuality;
                }
                CompoundTag tag = result.m_41784_();
                if (quality2 == ForgingQuality.PERFECT && (Double)ServerConfig.MASTER_QUALITY_CHANCE.get() != 0.0) {
                    Random random = new Random();
                    if ((double)random.nextFloat() < (Double)ServerConfig.MASTER_QUALITY_CHANCE.get()) {
                        quality2 = ForgingQuality.MASTER;
                    }
                }
                tag.m_128359_("ForgingQuality", quality2.getDisplayName());
                Player player = this.player;
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ModAdvancementTriggers.FORGING_QUALITY.trigger(serverPlayer, quality2.getDisplayName());
                }
                if (!(result.m_41720_() instanceof ArmorItem) && !(result.m_41720_() instanceof ShieldItem) && recipe.hasPolishing()) {
                    tag.m_128379_("Polished", false);
                }
                if (!(!recipe.needQuenching() || result.m_204117_(ModTags.Items.HEATED_METALS) && result.m_204117_(ModTags.Items.HOT_ITEMS))) {
                    tag.m_128379_("Heated", true);
                    result.m_41751_(tag);
                }
            }
        } else if (recipe.needsMinigame() && ((Boolean)ServerConfig.ENABLE_MINIGAME.get()).booleanValue() && !Objects.equals(quality = this.determineForgingQuality(), ForgingQuality.NONE.getDisplayName())) {
            boolean fail = false;
            if (quality.equals(ForgingQuality.POOR.getDisplayName())) {
                fail = true;
            } else if (quality.equals(ForgingQuality.WELL.getDisplayName())) {
                float failChance = ((Double)ServerConfig.FAIL_ON_WELL_QUALITY_CHANCE.get()).floatValue();
                fail = new Random().nextFloat() < failChance;
            } else if (quality.equals(ForgingQuality.EXPERT.getDisplayName())) {
                float failChance = ((Double)ServerConfig.FAIL_ON_EXPERT_QUALITY_CHANCE.get()).floatValue();
                boolean bl = fail = new Random().nextFloat() < failChance;
            }
            if (fail) {
                result = this.failedResult.m_41777_();
            }
        }
        for (i = 0; i < 9; ++i) {
            this.itemHandler.extractItem(i, 1, false);
        }
        ItemStack existing = this.itemHandler.getStackInSlot(10);
        if (existing.m_41619_()) {
            this.itemHandler.setStackInSlot(10, result);
        } else if (ItemStack.m_150942_((ItemStack)existing, (ItemStack)result)) {
            int maxSize;
            int total = existing.m_41613_() + result.m_41613_();
            if (total <= (maxSize = Math.min(existing.m_41741_(), this.itemHandler.getSlotLimit(10)))) {
                existing.m_41769_(result.m_41613_());
                this.itemHandler.setStackInSlot(10, existing);
            } else {
                int remainder = total - maxSize;
                existing.m_41764_(maxSize);
                this.itemHandler.setStackInSlot(10, existing);
                ItemStack overflow = result.m_41777_();
                overflow.m_41764_(remainder);
                Containers.m_18992_((Level)this.m_58904_(), (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (ItemStack)overflow);
            }
        }
    }

    protected void craftItemWithBlueprint() {
        CompoundTag tag;
        ItemStack result = this.itemHandler.getStackInSlot(10);
        if (result.m_41619_()) {
            return;
        }
        ItemStack blueprint = this.itemHandler.getStackInSlot(11);
        if (!blueprint.m_41619_() && blueprint.m_41782_() && (tag = blueprint.m_41784_()).m_128441_("Quality") && tag.m_128441_("Uses") && tag.m_128441_("UsesToLevel")) {
            String currentQualityStr = tag.m_128461_("Quality");
            int uses = tag.m_128451_("Uses");
            int usesToLevel = tag.m_128451_("UsesToLevel");
            BlueprintQuality currentQuality = BlueprintQuality.fromString(currentQualityStr);
            String forgingQualityStr = this.anvilBlock.getQuality();
            ForgingQuality resultQuality = ForgingQuality.fromString(forgingQualityStr);
            if (currentQuality != null && currentQuality != BlueprintQuality.PERFECT && currentQuality != BlueprintQuality.MASTER) {
                if (!((Boolean)ServerConfig.EXPERT_ABOVE_INCREASE_BLUEPRINT.get()).booleanValue() || resultQuality.ordinal() >= ForgingQuality.EXPERT.ordinal()) {
                    uses += (switch (resultQuality) {
                        case ForgingQuality.PERFECT -> 2;
                        case ForgingQuality.MASTER -> 3;
                        default -> 1;
                    });
                }
                if (uses >= usesToLevel) {
                    BlueprintQuality nextQuality = BlueprintQuality.getNext(currentQuality);
                    if (nextQuality != null) {
                        tag.m_128359_("Quality", nextQuality.getDisplayName());
                        tag.m_128405_("Uses", 0);
                        tag.m_128405_("UsesToLevel", nextQuality.getUse());
                        Player player = this.player;
                        if (player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            if (nextQuality.equals((Object)BlueprintQuality.PERFECT) || nextQuality.equals((Object)BlueprintQuality.MASTER)) {
                                ModAdvancementTriggers.MAX_LEVEL_BLUEPRINT.trigger(serverPlayer);
                            }
                            ModAdvancementTriggers.BLUEPRINT_QUALITY.trigger(serverPlayer, nextQuality.getDisplayName());
                        }
                    } else {
                        tag.m_128405_("Uses", usesToLevel);
                    }
                } else {
                    tag.m_128405_("Uses", uses);
                }
                blueprint.m_41751_(tag);
                this.itemHandler.setStackInSlot(11, blueprint);
            }
        }
    }

    public boolean isFailedResult() {
        ItemStack result = this.itemHandler.getStackInSlot(10);
        return ItemStack.m_41656_((ItemStack)result, (ItemStack)this.failedResult);
    }

    public boolean hasRecipe() {
        Optional<ForgingRecipe> recipeOptional = this.getCurrentRecipe();
        if (recipeOptional.isEmpty()) {
            return false;
        }
        ForgingRecipe recipe = recipeOptional.get();
        AnvilTier requiredTier = AnvilTier.fromDisplayName(recipe.getAnvilTier());
        if (requiredTier == null || !requiredTier.isEqualOrLowerThan(this.anvilTier)) {
            return false;
        }
        ItemStack resultStack = recipe.m_8043_(this.f_58857_.m_9598_());
        return this.canInsertItemIntoOutputSlot(resultStack) && this.canInsertAmountIntoOutputSlot(resultStack.m_41613_());
    }

    public boolean hasRecipeWithBlueprint() {
        ItemStack resultStack;
        Optional<ForgingRecipe> recipeOptional = this.getCurrentRecipe();
        if (recipeOptional.isEmpty()) {
            return false;
        }
        ForgingRecipe recipe = recipeOptional.get();
        AnvilTier requiredTier = AnvilTier.fromDisplayName(recipe.getAnvilTier());
        if (requiredTier == null || !requiredTier.isEqualOrLowerThan(this.anvilTier)) {
            return false;
        }
        ItemStack blueprint = this.itemHandler.getStackInSlot(11);
        if (recipe.requiresBlueprint()) {
            if (blueprint.m_41619_() || !blueprint.m_41782_() || !blueprint.m_41783_().m_128441_("ToolType")) {
                return false;
            }
            blueprintToolType = blueprint.m_41783_().m_128461_("ToolType").toLowerCase(Locale.ROOT);
            if (!recipe.getBlueprintTypes().contains(blueprintToolType)) {
                return false;
            }
        } else if (!blueprint.m_41619_() && blueprint.m_41782_() && blueprint.m_41783_().m_128441_("ToolType")) {
            blueprintToolType = blueprint.m_41783_().m_128461_("ToolType").toLowerCase(Locale.ROOT);
            if (!recipe.getBlueprintTypes().contains(blueprintToolType)) {
                return false;
            }
        }
        return this.canInsertItemIntoOutputSlot(resultStack = recipe.m_8043_(this.f_58857_.m_9598_())) && this.canInsertAmountIntoOutputSlot(resultStack.m_41613_());
    }

    public Optional<ForgingRecipe> getCurrentRecipe() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < 9; ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        inventory.m_6836_(11, this.itemHandler.getStackInSlot(11));
        return ForgingRecipe.findBestMatch(this.f_58857_, (Container)inventory).filter(this::matchesRecipeExactly);
    }

    protected boolean canInsertItemIntoOutputSlot(ItemStack stackToInsert) {
        ItemStack existing = this.itemHandler.getStackInSlot(10);
        return existing.m_41619_() || ItemStack.m_150942_((ItemStack)existing, (ItemStack)stackToInsert);
    }

    protected boolean canInsertAmountIntoOutputSlot(int count) {
        return this.itemHandler.getStackInSlot(10).m_41613_() + count <= this.itemHandler.getStackInSlot(10).m_41741_();
    }

    public boolean hasProgressFinished() {
        return this.progress >= this.maxProgress;
    }

    public void increaseCraftingProgress() {
        ++this.progress;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
        if (this.data != null) {
            this.data.m_8050_(0, this.progress);
            this.data.m_8050_(1, this.maxProgress);
            this.data.m_8050_(2, this.hitRemains);
        }
    }

    public boolean isBusy(long currentGameTime) {
        return currentGameTime < this.busyUntilGameTime;
    }

    public void setBusyUntil(long time) {
        this.busyUntilGameTime = time;
        AbstractSmithingAnvilBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.f_58858_, (BlockState)this.m_58900_());
    }

    public void tick(Level lvl, BlockPos pos, BlockState st) {
        if (!pos.equals((Object)this.f_58858_)) {
            return;
        }
        try {
            ItemStack currentBlueprint = this.itemHandler.getStackInSlot(11);
            if (!ItemStack.m_150942_((ItemStack)currentBlueprint, (ItemStack)this.lastBlueprint) && (this.progress > 0 || this.lastRecipe != null || this.isMinigameOn())) {
                this.resetProgress(pos);
                this.setMinigameOn(false);
                OvergearedMod.LOGGER.debug("Blueprint changed at {}, minigame reset", (Object)pos);
            }
            this.lastBlueprint = currentBlueprint.m_41777_();
            Optional<ForgingRecipe> currentRecipeOpt = this.getCurrentRecipe();
            if (currentRecipeOpt.isEmpty()) {
                if (this.progress > 0 || this.lastRecipe != null) {
                    this.resetProgress(pos);
                }
                return;
            }
            ForgingRecipe currentRecipe = currentRecipeOpt.get();
            boolean recipeChanged = false;
            if (this.lastRecipe != null) {
                recipeChanged = !currentRecipe.m_6423_().equals((Object)this.lastRecipe.m_6423_());
            } else if (this.maxProgress > 0) {
                recipeChanged = true;
            }
            if (recipeChanged) {
                this.resetProgress(pos);
                this.lastRecipe = currentRecipe;
                return;
            }
            this.lastRecipe = currentRecipe;
            if (this.hasRecipe()) {
                this.maxProgress = currentRecipe.getHammeringRequired();
                this.hitRemains = this.maxProgress - this.progress;
                AbstractSmithingAnvilBlockEntity.m_155232_((Level)lvl, (BlockPos)pos, (BlockState)st);
                if (this.hasProgressFinished()) {
                    this.craftItem();
                    this.resetProgress(pos);
                }
            } else if (this.progress > 0 || this.maxProgress > 0) {
                this.resetProgress(pos);
            }
        }
        catch (Exception e) {
            OvergearedMod.LOGGER.error("Error ticking smithing anvil at {}", (Object)pos, (Object)e);
            this.resetProgress(pos);
        }
        this.tickHeatedIngredients(lvl);
    }

    public int getHitsRemaining() {
        return this.hitRemains;
    }

    public ContainerData getContainerData() {
        return this.data;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("progress", this.progress);
        tag.m_128405_("maxProgress", this.maxProgress);
        tag.m_128405_("hitRemains", this.hitRemains);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        if (tag.m_128441_("progress")) {
            this.progress = tag.m_128451_("progress");
        }
        if (tag.m_128441_("maxProgress")) {
            this.maxProgress = tag.m_128451_("maxProgress");
        }
        if (tag.m_128441_("hitRemains")) {
            this.hitRemains = tag.m_128451_("hitRemains");
        }
    }

    protected boolean matchesRecipeExactly(ForgingRecipe recipe) {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < 9; ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        inventory.m_6836_(11, this.itemHandler.getStackInSlot(11));
        return recipe.m_5818_((Container)inventory, this.f_58857_);
    }

    protected String determineForgingQuality() {
        String quality = this.anvilBlock.getQuality();
        if (quality == null) {
            return "well";
        }
        Optional<ForgingRecipe> recipeOptional = this.getCurrentRecipe();
        ForgingRecipe recipe = recipeOptional.get();
        if (!recipe.getBlueprintTypes().isEmpty()) {
            ItemStack blueprint = this.itemHandler.getStackInSlot(11);
            List<String> qualityTiers = List.of("poor", "well", "expert", "perfect", "master");
            if (blueprint.m_41619_() || !blueprint.m_41782_()) {
                return switch (quality.toLowerCase()) {
                    case "poor" -> ForgingQuality.POOR.getDisplayName();
                    default -> "well";
                };
            }
            CompoundTag nbt = blueprint.m_41783_();
            if (nbt == null || !nbt.m_128441_("Quality")) {
                return switch (quality.toLowerCase()) {
                    case "poor" -> ForgingQuality.POOR.getDisplayName();
                    default -> "well";
                };
            }
            String blueprintToolType = nbt.m_128461_("Quality").toLowerCase();
            int anvilTierIndex = qualityTiers.indexOf(quality.toLowerCase());
            int blueprintTierIndex = qualityTiers.indexOf(blueprintToolType);
            if (anvilTierIndex == -1 || blueprintTierIndex == -1) {
                return ForgingQuality.NONE.getDisplayName();
            }
            int finalIndex = Math.min(anvilTierIndex, blueprintTierIndex);
            switch (qualityTiers.get(finalIndex)) {
                case "poor": {
                    return ForgingQuality.POOR.getDisplayName();
                }
                case "well": {
                    return ForgingQuality.WELL.getDisplayName();
                }
                case "expert": {
                    return ForgingQuality.EXPERT.getDisplayName();
                }
                case "perfect": {
                    boolean ingredientMasterRoll;
                    Random random = new Random();
                    boolean hasMasterIngredient = false;
                    for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                        String ingQuality;
                        ItemStack stack;
                        if (i == 10 || i == 11 || (stack = this.itemHandler.getStackInSlot(i)).m_41619_() || !stack.m_41782_() || !stack.m_41783_().m_128441_("ForgingQuality") || !"master".equals(ingQuality = stack.m_41783_().m_128461_("ForgingQuality").toLowerCase())) continue;
                        hasMasterIngredient = true;
                        break;
                    }
                    boolean masterRoll = (Double)ServerConfig.MASTER_QUALITY_CHANCE.get() != 0.0 && (double)random.nextFloat() < (Double)ServerConfig.MASTER_QUALITY_CHANCE.get();
                    boolean bl = ingredientMasterRoll = hasMasterIngredient && (double)random.nextFloat() < (Double)ServerConfig.MASTER_FROM_INGREDIENT_CHANCE.get();
                    if ("master".equals(blueprintToolType) || masterRoll || ingredientMasterRoll) {
                        return ForgingQuality.MASTER.getDisplayName();
                    }
                    return ForgingQuality.PERFECT.getDisplayName();
                }
                case "master": {
                    return ForgingQuality.MASTER.getDisplayName();
                }
            }
            return ForgingQuality.WELL.getDisplayName();
        }
        return quality;
    }

    public String minigameQuality() {
        Optional<ForgingRecipe> recipeOptional = this.getCurrentRecipe();
        if (recipeOptional.isEmpty()) {
            return "none";
        }
        ForgingRecipe recipe = recipeOptional.get();
        if (!recipe.getBlueprintTypes().isEmpty()) {
            if (!recipe.getQualityDifficulty().equals((Object)ForgingQuality.NONE)) {
                return recipe.getQualityDifficulty().getDisplayName();
            }
            return this.blueprintQuality();
        }
        return recipe.getQualityDifficulty().getDisplayName();
    }

    public String blueprintQuality() {
        String quality = this.anvilBlock.getQuality();
        if (quality == null) {
            return ForgingQuality.NONE.getDisplayName();
        }
        Optional<ForgingRecipe> recipeOptional = this.getCurrentRecipe();
        if (recipeOptional.isEmpty()) {
            return "poor";
        }
        ForgingRecipe recipe = recipeOptional.get();
        if (!recipe.getBlueprintTypes().isEmpty()) {
            String poor;
            if (!recipe.getQualityDifficulty().equals((Object)ForgingQuality.NONE)) {
                return recipe.getQualityDifficulty().getDisplayName();
            }
            ItemStack blueprint = this.itemHandler.getStackInSlot(11);
            List<String> qualityTiers = List.of("poor", "well", "expert", "perfect", "master");
            String string = poor = quality.equalsIgnoreCase("poor") ? ForgingQuality.POOR.getDisplayName() : ForgingQuality.NONE.getDisplayName();
            if (blueprint.m_41619_() || !blueprint.m_41782_()) {
                return poor;
            }
            CompoundTag nbt = blueprint.m_41783_();
            if (nbt == null || !nbt.m_128441_("Quality")) {
                return poor;
            }
            String bpQuality = nbt.m_128461_("Quality").toLowerCase();
            return qualityTiers.contains(bpQuality) ? bpQuality : ForgingQuality.NONE.getDisplayName();
        }
        return ForgingQuality.NONE.getDisplayName();
    }

    public void setProgress(int progress) {
        this.progress = progress;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
        if (this.data != null) {
            this.data.m_8050_(0, progress);
        }
    }

    public int getRequiredProgress() {
        return this.getCurrentRecipe().map(ForgingRecipe::getHammeringRequired).orElse(0);
    }

    public int getProgress() {
        if (this.f_58857_ != null && this.f_58857_.m_5776_() && this.data != null) {
            return this.data.m_6413_(0);
        }
        return this.progress;
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
    }

    public void setOwner(UUID uuid) {
        this.ownerUUID = uuid;
        this.sessionStartTime = this.f_58857_.m_46467_();
        this.m_6596_();
    }

    public void clearOwner() {
        this.ownerUUID = null;
        this.sessionStartTime = 0L;
        this.m_6596_();
    }

    public boolean isOwnedBy(Player player) {
        return this.ownerUUID != null && this.ownerUUID.equals(player.m_20148_());
    }

    public boolean isOwned() {
        return this.ownerUUID != null;
    }

    public UUID getOccupiedAnvil(BlockPos pos) {
        return this.occupiedAnvils.get(pos);
    }

    public void putOccupiedAnvil(BlockPos pos, UUID me) {
        this.occupiedAnvils.put(pos, me);
    }

    public boolean hasQuality() {
        Optional<ForgingRecipe> recipeOptional = this.getCurrentRecipe();
        if (recipeOptional.isEmpty()) {
            return false;
        }
        ForgingRecipe recipe = recipeOptional.get();
        return recipe.hasQuality();
    }

    public boolean needsMinigame() {
        Optional<ForgingRecipe> recipeOptional = this.getCurrentRecipe();
        if (recipeOptional.isEmpty()) {
            return false;
        }
        ForgingRecipe recipe = recipeOptional.get();
        return !recipe.hasQuality() && recipe.needsMinigame();
    }

    public IItemHandlerModifiable getItemHandler() {
        return this.itemHandler;
    }

    public BlockPos getPos(ServerPlayer serverPlayer) {
        UUID playerUUID = serverPlayer.m_20148_();
        for (Map.Entry<BlockPos, UUID> entry : this.occupiedAnvils.entrySet()) {
            if (!entry.getValue().equals(playerUUID)) continue;
            return entry.getKey();
        }
        return null;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public boolean isMinigameOn() {
        return this.minigameOn;
    }

    public void setMinigameOn(boolean value) {
        this.minigameOn = value;
        this.m_6596_();
    }

    public void tickHeatedIngredients(Level level) {
        if (level.f_46443_) {
            return;
        }
        long tick = level.m_46467_();
        int cooldownTicks = (Integer)ServerConfig.HEATED_ITEM_COOLDOWN_TICKS.get();
        for (int slot = 0; slot < 9; ++slot) {
            Item cooled;
            ItemStack stack = this.itemHandler.getStackInSlot(slot);
            if (stack.m_41619_() || !stack.m_204117_(ModTags.Items.HEATED_METALS)) continue;
            CompoundTag tag = stack.m_41784_();
            long heatedSince = tag.m_128454_(HEATED_TIME_TAG);
            if (heatedSince == 0L) {
                tag.m_128356_(HEATED_TIME_TAG, tick);
                continue;
            }
            if (tick - heatedSince < (long)cooldownTicks || (cooled = OvergearedMod.getCooledItem(stack.m_41720_(), level)) == null) continue;
            ItemStack newStack = new ItemStack((ItemLike)cooled, stack.m_41613_());
            if (stack.m_41782_()) {
                CompoundTag oldTag = stack.m_41783_().m_6426_();
                oldTag.m_128473_(HEATED_TIME_TAG);
                if (oldTag.m_128456_()) {
                    newStack.m_41751_(null);
                } else {
                    newStack.m_41751_(oldTag);
                }
            }
            level.m_5594_(null, this.f_58858_, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.itemHandler.setStackInSlot(slot, newStack);
            level.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }
}

