/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.block.entity;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import net.stirdrem.overgeared.block.entity.ModBlockEntities;
import net.stirdrem.overgeared.recipe.CastingRecipe;
import net.stirdrem.overgeared.recipe.ModRecipeTypes;
import net.stirdrem.overgeared.util.ConfigHelper;
import net.stirdrem.overgeared.util.ModTags;

public class CastFurnaceBlockEntity
extends BaseContainerBlockEntity
implements MenuProvider,
WorldlyContainer {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_FUEL = 1;
    public static final int SLOT_OUTPUT = 2;
    public static final int SLOT_CAST = 3;
    private final NonNullList<ItemStack> items = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private int burnTime;
    private int burnTimeTotal;
    private int cookTime;
    private int cookTimeTotal = 200;
    private static final int[] UP = new int[]{0};
    private static final int[] DOWN = new int[]{2};
    private static final int[] SIDE = new int[]{1, 3};

    public CastFurnaceBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.CAST_FURNACE_BE.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CastFurnaceBlockEntity be) {
        boolean dirty = false;
        if (be.isBurning()) {
            --be.burnTime;
        }
        ItemStack fuel = (ItemStack)be.items.get(1);
        ItemStack input = (ItemStack)be.items.get(0);
        ItemStack cast = (ItemStack)be.items.get(3);
        if (be.isBurning() || !fuel.m_41619_() && !input.m_41619_() && !cast.m_41619_()) {
            if (!be.isBurning() && be.canSmelt()) {
                be.burnTimeTotal = be.burnTime = ForgeHooks.getBurnTime((ItemStack)fuel, (RecipeType)RecipeType.f_44108_);
                if (be.isBurning()) {
                    fuel.m_41774_(1);
                    dirty = true;
                }
            }
            if (be.isBurning() && be.canSmelt()) {
                ++be.cookTime;
                if (be.cookTime >= be.cookTimeTotal) {
                    be.cookTime = 0;
                    be.smelt();
                    dirty = true;
                }
            } else {
                be.cookTime = 0;
            }
        }
        if (dirty) {
            CastFurnaceBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private boolean isBurning() {
        return this.burnTime > 0;
    }

    private boolean canSmelt() {
        if (this.f_58857_ == null) {
            return false;
        }
        Optional recipe = this.f_58857_.m_7465_().m_44015_((RecipeType)ModRecipeTypes.CASTING.get(), (Container)this, this.f_58857_);
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack result = ((CastingRecipe)recipe.get()).m_8043_(this.f_58857_.m_9598_());
        ItemStack output = (ItemStack)this.items.get(2);
        if (output.m_41619_()) {
            return true;
        }
        if (!ItemStack.m_150942_((ItemStack)output, (ItemStack)result)) {
            return false;
        }
        return output.m_41613_() + result.m_41613_() <= output.m_41741_();
    }

    private void smelt() {
        if (!this.canSmelt()) {
            return;
        }
        Optional recipe = this.f_58857_.m_7465_().m_44015_((RecipeType)ModRecipeTypes.CASTING.get(), (Container)this, this.f_58857_);
        if (recipe.isEmpty()) {
            return;
        }
        ItemStack result = ((CastingRecipe)recipe.get()).m_5874_((Container)this, this.f_58857_.m_9598_());
        ((ItemStack)this.items.get(0)).m_41774_(1);
        ItemStack output = (ItemStack)this.items.get(2);
        if (output.m_41619_()) {
            this.items.set(2, (Object)result.m_41777_());
        } else {
            output.m_41769_(result.m_41613_());
        }
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        return this.items.stream().allMatch(ItemStack::m_41619_);
    }

    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    public ItemStack m_7407_(int slot, int count) {
        return ContainerHelper.m_18969_(this.items, (int)slot, (int)count);
    }

    public ItemStack m_8016_(int slot) {
        return ContainerHelper.m_18966_(this.items, (int)slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.items.set(slot, (Object)stack);
        if (slot == 0) {
            this.cookTime = 0;
        }
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        return switch (slot) {
            case 2 -> false;
            case 1 -> {
                if (ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_) > 0) {
                    yield true;
                }
                yield false;
            }
            case 3 -> stack.m_204117_(ModTags.Items.TOOL_CAST);
            case 0 -> ConfigHelper.isValidMaterial(stack);
            default -> false;
        };
    }

    public int[] m_7071_(Direction dir) {
        return switch (dir) {
            case Direction.DOWN -> DOWN;
            case Direction.UP -> UP;
            default -> SIDE;
        };
    }

    public boolean m_7157_(int slot, ItemStack stack, Direction dir) {
        return slot == 2;
    }

    public boolean m_7155_(int slot, ItemStack stack, Direction dir) {
        return this.m_7013_(slot, stack);
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.overgeared.cast_furnace");
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory inv) {
        return null;
    }

    public void m_6211_() {
        this.items.clear();
    }
}

