/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.stirdrem.overgeared.config.ClientConfig;
import net.stirdrem.overgeared.event.AnvilMinigameEvents;

@OnlyIn(value=Dist.CLIENT)
public class AnvilMinigameOverlay {
    private static final ResourceLocation TEXTURE = ResourceLocation.m_214293_((String)"overgeared", (String)"textures/gui/smithing_anvil_minigame.png");
    public static final int barTotalWidth = 184;
    private static final int ARROW_WIDTH = 8;
    private static final int ARROW_HEIGHT = 16;
    public static final IGuiOverlay ANVIL_MG = (gui, guiGraphics, partialTick, screenWidth, screenHeight) -> {
        int perfectStartPx;
        int perfectEndPx;
        boolean showMainOverlay = AnvilMinigameEvents.isIsVisible();
        if (!showMainOverlay) {
            return;
        }
        int imageWidth = 238;
        int imageHeight = 37;
        int textureWidth = 256;
        int textureHeight = 128;
        int x = (screenWidth - imageWidth) / 2;
        int y = screenHeight - imageHeight - (Integer)ClientConfig.MINIGAME_OVERLAY_HEIGHT.get();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        guiGraphics.m_280163_(TEXTURE, x, y, 0.0f, 0.0f, imageWidth, imageHeight, textureWidth, textureHeight);
        int barX = x + 9;
        int barY = y + 21;
        int barWidth = 220;
        int barHeight = 10;
        int perfectZoneStart = AnvilMinigameEvents.getPerfectZoneStart();
        int perfectZoneEnd = AnvilMinigameEvents.getPerfectZoneEnd();
        int goodZoneStart = AnvilMinigameEvents.getGoodZoneStart();
        int goodZoneEnd = AnvilMinigameEvents.getGoodZoneEnd();
        float arrowPosition = AnvilMinigameEvents.getArrowPosition();
        int goodStartPx = (int)((float)(barWidth * goodZoneStart) / 100.0f);
        int goodEndPx = (int)((float)(barWidth * goodZoneEnd) / 100.0f);
        if (goodEndPx > goodStartPx) {
            guiGraphics.m_280163_(TEXTURE, barX + goodStartPx, barY, 9.0f, 94.0f, goodEndPx - goodStartPx, barHeight, textureWidth, textureHeight);
        }
        if ((perfectEndPx = (int)((float)(barWidth * perfectZoneEnd) / 100.0f)) > (perfectStartPx = (int)((float)(barWidth * perfectZoneStart) / 100.0f))) {
            guiGraphics.m_280163_(TEXTURE, barX + perfectStartPx, barY, 9.0f, 72.0f, perfectEndPx - perfectStartPx, barHeight, textureWidth, textureHeight);
        }
        int progressLengthPx = (int)(222.0f * (1.0f - (float)AnvilMinigameEvents.getHitsRemaining() / (float)AnvilMinigameEvents.getMaxHits()));
        guiGraphics.m_280163_(TEXTURE, x + 8, y + 12, 8.0f, 62.0f, progressLengthPx, 5, textureWidth, textureHeight);
        int arrowX = barX + (int)((float)barWidth * arrowPosition / 100.0f) - 5;
        guiGraphics.m_280163_(TEXTURE, arrowX, barY - 3, 9.0f, 41.0f, 8, 16, textureWidth, textureHeight);
        int hitsRemain = AnvilMinigameEvents.getHitsRemaining();
        int perfect = AnvilMinigameEvents.getPerfectHits();
        int good = AnvilMinigameEvents.getGoodHits();
        int miss = AnvilMinigameEvents.getMissedHits();
        MutableComponent stats = Component.m_237110_((String)"gui.overgeared.forging_stats", (Object[])new Object[]{hitsRemain, perfect, good, miss});
    };
}

