/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.compat;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.stirdrem.overgeared.item.ModItems;
import net.stirdrem.overgeared.recipe.RockKnappingRecipe;

public class KnappingRecipeCategory
implements IRecipeCategory<RockKnappingRecipe> {
    public static final ResourceLocation UID = ResourceLocation.m_214293_((String)"overgeared", (String)"rock_knapping");
    public static final ResourceLocation TEXTURE = ResourceLocation.m_214293_((String)"overgeared", (String)"textures/gui/rock_knapping_jei.png");
    private static final ResourceLocation CHIPPED_TEXTURE = ResourceLocation.m_214293_((String)"overgeared", (String)"textures/gui/blank.png");
    private static final ResourceLocation UNCHIPPED_TEXTURE = ResourceLocation.m_135820_((String)"textures/block/stone.png");
    public static final RecipeType<RockKnappingRecipe> KNAPPING_RECIPE_TYPE = new RecipeType(UID, RockKnappingRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private static final int WIDTH = 116;
    private static final int HEIGHT = 54;
    private final IGuiHelper helper;

    public KnappingRecipeCategory(IGuiHelper helper) {
        this.helper = helper;
        this.background = helper.createDrawable(TEXTURE, 29, 16, 116, 54);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModItems.ROCK.get()));
    }

    public RecipeType<RockKnappingRecipe> getRecipeType() {
        return KNAPPING_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"gui.overgeared.rock_knapping");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RockKnappingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 10000, 10000).addItemStack(new ItemStack((ItemLike)ModItems.ROCK.get()));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 95, 19).addItemStack(recipe.m_8043_(null));
    }

    public void draw(RockKnappingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.m_91087_();
        boolean[][] pattern = recipe.getPattern();
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int posX = 3 + x * 16;
                int posY = 3 + y * 16;
                ResourceLocation texture = pattern[y][x] ? UNCHIPPED_TEXTURE : CHIPPED_TEXTURE;
                guiGraphics.m_280163_(texture, posX, posY, 0.0f, 0.0f, 16, 16, 16, 16);
            }
        }
    }
}

