/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.stirdrem.overgeared.datagen.ModBlockStateProvider;
import net.stirdrem.overgeared.datagen.ModBlockTagGenerator;
import net.stirdrem.overgeared.datagen.ModGlobalLootModifiersProvider;
import net.stirdrem.overgeared.datagen.ModItemModelProvider;
import net.stirdrem.overgeared.datagen.ModItemTagGenerator;
import net.stirdrem.overgeared.datagen.ModLootTableProvider;
import net.stirdrem.overgeared.datagen.ModRecipeProvider;

@Mod.EventBusSubscriber(modid="overgeared", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)ModLootTableProvider.create(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new ModBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(packOutput, existingFileHelper));
        ModBlockTagGenerator blockTagGenerator = (ModBlockTagGenerator)generator.addProvider(event.includeServer(), (DataProvider)new ModBlockTagGenerator(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagGenerator(packOutput, lookupProvider, blockTagGenerator.m_274426_(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModGlobalLootModifiersProvider(packOutput));
    }
}

