/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.datagen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.stirdrem.overgeared.recipe.FletchingRecipe;

public class FletchingRecipeBuilder
implements RecipeBuilder {
    private final Ingredient tip;
    private final Ingredient shaft;
    private final Ingredient feather;
    private final ItemStack result;
    private ItemStack resultTipped = ItemStack.f_41583_;
    private String tippedTag = null;
    private ItemStack resultLingering = ItemStack.f_41583_;
    private String lingeringTag = null;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    private String group;

    public FletchingRecipeBuilder(Ingredient tip, Ingredient shaft, Ingredient feather, ItemStack result) {
        this.tip = tip;
        this.shaft = shaft;
        this.feather = feather;
        this.result = result;
    }

    public static FletchingRecipeBuilder fletching(Ingredient tip, Ingredient shaft, Ingredient feather, ItemLike result) {
        return FletchingRecipeBuilder.fletching(tip, shaft, feather, result, 1);
    }

    public static FletchingRecipeBuilder fletching(Ingredient tip, Ingredient shaft, Ingredient feather, ItemLike result, int count) {
        return new FletchingRecipeBuilder(tip, shaft, feather, new ItemStack(result, count));
    }

    public FletchingRecipeBuilder withTippedResult(ItemLike result) {
        return this.withTippedResult(result, this.result.m_41613_());
    }

    public FletchingRecipeBuilder withTippedResult(ItemLike result, int count) {
        return this.withTippedResult("Potion", result, count);
    }

    public FletchingRecipeBuilder withTippedResult(String tag, ItemLike result, int count) {
        this.resultTipped = new ItemStack(result, count);
        this.tippedTag = tag;
        return this;
    }

    public FletchingRecipeBuilder withTippedResult(String tag, ItemLike result) {
        this.resultLingering = new ItemStack(result, this.result.m_41613_());
        this.lingeringTag = tag;
        return this;
    }

    public FletchingRecipeBuilder withLingeringResult(ItemLike result) {
        return this.withLingeringResult(result, this.result.m_41613_());
    }

    public FletchingRecipeBuilder withLingeringResult(ItemLike result, int count) {
        return this.withLingeringResult("LingeringPotion", result, count);
    }

    public FletchingRecipeBuilder withLingeringResult(String tag, ItemLike result, int count) {
        this.resultLingering = new ItemStack(result, count);
        this.lingeringTag = tag;
        return this;
    }

    public FletchingRecipeBuilder withLingeringResult(String tag, ItemLike result) {
        this.resultLingering = new ItemStack(result, this.result.m_41613_());
        this.lingeringTag = tag;
        return this;
    }

    public RecipeBuilder m_126132_(String criterionName, CriterionTriggerInstance criterionTrigger) {
        this.advancement.m_138386_(criterionName, criterionTrigger);
        return this;
    }

    public RecipeBuilder m_126145_(@Nullable String groupName) {
        this.group = groupName;
        return this;
    }

    public Item m_142372_() {
        return this.result.m_41720_();
    }

    public void m_126140_(Consumer<FinishedRecipe> finishedRecipeConsumer, ResourceLocation recipeId) {
        this.ensureValid(recipeId);
        this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)recipeId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)recipeId)).m_138360_(RequirementsStrategy.f_15979_);
        finishedRecipeConsumer.accept(new Result(recipeId, this.group == null ? "" : this.group, this.tip, this.shaft, this.feather, this.result, this.resultTipped, this.tippedTag, this.resultLingering, this.lingeringTag, this.advancement, recipeId.m_246208_("recipes/fletching/")));
    }

    private void ensureValid(ResourceLocation id) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final String group;
        private final Ingredient tip;
        private final Ingredient shaft;
        private final Ingredient feather;
        private final ItemStack result;
        private final ItemStack resultTipped;
        private final String tippedTag;
        private final ItemStack resultLingering;
        private final String lingeringTag;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation id, String group, Ingredient tip, Ingredient shaft, Ingredient feather, ItemStack result, ItemStack resultTipped, String tippedTag, ItemStack resultLingering, String lingeringTag, Advancement.Builder advancement, ResourceLocation advancementId) {
            this.id = id;
            this.group = group;
            this.tip = tip;
            this.shaft = shaft;
            this.feather = feather;
            this.result = result;
            this.resultTipped = resultTipped;
            this.tippedTag = tippedTag;
            this.resultLingering = resultLingering;
            this.lingeringTag = lingeringTag;
            this.advancement = advancement;
            this.advancementId = advancementId;
        }

        public void m_7917_(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            JsonObject material = new JsonObject();
            material.add("tip", this.tip.m_43942_());
            material.add("shaft", this.shaft.m_43942_());
            material.add("feather", this.feather.m_43942_());
            json.add("material", (JsonElement)material);
            JsonObject resultJson = new JsonObject();
            resultJson.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)this.result.m_41720_()).toString());
            if (this.result.m_41613_() > 1) {
                resultJson.addProperty("count", (Number)this.result.m_41613_());
            }
            json.add("result", (JsonElement)resultJson);
            if (!this.resultTipped.m_41619_()) {
                JsonObject tippedJson = new JsonObject();
                tippedJson.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)this.resultTipped.m_41720_()).toString());
                if (this.tippedTag != null) {
                    tippedJson.addProperty("tag", this.tippedTag);
                }
                if (this.resultTipped.m_41613_() > 1) {
                    tippedJson.addProperty("count", (Number)this.resultTipped.m_41613_());
                }
                json.add("result_tipped", (JsonElement)tippedJson);
            }
            if (!this.resultLingering.m_41619_()) {
                JsonObject lingeringJson = new JsonObject();
                lingeringJson.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)this.resultLingering.m_41720_()).toString());
                if (this.lingeringTag != null) {
                    lingeringJson.addProperty("tag", this.lingeringTag);
                }
                if (this.resultLingering.m_41613_() > 1) {
                    lingeringJson.addProperty("count", (Number)this.resultLingering.m_41613_());
                }
                json.add("result_lingering", (JsonElement)lingeringJson);
            }
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return FletchingRecipe.Serializer.INSTANCE;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

